/*
 * Decompiled with CFR 0.152.
 */
package kid.cluster;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.ListIterator;
import kid.cluster.Comparison;
import kid.cluster.Vector;
import kid.data.Data;
import kid.data.Printable;
import kid.segmentation.Segmentable;
import robocode.RobocodeFileOutputStream;

public class Dimension<E extends Data, F extends Segmentable, G extends Segmentable>
implements Printable {
    private static final double percent = 0.05;
    private static double epsilon = 0.13;
    private LinkedList<Item> data;
    private Comparison comparison;
    private double maxValue;
    private double scale;

    public Dimension(Comparison c) {
        this.comparison = c;
        this.data = new LinkedList();
        this.maxValue = 0.0;
        this.scale = 100.0;
    }

    public void add(E d, F v, G r) {
        Vector<E, F, G> vector = new Vector<E, F, G>(d, v, r);
        this.add(vector);
    }

    public void add(Vector<E, F, G> vector) {
        Item i;
        ListIterator<Object> iter;
        boolean added = false;
        double value = this.comparison.value(vector);
        this.maxValue = Math.max(this.maxValue, Math.abs(value));
        if (this.data.size() == 0) {
            this.data.add(new Item(vector, value));
        } else if (value - this.data.getFirst().value < this.data.getLast().value - value) {
            iter = this.data.listIterator();
            while (iter.hasNext() && !added) {
                i = (Item)iter.next();
                if (!(value <= i.value)) continue;
                iter.previous();
                iter.add(new Item(vector, value));
                added = true;
            }
            if (!added) {
                iter.add(new Item(vector, value));
            }
        } else {
            iter = this.data.listIterator(this.data.size());
            while (iter.hasPrevious() && !added) {
                i = (Item)iter.previous();
                if (!(value >= i.value)) continue;
                iter.next();
                iter.add(new Item(vector, value));
                added = true;
            }
            if (!added) {
                iter.add(new Item(vector, value));
            }
        }
        boolean DO_SCALE = false;
        if (DO_SCALE) {
            E d = vector.getData();
            double max = d.max();
            ListIterator iter2 = this.data.listIterator();
            while (iter2.hasNext() && ((Item)iter2.next()).vector != vector) {
            }
            int addIndex = iter2.previousIndex();
            int indexWidth = (int)(0.05 * (double)this.data.size());
            int start = Math.max(addIndex - indexWidth, 0);
            int end = Math.min(addIndex + indexWidth, this.data.size() - 1);
            while (iter2.hasPrevious() && iter2.previousIndex() > start) {
                iter2.previous();
            }
            while (iter2.hasNext() && iter2.nextIndex() < end) {
                if (iter2.nextIndex() == addIndex) continue;
                double dif = epsilon - Math.abs(d.compare((Data)((Item)iter2.next()).vector.getData()) / max);
                this.scale += dif * 5.0;
            }
            if (this.scale < 0.0) {
                this.scale = 0.0;
            }
            if (this.scale < 50.0) {
                epsilon += 0.005;
            } else if (this.scale > 200.0) {
                epsilon -= 0.01;
            }
        }
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getScale() {
        return this.scale;
    }

    public int size() {
        return this.data.size();
    }

    public double dist(Vector<E, F, G> v1, Vector<E, F, G> v2) {
        return this.comparison.compare(v1, v2) / this.getMaxValue() * this.getScale();
    }

    public LinkedList<Vector<E, F, G>> getList(F view, G reference, int total) {
        ListIterator first = this.data.listIterator();
        ListIterator<Item> last = this.data.listIterator(this.data.size());
        if (this.data.size() > total) {
            Vector<Object, F, G> v = new Vector<Object, F, G>(null, view, reference);
            double value = this.comparison.value(v);
            while (last.previousIndex() - first.nextIndex() > total) {
                if (Math.abs(((Item)first.next()).value - value) > Math.abs(last.previous().value - value)) {
                    last.next();
                    continue;
                }
                first.previous();
            }
        }
        LinkedList list = new LinkedList();
        while (first.nextIndex() <= last.previousIndex()) {
            list.add(((Item)first.next()).vector);
        }
        return list;
    }

    @Override
    public void print(PrintStream console) {
        console.println(String.valueOf(this.comparison.toString()) + ": " + this.scale + ", " + this.data.size());
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    private class Item {
        protected Vector<E, F, G> vector;
        protected double value;

        public Item(Vector<E, F, G> vec, double val) {
            this.vector = vec;
            this.value = val;
        }
    }
}

