/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.CircularPrediction;
import agd.predict.Footprint;
import agd.predict.LinearPrediction;
import agd.util.Coord;
import java.util.List;
import java.util.ListIterator;

class AverageCircularPrediction
extends CircularPrediction {
    static LinearPrediction linearPrediction = new LinearPrediction();

    AverageCircularPrediction() {
    }

    public Coord predictTarget(List recentFootprints, long time) {
        Coord predictedPosition = null;
        if (recentFootprints.size() >= 2) {
            ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
            Footprint lastFp = (Footprint)lit.previous();
            Footprint lastBut1Fp = (Footprint)lit.previous();
            int i = 0;
            while (i < 5) {
                if (lit.hasPrevious()) {
                    lastBut1Fp = (Footprint)lit.previous();
                }
                ++i;
            }
            double rHeadingChangeRate = (lastFp.getHeading().getRadians() - lastBut1Fp.getHeading().getRadians()) / (double)(lastFp.getTime() - lastBut1Fp.getTime());
            long extrapolatePeriod = time - lastBut1Fp.getTime();
            predictedPosition = rHeadingChangeRate > 1.0E-8 ? CircularPrediction.circularPrediction(lastBut1Fp.getPosition(), lastBut1Fp.getHeading(), lastBut1Fp.getVelocity(), rHeadingChangeRate, extrapolatePeriod) : linearPrediction.predictTarget(recentFootprints, time);
        } else {
            predictedPosition = linearPrediction.predictTarget(recentFootprints, time);
        }
        return predictedPosition;
    }

    public String toString() {
        return "Av Circular";
    }
}

