/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.enemies;

import gre.svman4.enemies.FindRelativePosition;
import gre.svman4.useful.MotionState;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

public class Enemy
extends RobotState {
    public static final int NO_NEW_ATTACK_FIND = -1;
    private static final long serialVersionUID = 1L;
    private long newAttackTime;
    public double deltaEnergy;

    public Enemy(ScannedRobotEvent event, MotionState myRobot) {
        this(event.getName(), myRobot);
    }

    public Enemy(String name, MotionState me) {
        this.name = name;
        this.alive = true;
        int i = 0;
        while (i < 2) {
            this.lateralDirectionArray.insertValue(1.0);
            ++i;
        }
    }

    public void onHitByBullet(HitByBulletEvent event, MotionState mineRobot) {
    }

    public void onPaint(Graphics2D paint) {
        if (!this.alive) {
            return;
        }
        paint.setColor(Color.RED);
        paint.draw(new Rectangle2D.Double(this.x - 18.0, this.y - 18.0, 36.0, 36.0));
    }

    public void onRoundEnd(RoundEndedEvent event) {
    }

    public void onScannedRobot(ScannedRobotEvent event, MotionState mineRobot) {
        double energyDiff;
        double lastEnergy = this.energy;
        double lastVelocity = this.velocity;
        this.setLocation(mineRobot.project(event.getDistance(), mineRobot.heading + event.getBearingRadians()));
        this.deltaEnergy = this.energy - event.getEnergy();
        this.energy = event.getEnergy();
        this.deltaHeading = this.heading - event.getHeadingRadians();
        this.heading = event.getHeadingRadians();
        this.deltaVelocity = this.velocity - event.getVelocity();
        this.velocity = event.getVelocity();
        if (this.velocity != 0.0) {
            double enemyAbsoluteBearing = event.getBearingRadians() + mineRobot.heading;
            double enemyLateralVelocity = event.getVelocity() * Math.sin(event.getHeadingRadians() - enemyAbsoluteBearing);
            if (enemyLateralVelocity >= 0.0) {
                this.lateralDirectionArray.insertValue(1.0);
            } else {
                this.lateralDirectionArray.insertValue(-1.0);
            }
        }
        if ((energyDiff = lastEnergy - this.energy) < 3.01 && energyDiff > 0.0 && energyDiff != Math.abs(lastVelocity - this.velocity) * 0.5 - 1.0) {
            this.newAttackTime = event.getTime();
        }
        this.relativePosition = this.getRelativePosition();
    }

    public void onStatus(StatusEvent event, MotionState me) {
    }

    public void onBulletHit(BulletHitEvent event) {
        this.energy = event.getEnergy();
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
    }

    public long findNewAttack() {
        long answer = this.newAttackTime;
        this.newAttackTime = -1L;
        return answer;
    }

    private int getRelativePosition() {
        return FindRelativePosition.run(this);
    }
}

