/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.gun.targeter;

import java.awt.geom.Path2D;
import xander.core.Resources;
import xander.core.drive.Direction;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveBoundsFactory;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.gun.targeter.Targeter;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.gfws.FactorArrays;
import xander.gfws.FactorRange;
import xander.gfws.OrbitalFactorArrays;
import xander.gfws.processor.FactorArrayProcessor;

public class GuessFactorTargeter
implements Targeter {
    private FactorArrayProcessor fap;
    private OrbitalDrivePredictor orbitalDriver;

    public GuessFactorTargeter(FactorArrayProcessor fap) {
        this.fap = fap;
        Path2D.Double driveBounds = DriveBoundsFactory.getRectangularBounds(Resources.getRobotProxy().getBattleFieldSize());
        this.orbitalDriver = new OrbitalDrivePredictor(driveBounds);
    }

    @Override
    public String getTargetingType() {
        return "Guess Factor";
    }

    @Override
    public boolean canAimAt(Snapshot target) {
        return true;
    }

    @Override
    public double getAim(Snapshot target, Snapshot myself, double bulletVelocity) {
        FactorRange rfr = OrbitalFactorArrays.getReachableFactorRange(bulletVelocity, myself, target, myself.getTime(), this.fap.getFactors(), false, DistancingEquation.NO_ADJUST, this.orbitalDriver);
        double bulletPower = RCPhysics.getBulletPower(bulletVelocity);
        Wave surfWave = new Wave(target, myself, bulletPower, myself.getTime());
        double[] factorArray = this.fap.getFactorArray(surfWave, rfr.getMaxCounterClockwiseFactorAngle(), rfr.getMaxClockwiseFactorAngle());
        int factorIndex = FactorArrays.getMostWeightedFactorIndex(factorArray, rfr.getBeginIndex(), rfr.getEndIndex());
        Direction surfDirection = OrbitalDrivePredictor.getOribitalDirection(myself.getX(), myself.getY(), target.getX(), target.getY(), target.getVelocity(), target.getHeadingRoboDegrees());
        double factorAngle = FactorArrays.getMostWeightedFactorAngle(factorArray, factorIndex, bulletVelocity, surfDirection);
        double zeroAngle = RCMath.getRobocodeAngle(myself.getX(), myself.getY(), target.getX(), target.getY());
        double bestTurnAngle = zeroAngle + factorAngle;
        return bestTurnAngle;
    }
}

