/*
 * Decompiled with CFR 0.152.
 */
package jab.targeting;

import jab.module.Module;
import jab.module.Targeting;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class CircularTargeting
extends Targeting {
    public CircularTargeting(Module bot) {
        super(bot);
    }

    public void target() {
        double myX = this.bot.getX();
        double myY = this.bot.getY();
        double enemyX = this.bot.enemy.x;
        double enemyY = this.bot.enemy.y;
        double enemyHeading = this.bot.enemy.headingRadians;
        double oldEnemyHeading = this.bot.enemy.previousHeadingRadians;
        double enemyHeadingChange = enemyHeading - oldEnemyHeading;
        enemyHeadingChange /= (double)this.bot.enemy.timeSinceLastScan;
        double enemyVelocity = this.bot.enemy.velocity;
        oldEnemyHeading = enemyHeading;
        double deltaTime = 0.0;
        double battleFieldHeight = this.bot.getBattleFieldHeight();
        double battleFieldWidth = this.bot.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * this.bot.bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.bot.getX(), predictedY - this.bot.getY()));
        this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.bot.getGunHeadingRadians())));
    }
}

