/*
 * Decompiled with CFR 0.152.
 */
package catcat20.shield;

import catcat20.bot.Bot;
import catcat20.bot.BotState;
import catcat20.radar.Radar;
import catcat20.shield.angle.ShieldAngle;
import catcat20.utils.LConstants;
import catcat20.utils.LUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.util.Utils;

public class NewShield {
    public AdvancedRobot _robot;
    public ArrayList<ShieldWave> _waves;
    static final double BULLET_START_POWER = 0.15;
    double lastMoveDistance = 0.0;
    double aimAngle = 0.0;
    double firePower = 0.15;
    long fireOnTick = 0L;
    public double oldEnergy = 100.0;
    static final int[] TIME_TO_MOVE = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 4};
    static final int[] MAX_MOVE_DIST = new int[]{1, 1, 3, 5, 8};

    public NewShield(AdvancedRobot _robot) {
        this._robot = _robot;
    }

    public void init() {
        this._waves = new ArrayList();
        this.aimAngle = LUtils.absoluteBearing(this._robot.getX(), this._robot.getY(), LConstants.fieldCenter.x, LConstants.fieldCenter.y);
    }

    public void onTick() {
        long time = this._robot.getTime();
        Point2D.Double myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        for (int i = 0; i < this._waves.size(); ++i) {
            ShieldWave w = this._waves.get(i);
            if (!(w.distanceTraveled(time) > myPos.distance(w) + 100.0)) continue;
            this._waves.remove(i);
            --i;
        }
        Bot bot = Radar.nearestBot;
        if (bot != null && bot.currentState != null && bot.states.size() > 2) {
            if (time <= 25L || bot.currentState.energy <= 0.0 && this._waves.isEmpty()) {
                this.aimAngle = LUtils.absoluteBearing(myPos.x, myPos.y, bot.currentState.x, bot.currentState.y);
            }
            BotState state = bot.currentState;
            BotState lastState = bot.states.get(1);
            double enemyEnergy = state.energy;
            double deltaEnergy = bot.states.get((int)1).energy - enemyEnergy;
            deltaEnergy = bot.states.get((int)1).energy - bot.states.get((int)0).energy;
            this.oldEnergy = bot.currentState.energy;
            if (deltaEnergy >= 0.01 && deltaEnergy <= 3.0) {
                bot.gunHeat = LUtils.limit(0.0, Rules.getGunHeat((double)deltaEnergy) - LConstants.GUN_COOLING_RATE * 2.0, 3.0);
                ShieldWave w = new ShieldWave(lastState.x, lastState.y, Rules.getBulletSpeed((double)deltaEnergy), time, bot);
                w.myState = Radar.myState;
                w.lastMyState = Radar.myStates.get(1);
                w.enState = state;
                w.lastEnState = lastState;
                this._waves.add(w);
                double bulletAngle = w.bot.getBestShieldAngle().getAngle(w);
                double bulletSpeed = Rules.getBulletSpeed((double)deltaEnergy);
                int minTimeTillNextFire = (int)(Rules.getGunHeat((double)deltaEnergy) / this._robot.getGunCoolingRate());
                int maxTestDistance = this.getMaxMoveDistanceForTime(minTimeTillNextFire / 2);
                double bestDeviation = Double.POSITIVE_INFINITY;
                double myBulletSpeed = Rules.getBulletSpeed((double)0.15);
                Point2D.Double enLastPos = new Point2D.Double(w.lastEnState.x, w.lastEnState.y);
                double heading = this._robot.getHeadingRadians();
                if (Math.abs(bot.currentState.velocity) > 0.0) {
                    // empty if block
                }
                double move = -maxTestDistance;
                do {
                    double dB;
                    double deviation;
                    Point2D myFirePosition = this.getMoveEnd(myPos, heading, move);
                    long timeToMove = TIME_TO_MOVE[(int)Math.abs(move)];
                    Point2D bulletStart = this.project(enLastPos, bulletAngle, bulletSpeed * (double)(timeToMove + 1L));
                    Point2D target = this.intercept(myFirePosition, myBulletSpeed, bulletStart, bulletAngle, bulletSpeed);
                    double eGoalTime = Math.ceil(bulletStart.distance(target) / bulletSpeed);
                    target = this.project(bulletStart, bulletAngle, (eGoalTime - 0.5) * bulletSpeed);
                    double myGunAim = this.angleFromTo(myFirePosition, target);
                    Line2D.Double eLine = new Line2D.Double(this.project(bulletStart, bulletAngle, bulletSpeed * (eGoalTime - 1.0)), this.project(bulletStart, bulletAngle, bulletSpeed * eGoalTime));
                    double myTargetTime = myFirePosition.distance(target) / myBulletSpeed;
                    double myGoalTime = Math.ceil(myTargetTime);
                    Line2D.Double myLine = new Line2D.Double(this.project(myFirePosition, myGunAim, myBulletSpeed * (myGoalTime - 1.0)), this.project(myFirePosition, myGunAim, myBulletSpeed * myGoalTime));
                    if (!myLine.intersectsLine(eLine) || !((deviation = (dB = myTargetTime - (myGoalTime - 0.5)) * dB) < bestDeviation)) continue;
                    bestDeviation = deviation;
                    this.lastMoveDistance = move;
                    this.fireOnTick = time + timeToMove;
                    double goalSpeed = myFirePosition.distance(target) / (myGoalTime - 0.5);
                    this.firePower = Math.max(0.1, Math.min((20.0 - goalSpeed) / 3.0, 0.2));
                    this.aimAngle = myGunAim;
                } while ((move += 1.0) < (double)maxTestDistance);
                System.out.println("[" + time + "] has delta");
                this._robot.setTurnRightRadians(0.0);
                this._robot.setAhead(this.lastMoveDistance);
            } else {
                System.out.println("[" + time + "] no delta");
            }
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.aimAngle - this._robot.getGunHeadingRadians())));
            if (enemyEnergy <= 0.0 && this._waves.isEmpty()) {
                this._robot.setFire(0.1);
            }
            if (time == this.fireOnTick) {
                this._robot.setFire(this.firePower);
            }
            if (time == this.fireOnTick + 1L) {
                this._robot.setAhead(-this.lastMoveDistance);
            }
            if (time > this.fireOnTick + 1L && this._robot.getDistanceRemaining() == 0.0) {
                double goAngle = this.aimAngle + 1.5707963267948966;
                double angle = Utils.normalRelativeAngle((double)(goAngle - this._robot.getHeadingRadians()));
                if (Math.abs(angle) > 1.5707963267948966) {
                    if (angle < 0.0) {
                        this._robot.setTurnRightRadians(Math.PI + angle);
                    } else {
                        this._robot.setTurnLeftRadians(Math.PI - angle);
                    }
                } else if (angle < 0.0) {
                    this._robot.setTurnLeftRadians(-1.0 * angle);
                } else {
                    this._robot.setTurnRightRadians(angle);
                }
            }
        }
    }

    private Point2D getMoveEnd(Point2D.Double pos, double heading, double distance) {
        return this.project(pos, heading, distance);
    }

    private int getMaxMoveDistanceForTime(int time) {
        if (time >= MAX_MOVE_DIST.length) {
            return MAX_MOVE_DIST[MAX_MOVE_DIST.length - 1];
        }
        return MAX_MOVE_DIST[time];
    }

    private Point2D project(Point2D start, double angle, double length) {
        return new Point2D.Double(start.getX() + Math.sin(angle) * length, start.getY() + Math.cos(angle) * length);
    }

    private Point2D intercept(Point2D pos, double vel, Point2D tPos, double tHeading, double tVel) {
        double tVelX = Math.sin(tHeading) * tVel;
        double tVelY = Math.cos(tHeading) * tVel;
        double relX = tPos.getX() - pos.getX();
        double relY = tPos.getY() - pos.getY();
        double b = relX * tVelX + relY * tVelY;
        double a = vel * vel - tVel * tVel;
        b = (b + Math.sqrt(b * b + a * (relX * relX + relY * relY))) / a;
        return new Point2D.Double(tVelX * b + tPos.getX(), tVelY * b + tPos.getY());
    }

    private double angleFromTo(Point2D a, Point2D b) {
        return Math.atan2(b.getX() - a.getX(), b.getY() - a.getY());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Point2D.Double myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        if (!this._waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            ShieldWave hitWave = null;
            ShieldWave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            for (int x = 0; x < this._waves.size(); ++x) {
                ShieldWave w = this._waves.get(x);
                if (Math.abs(w.distanceTraveled(e.getTime()) - hitBulletLocation.distance(w)) < 50.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - w.bulletVelocity) < 0.001) {
                    hitWave = w;
                    break;
                }
                if (!(myPos.distance(w) - w.distanceTraveled(e.getTime()) < bestDist)) continue;
                nearestWave = w;
                bestDist = myPos.distance(w) - w.distanceTraveled(e.getTime());
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation, e.getBullet());
                this._waves.remove(hitWave);
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation, e.getBullet());
                System.out.println("In \"onHitByBullet\" the nearest wave was recorded instead of the actual wave.");
            }
        }
    }

    private void logHit(ShieldWave w, Point2D.Double hitLocation, Bullet bullet) {
        for (ShieldAngle angle : w.bot.shieldAngles) {
            double diff = Math.abs(angle.getAngle(w) - bullet.getHeadingRadians());
            angle.setScore(diff);
            System.out.println("[" + angle.name + "]  " + diff);
        }
    }

    public void onPaint(Graphics2D g) {
        long time = this._robot.getTime();
        for (ShieldWave w : this._waves) {
            g.setColor(Color.gray);
            int radius = (int)w.distanceTraveled(time + 1L);
            g.drawOval((int)(w.x - (double)radius), (int)(w.y - (double)radius), radius * 2, radius * 2);
        }
        if (Radar.nearestBot != null && Radar.nearestBot.currentState != null) {
            g.setColor(Color.white);
            g.drawString("current shield angle : " + Radar.nearestBot.getBestShieldAngle().name, 25, 25);
        }
    }

    public static class ShieldWave
    extends Point2D.Double {
        public double bulletVelocity;
        public long fireTime;
        public Bot bot;
        public BotState myState;
        public BotState lastMyState;
        public BotState enState;
        public BotState lastEnState;

        public ShieldWave(double x, double y, double bulletVelocity, long fireTime, Bot bot) {
            super(x, y);
            this.bulletVelocity = bulletVelocity;
            this.fireTime = fireTime;
            this.bot = bot;
        }

        public double distanceTraveled(long time) {
            return (double)(time - this.fireTime) * this.bulletVelocity;
        }
    }
}

