/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement.impl;

import pedersen.core.Combatant;
import pedersen.core.Snapshot;
import pedersen.misc.Host;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.movement.MovementMethodBase;

public class MovementMethodWaypointImpl
extends MovementMethodBase {
    private final StaticPosition[] waypoints;
    private final boolean reverseOnHit;
    private boolean clockwise = true;
    private int index = 0;

    public MovementMethodWaypointImpl(boolean newReverseOnHit) {
        super(27);
        this.exclusive = true;
        this.waypoints = new StaticPosition[44];
        this.waypoints[0] = new StaticPositionImpl(400.0, 20.0);
        this.waypoints[1] = new StaticPositionImpl(464.0, 20.0);
        this.waypoints[2] = new StaticPositionImpl(528.0, 20.0);
        this.waypoints[3] = new StaticPositionImpl(592.0, 20.0);
        this.waypoints[4] = new StaticPositionImpl(656.0, 20.0);
        this.waypoints[5] = new StaticPositionImpl(687.0, 42.0);
        this.waypoints[6] = new StaticPositionImpl(718.0, 64.0);
        this.waypoints[7] = new StaticPositionImpl(749.0, 86.0);
        this.waypoints[8] = new StaticPositionImpl(780.0, 108.0);
        this.waypoints[9] = new StaticPositionImpl(780.0, 172.0);
        this.waypoints[10] = new StaticPositionImpl(780.0, 236.0);
        this.waypoints[11] = new StaticPositionImpl(780.0, 300.0);
        this.waypoints[12] = new StaticPositionImpl(780.0, 364.0);
        this.waypoints[13] = new StaticPositionImpl(780.0, 428.0);
        this.waypoints[14] = new StaticPositionImpl(780.0, 492.0);
        this.waypoints[15] = new StaticPositionImpl(749.0, 514.0);
        this.waypoints[16] = new StaticPositionImpl(718.0, 536.0);
        this.waypoints[17] = new StaticPositionImpl(687.0, 558.0);
        this.waypoints[18] = new StaticPositionImpl(656.0, 580.0);
        this.waypoints[19] = new StaticPositionImpl(592.0, 580.0);
        this.waypoints[20] = new StaticPositionImpl(528.0, 580.0);
        this.waypoints[21] = new StaticPositionImpl(464.0, 580.0);
        this.waypoints[22] = new StaticPositionImpl(400.0, 580.0);
        this.waypoints[23] = new StaticPositionImpl(336.0, 580.0);
        this.waypoints[24] = new StaticPositionImpl(272.0, 580.0);
        this.waypoints[25] = new StaticPositionImpl(208.0, 580.0);
        this.waypoints[26] = new StaticPositionImpl(144.0, 580.0);
        this.waypoints[27] = new StaticPositionImpl(113.0, 558.0);
        this.waypoints[28] = new StaticPositionImpl(82.0, 536.0);
        this.waypoints[29] = new StaticPositionImpl(51.0, 514.0);
        this.waypoints[30] = new StaticPositionImpl(20.0, 492.0);
        this.waypoints[31] = new StaticPositionImpl(20.0, 428.0);
        this.waypoints[32] = new StaticPositionImpl(20.0, 364.0);
        this.waypoints[33] = new StaticPositionImpl(20.0, 300.0);
        this.waypoints[34] = new StaticPositionImpl(20.0, 236.0);
        this.waypoints[35] = new StaticPositionImpl(20.0, 172.0);
        this.waypoints[36] = new StaticPositionImpl(20.0, 108.0);
        this.waypoints[37] = new StaticPositionImpl(51.0, 86.0);
        this.waypoints[38] = new StaticPositionImpl(82.0, 64.0);
        this.waypoints[39] = new StaticPositionImpl(113.0, 42.0);
        this.waypoints[40] = new StaticPositionImpl(144.0, 20.0);
        this.waypoints[41] = new StaticPositionImpl(208.0, 20.0);
        this.waypoints[42] = new StaticPositionImpl(272.0, 20.0);
        this.waypoints[43] = new StaticPositionImpl(336.0, 20.0);
        this.reverseOnHit = newReverseOnHit;
    }

    public StaticPosition getRelativePositionTarget(Snapshot combatant, Snapshot target, long time) {
        DynamicPositionImpl vectorSum = new DynamicPositionImpl(0.0, 0.0);
        long turn = Host.singleton.getTurn();
        if (turn < 15L) {
            this.activate();
        } else if (turn == 15L) {
            this.onEnemyFire();
        } else if (this.index < 0) {
            this.index = this.waypoints.length - 1;
        } else if (this.index > this.waypoints.length - 1) {
            this.index = 0;
        }
        vectorSum.add(new StaticVectorImpl(combatant.getBearing(this.waypoints[this.index]), combatant.getDistance(this.waypoints[this.index])));
        return vectorSum.getStaticPosition();
    }

    public void activate() {
        Combatant combatant = Combatant.getCombatant();
        double shortestDistance = combatant.getDistance(this.waypoints[0]);
        this.index = 0;
        int i = 1;
        while (i < this.waypoints.length) {
            double distance = combatant.getDistance(this.waypoints[i]);
            if (distance < shortestDistance) {
                shortestDistance = distance;
                this.index = i;
            }
            ++i;
        }
    }

    public void recordHit() {
        if (this.reverseOnHit) {
            this.clockwise = !this.clockwise;
        }
    }

    public void onEnemyFire() {
        this.index = this.clockwise ? --this.index : ++this.index;
    }
}

