package rh.abs;
import robocode.util.Utils;
import java.awt.geom.Point2D;

/**
 * Wave - a class by Damij
 */
public class Wave
{

	private final Point2D.Double source, target;
	
	private final String state;
	
	private final double[] mAEFB;
	
	public final double velocity, dir;

	public double distTravelled, mAE;
	
	public int age;
	
	public boolean isMAESet, isMAEFBSet, stored;
	
	public Wave(final double x, final double y,
		final double velocity, final double targetx, final double targety,
			final String state, final double dir) {
				this.source = new Point2D.Double(x,y);
				this.target = new Point2D.Double(targetx, targety);
				this.velocity = velocity;
				this.distTravelled = 0d;
				this.age = 0;
				this.state = state;
				this.mAE = Math.asin(8d/velocity);
				this.dir = dir;
				this.isMAESet = false;
				this.mAEFB = new double[2];
				this.stored = false;
			}
		
	public final void inc() {
		this.advance(1);
	}

	public final void advance(final int delta) {
		this.age += delta;
		this.distTravelled = age * velocity;
	}
	
	public final boolean broke(final double distance) {
		return distTravelled >= distance;
	}
	
	public final Point2D.Double source() {
		return new Point2D.Double(source.x,source.y);
	}
	
	public final int age() {
		return age;
	}
	
	public final double distTravelled() {
		return distTravelled;
	}
	
	public final String state() {
		return state;
	}
	
	public final double mAE() {
		return mAE;
	}
	
	public final double dir() {
		return dir;
	}
	
	public final double velocity() {
		return velocity;
	}
	
	public final boolean stored() {
		return stored;
	}
	
	public final void setStored() {
		this.stored = true;
	}
	
	public final int calcBin(final Point2D.Double targeter, final int BINS) {
		final double offset = calcFactor(targeter);
		final int midbin = (BINS - 1) / 2;
		return limit(0, (int) (offset * midbin) + midbin, BINS-1);
	}
	
	public final int calcBinFB(final Point2D.Double targeter, final int BINS) {
		final double offset = calcFactorFB(targeter);
		final int midbin = (BINS - 1) / 2;
		return limit(0, (int) (offset * midbin) + midbin, BINS-1);
	}
	
	public final double calcOffset(final Point2D.Double targeter) {
		final double oldAngle = Math.atan2(
					target.x - source.x,
					target.y - source.y
				);
		final double newAngle = Math.atan2(
					targeter.x - source.x,
					targeter.y - source.y
				);
				
		return Math.abs(Utils.normalRelativeAngle(newAngle-oldAngle));
	}
	
	private double calcFactor(final Point2D.Double targeter) {
		final double oldAngle = Math.atan2(
					target.x - source.x,
					target.y - source.y
				);
		final double newAngle = Math.atan2(
					targeter.x - source.x,
					targeter.y - source.y
				);
				
		return Utils.normalRelativeAngle(newAngle-oldAngle)/mAE*dir;
	}
	
	private double calcFactorFB(final Point2D.Double targeter) {
		final double oldAngle = Math.atan2(
					target.x - source.x,
					target.y - source.y
				);
		final double newAngle = Math.atan2(
					targeter.x - source.x,
					targeter.y - source.y
				);
				
		final boolean clockwise = Utils.normalRelativeAngle(newAngle-oldAngle) > 0;
		return Utils.normalRelativeAngle(newAngle-oldAngle)/(clockwise?mAEFB[0]:mAEFB[1])*dir;
	}
	
	
	public final double timeTillHit(final Point2D.Double pos) {
		return (pos.distance(source) - distTravelled) / velocity;
	}
	
	public final boolean broke(final double distance, final int futures) {
		return (distTravelled + futures * velocity) >= distance;
	}
	
	private int limit(final int low, final int mid, final int high) {
		return Math.min(high,Math.max(low,mid));
	}
	
	public final void trySetMAE(final double newMAE) {
		if(!this.isMAESet) {
			this.mAE = Math.abs(newMAE);
		}
		this.isMAESet = true;
	}
	
	public final void trySetMAEFB(final double[] newMAEFB) {
		if(!this.isMAEFBSet) {
			this.mAEFB[0] = newMAEFB[0];
			this.mAEFB[1] = newMAEFB[1];
		}
		this.isMAEFBSet = true;
	}

}
