package davidalves.net;

//Imports for all classes
import robocode.*;
import davidalves.net.data.*;
import davidalves.net.targeting.*;
import davidalves.net.math.*;
import davidalves.net.movement.*;
import davidalves.net.radar.*;
import davidalves.net.util.*;
import java.util.*;
import java.awt.Color;
import java.io.*;
import java.util.zip.*;


public class AbstractAdvancedBot extends TeamRobot implements Serializable{		
	//This is empty because robots that extend AbstractAdvancedBot are going to override it
	public AbstractAdvancedBot(){
		
		
	}
	
	public void run() {}
	


/////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// File I/O Functions /////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////


	protected ObjectOutputStream openObjectOutputFile(String filename, String datatype){
		try {
			return new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(getDataFilename(filename, datatype)))));

		} catch (IOException e) {
			out.println(e.getMessage());
			return null;
		}
	}
	
	protected void writeObjectToFile(ObjectOutputStream oos, Serializable s){
		try{
			oos.writeObject(s);
		} catch (IOException e){
			out.println(e.getMessage());
		}
	}
	
	protected void closeFile(ObjectOutputStream oos){
		try{
			oos.close();
		} catch (IOException e){
			out.println(e.getMessage());
		}
	}
	
	protected Serializable readObjectFromFile(ObjectInputStream o){
		try{
			return (StrategyDatabase) o.readObject();
		} catch (IOException e){
			out.println(e.getMessage());
			return null;
		} catch (ClassNotFoundException e){
			out.println("Error reading object from file:" + e.getMessage());
			return null;
		}
	}
	
	protected String getDataFilename(String filename, String datatype){
		return (filename!=null?filename:"Unknown") + "_" + datatype + ".dat";
		
	}
	
	protected boolean fileExists(String filename){
		return getDataFile(filename).exists();
	}
	
	protected void closeFile(ObjectInputStream o){
		try {
			o.close();
		} catch (IOException e) {
			out.println("Error closing file:" + e.getMessage());
		}
	}
	
	protected ObjectInputStream openObjectInputFile(String filename, String datatype){
		try {
			return new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(getDataFilename(filename, datatype)))));
		} catch (IOException e) {
			out.println("Error opening input file:" + e.getMessage());
			return null;
		}
	}

/* Text file input, if I ever need it.
 * 
 * 	public void loadAimingStats(){
		try {
			BufferedReader r = new BufferedReader(new FileReader(getDataFile((target.name!=null?target.name:"Unknown") + "_AIM.dat")));
			// Try to get the counts
			hit = Double.parseDouble(r.readLine());
			missed = Double.parseDouble(r.readLine());
		} catch (IOException e) {
			// Something went wrong reading the file, reset to 0.
			hit = 0;
			missed = 0;
		} catch (NumberFormatException e) {
			// Something went wrong converting to ints, reset to 0
			hit = 0;
			missed = 0;
		}		
	}
*/




/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////// Error Logging Functions /////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	public void warning(String module, String errorMessage){
		errorMessage = "\nWarning: " + errorMessage;
		errorMessage += "\nModule: " + module;
		errorMessage += "\nTime: " + getTime();
		errorMessage += "\n";
		out.println("WARNING!" + errorMessage);
		logError(errorMessage);
	}
	
	public void error(String module, String errorMessage){
		errorMessage = "\nError: " + errorMessage;
		errorMessage += "\nModule: " + module;
		errorMessage += "\nTime: " + getTime();
		errorMessage += "\n";
		out.println("ERROR!\n" + errorMessage);
		logError(errorMessage);
		//out.println("\nPerforming illegal operation to allow stack trace...\n\n");
		//AbstractAdvancedBot temp = null;
		//temp.fire(1);
	}
	
	private void logError(String errorMessage){
		try {
			File f = getDataFile("ERRORS.LOG");
			RobocodeFileWriter r;
			if(f.exists() && getRoundNum() == 1){
				r = new RobocodeFileWriter(getDataFile("ERRORS.LOG").getAbsolutePath(), false);
				r.write(errorMessage + "\n");
				r.close();
			} else if(f.exists() && getRoundNum() <= 100){
				r = new RobocodeFileWriter(getDataFile("ERRORS.LOG").getAbsolutePath(), true);
				r.write(errorMessage + "\n");
				r.close();
			} else if(getRoundNum() <= 100) {
				r = new RobocodeFileWriter(getDataFile("ERRORS.LOG").getAbsolutePath(), false);
				r.write(errorMessage + "\n");
				r.close();
			} else {
				out.println("Error logging skipped after round 100...");
			}
			
		} catch (IOException e) {
			out.println("FAILED WRITING ERROR MESSAGE TO ERROR LOG FILE, MESSAGE BEING LOGGED WAS:" + errorMessage);
			out.println("> LOGGING FAILED DUE TO: ");
			out.println(e);
		}
	}
	

	
	
	
/////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////// Basic Movement Functions /////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	protected void goTo(Point p) {
		double angleInDegrees = getLocation().absoluteAngleTo(p);
		double newDirection = turnTo(angleInDegrees);
		double distanceToTravel = getLocation().distanceTo(p);
		setAhead(newDirection * distanceToTravel);
	}
	
	protected double turnTo(double angleInDegrees) {
		double ang;
		double dir;
		ang = DaveMath.angularDifferenceBetween(getHeading(), angleInDegrees);
		if (ang > DaveMath.QUARTERCIRCLE) {
			ang -= DaveMath.HALFCIRCLE;
			dir = -1;
		} else if (ang < -DaveMath.QUARTERCIRCLE) {
			ang += DaveMath.HALFCIRCLE;
			dir = -1;
		} else {
			dir = 1;
		}
		setTurnRight(ang);
		return dir;
	}

/////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////// Trig / Utility Functions /////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public Point getLocation(){
		return new Point(getX(), getY());
	}
	
	public double getAbsoluteAngleTo(RobocodeRobot en){
		return getLocation().absoluteAngleTo(en.getLocation());
	}

	public double getAbsoluteAngleTo(Point p){
		return getLocation().absoluteAngleTo(p);
	}

	public double getRelativeAngleTo(RobocodeRobot en){
		return DaveMath.angularDifferenceBetween(getHeading(), getLocation().absoluteAngleTo(en.getLocation()));
	}
	
	public double getRelativeAngleTo(Point p){
		return DaveMath.angularDifferenceBetween(getHeading(), getLocation().absoluteAngleTo(p));
	}
	
	public double distanceToClosestWall(){
		double width = getBattleFieldWidth();
		double height = getBattleFieldHeight();	
		double x = getX();
		double y = getY();

		return Math.min(Math.min(x, width - x), Math.min(y, height - y));
	}
	
	public Point getNearestCorner(){
		double width = getBattleFieldWidth();
		double height = getBattleFieldHeight();	
		double x = getX();
		double y = getY();
		
		if (x > width/2){
			if (y > height/2){ 	//Top right
				return new Point(width, height);
			} else {				//Bottom right
				return new Point(width,0);
			}
		} else {
			if (y > height/2){ 	//Top left
				return new Point(0, height);
			} else {				//Bottom left
				return new Point(0,0);
			}
		}
		
	}
	
	public int getRobotNumber(){
		if (getName().lastIndexOf(" (") > 1){
			//out.println("[" + getName().substring(getName().lastIndexOf(" (") + 2, getName().length() - 1) + "]");
			return Integer.parseInt(getName().substring(getName().lastIndexOf(" (") + 2, getName().length() - 1));
			//return 0;
		} else {
			return 1; //If there are no other bots, we're #1 :-P
		}
	}

/////////////////////////////////////////////////////////////////////////////////////////
//////////////// Overloaded event handlers from class AdvancedRobot /////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public void onScannedRobot(ScannedRobotEvent e) {
		out.println("WARNING: Event not overridden: ScannedRobotEvent");
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		out.println("WARNING: Event not overridden: RobotDeathEvent");
	}
	
	public void onBulletMissed(BulletMissedEvent e) {
		out.println("WARNING: Event not overridden: BulletMissedEvent");
	}

	public void onBulletHit(BulletHitEvent e) {
		out.println("WARNING: Event not overridden: BulletHitEvent");
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		out.println("WARNING: Event not overridden: BulletHitBulletEvent");
	}

	public void onWin(WinEvent e){
		out.println("WARNING: Event not overridden: WinEvent");
	}
	
	public void onDeath(DeathEvent e){
		out.println("WARNING: Event not overridden: DeathEvent");
	}

	public void onHitWall(HitWallEvent e){
		out.println("WARNING: Event not overridden: HitWallEvent");
	}

	public void onHitRobot(HitRobotEvent e) {
		out.println("WARNING: Event not overridden: HitRobotEvent");
	}

	public void onSkippedTurn(SkippedTurnEvent e){
		out.println("WARNING: Event not overridden: SkippedTurnEvent");
	}
}





