package com.timothyveletta.states;

import com.timothyveletta.*;

import java.util.Random;

public class PanicState extends State {
	Random generator;

	public PanicState(FuzzyBot obj) {
		super(obj);
	}
	
	@Override
	public void Init() {
		generator = new Random();
	}

	@Override
	public void Update() {
		super.Update();
		
		int angle = generator.nextInt(360);
		
		ForceVector vec = new ForceVector(activationLevel * Math.sin(angle),
											activationLevel * Math.cos(angle));
		
		object.applyForce(vec);
	}

	@Override
	public void CalculateActivation() {
		double energy;

		if(AIControl.energy < 100) {
			energy = 100;
		} else {
			energy = AIControl.energy;
		}
		
		activationLevel = 1 - (energy / 100);
	}
}
