package bvh.tyr;

/**********************************************************************
** Constanten zijn apart vastgelegd in interface
**********************************************************************/
interface Constanten {
// bewegingsconstanten
   int    RANDOM               = 0;        // initiele waarde
   int    ZOEKHOEK             = 1;        // op zoek naar hoek
   int    INHOEK               = 2;        // in een hoek
   int    AANVAL               = 5;        // aanval: beweging richting doel
   int    VERDEDIGING          = 6;        // verdediging: beweging van doel weg
   int    ONTWIJK              = 7;        // verdediging: ontwijk inkomende kogel
   int    RAMMEN               = 8;        // aanval: beweging rech op doel af
   int    KLOON                = 9;        // kloon: kloon beweging van doel
//
   int    CountReset           = 35;       // tijd waarna huidig doel wordt 'vergeten' (sneller, was 35)
   double delta                = 5;        // ingebouwde onnauwkeurigheid
   double standaardLoopafstand = 35;       // kleine stapjes (draaihoek is belangrijker)
   double hoekAfstand          = 120;      // niet te dicht in hoek gaan zitten
   double wandAfstand          = 100;       // naderingafstand tot wanden (bij kleinere waarden uiwijken)
   double standaardDraaicirkel = 2*Math.PI;// 360 graden draaien
   double naderingsAfstand     = 130;      // ga op doel af (in gevecht doel proberen te rammen)
   int    standaardAantalBots  = 2;        // oppassen bij groot aantal vijandelijke bots
   double standaardVuurkracht  = 4;     // stapjes waarmee vuurkracht wordt vergroot (was 3)
   double correctieRadarDraaicirkel = Math.PI/32; // delta in radar draaihoek om te voorkomen dat doel wordt kwijtgeraakt

   int    debugMode            = 1;        // 0: geen debug meldingen, 1: doel/schiet-info, 2: incl. bewegingsinfo, 3: alle info
}
