package bvh.tyr;

import robocode.*;
/**
 * Kogel - deze class bevat zoveel informatie over een kogel:
 *
 * Deze class is bedoeld om informatie over eigen uitgaande kogels en 
 * gescande inkomende kogels op te slaan.
 */
class Kogel implements Constanten {

   public String id, naam = null;      // naam van doel dat kogel heeft afgeschoten
   public long   scanTijd;             // tijd waarop kogel is gescanned
   public double x, y;                 // x,y is initieel de positie van het gescande doel
   public double e;                    // energieverlies gescande doel
   public double v;                    // geschatte snelheid o.b.v. energieverlies gescande doel
   public double afstand, richting;    // afstand en hoek tov. mijn botje
   public double bewegingsrichting;    // bewegingsrichting v.d.kogel = - richting t.o.v. mijn bot
                                       // bij aanname dat doel op mij schiet...

// constructor:
   public Kogel() { 
      resetKogel();
   }
// constructor:
   public Kogel(double e, double xB, double yB, double a, double r, long t, String n) { 
      setKogel(e, xB, yB, a, r, t, n);
   }

/**
* Methode reset de waarden van een geinstantieerde kogel: in feite kogel 'verwijderen' zonder object te verwijderen
*/
   public void resetKogel() {
      e                 = 0;
      x                 = -1;
      y                 = -1;
      afstand           = 10000;
      bewegingsrichting = 0;
      richting          = 0;
      scanTijd          = -1;
      naam              = null;
      v                 = 0;
   }
/**
* Methode set de waarden van een geinstantieerde kogel:
*/
   public void setKogel(double e, double xB, double yB, double a, double r, long t, String n) { 
      e                 = e;
      x                 = x; // x,y is initieel de positie van het gescande doel
      y                 = y;
      afstand           = a;
      richting          = (r + Math.PI)%(2*Math.PI); // ingegeven hoek is de hoek vd gescande kogel tov de eigen bot;
      bewegingsrichting = -richting;
      scanTijd          = t;
      naam              = n;
      v                 = 20 - 3 * e;
   }

/**
* Methoden geven x,y-waarden van de oorsprong van de kogel:
*/
   public double getX() {return x;}
   public double getY() {return y;}
/**
* Methoden geven de x,y-waarden van de kogel op tijd t.
*/
   public double getX(long t) {return  (x + Math.sin(bewegingsrichting) * v * (t-scanTijd));}
   public double getY(long t) {return  (y + Math.cos(bewegingsrichting) * v * (t-scanTijd));}
/**
* Methode geeft de afstand van de kogel op tijd t t.o.v. de eigen bot.
*/
   public double getAfstand(long t) {
      double xt = getX(t);
      double yt = getY(t);
      double afgelegdeWeg = Math.sqrt((xt-x)*(xt-x) + (yt-y)*(yt-y));
      return (afstand - afgelegdeWeg);
   }

 } // einde class Kogel
/**********************************************************************
** EINDE KOGEL
**********************************************************************/
