package tzu.util;

import robocode.*;
import tzu.intel.*;
import tzu.strategy.*;

/**
 * Provides an abstract class upon which all other Manager classes are based.
 */
public abstract class AbstractManager implements Constants{

    public AdvancedRobot            myRobot;
    public TargetStrategyInterface  targets;

    /**
     * Create a new AbstractManager
     * @param ar    your AdvancedRobot.
     * @param tsi   an object implementing the TargetStrategyInterface.
     */
    public AbstractManager(AdvancedRobot ar, TargetStrategyInterface tsi) {
        myRobot         = ar;
        targets         = tsi;
    }

    /**
     * Subclasses must override this method to specify what functionality
     * they want executed each turn.
     */
    public abstract void takeTurn();

    /**
     * Subclasses must override this method to specify what intialization
     * they want done on the second and subsequent rounds of battle.
     */
    public abstract void reinitialize();
}
