package tjk.universe;

import robocode.*;
import tjk.utils.HitTracker;
import tjk.utils.tjkUtil;
import tjk.utils.FastTrig;
import robocode.util.Utils;
import java.awt.geom.Point2D;

/**
 * Wave - a class by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 * 
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */
public class Wave
{
	
	private Point2D.Double location;
	
	private Bot target;
	
	private double power,velocity,cW,radius;
	
	private double[] minCenterMax = {-0.1,0.0,0.1};
	
	private long launchtime,lifetime;
	
	private double[] hitBracket = {0.0,0.0};
	
	// In polar coordinates, r,theta
	// normalized to distance at fire time and relative to HOT (cW adjusted).
	public double[] displacementVector = new double[2];
	
	public final double START_D;
	
	private double[] situation;
	
	private BracketHist mainStats = null;
	
	private BracketHist rollingStats = null;
	
	private BracketHist realStats = null;
	
	private BracketHist randStats = null;
	
	public static final byte ALIVE = 0;
	public static final byte HITTING = 1;
	public static final byte DEAD = 2;
	
	private byte state = ALIVE;
	
	public boolean real = false;
	
	public double[] gunGuesses = null;
	
	public Wave(boolean realWave, Bot source, Bot t, long time, double pow, double c, double[] mcm, double[] s)
	{
		real = realWave;
		target = t;
		START_D = source.getLocation().distance(t.getLocation());
		Point2D.Double l = source.getLocation();
		location = new Point2D.Double(l.getX(),l.getY());
		launchtime = time;
		power = pow;
		velocity = Rules.getBulletSpeed(power);
		//velocity = 20.0 - 3.0*power;
		cW = source./*get*/enemyCW();
		minCenterMax = mcm;
		situation = s;
		radius = 0.0;
		displacementVector[0] = 1.0;
		displacementVector[1] = 0.0;
	}
	
	public void loadGunGuesses(double[] g)
	{
		gunGuesses = new double[g.length];
		for (int i = 0; i < gunGuesses.length; i++)
		{
			gunGuesses[i] = absToGF(g[i]);
		}
	}
	
	public double[] gunHits()
	{
		if ( gunGuesses == null )
		{
			return GFBracket.EMPTY_GH;
		}
		double[] answer = new double[gunGuesses.length];
		double hitSize = HitTracker.normalizeHit(this);
		
		for (int i = 0; i < gunGuesses.length; i++)
		{
			answer[i] = (Double.compare(gunGuesses[i],hitBracket[0]) >= 0 && Double.compare(gunGuesses[i],hitBracket[1]) <= 0) ? hitSize : 0.0 ;
		}
		
		return answer;
	}
	
	public BracketHist getMainBracketHist()
	{
		return mainStats;
	}

	public void setMainBracketHist(BracketHist bh)
	{
		mainStats = bh;
	}

	public BracketHist getRollingBracketHist()
	{
		return rollingStats;
	}

	public void setRollingBracketHist(BracketHist bh)
	{
		rollingStats = bh;
	}

	public BracketHist getRealBracketHist()
	{
		return realStats;
	}

	public void setRealBracketHist(BracketHist bh)
	{
		realStats = bh;
	}

	public BracketHist getRandBracketHist()
	{
		return randStats;
	}

	public void setRandBracketHist(BracketHist bh)
	{
		randStats = bh;
	}
			
	public byte getState()
	{
		return state;
	}
	
	public double getPower()
	{
		return power;
	}
	
	public double getRadius()
	{
		return radius;
	}
	
	public double getVelocity()
	{
		return velocity;
	}
	
	public Point2D.Double getLocation()
	{
		return location;
	}
	
	public double getX()
	{
		return location.getX();
	}

	public double getY()
	{
		return location.getY();
	}

	public double[] getMCM()
	{
		return minCenterMax;
	}

	public double[] getHitBracket()
	{
		return hitBracket;
	}

	public double[] getSituation()
	{
		return situation;
	}

	public double cW()
	{		
	     return cW;
	}

	public double GFToAbs(double i)
	{
		double angle = i;
		if ( angle < 0.0 )
		{
			angle = angle * minCenterMax[0];
		}
		else
		{
			angle = angle * minCenterMax[2];
		}
		return Utils.normalRelativeAngle(cW*angle + minCenterMax[1]);
	}

	public double absToGF(double i)
	{
		double angle = cW*Utils.normalRelativeAngle( i - minCenterMax[1] );
		if ( angle < 0.0 )
		{
			angle = angle / minCenterMax[0];
		}
		else
		{
			angle = angle / minCenterMax[2];
		}
		return angle;
	}

	public void addToBracket(double x,double y)
	{
		if ( x < -1 || y < -1 || x > target.bfW()+1 || y > target.bfH()+1 )
		{
			return;
		}
		double angle = absToGF(FastTrig.atan2(x-location.getX(),y-location.getY()));
	
		if ( Double.compare(hitBracket[0],0.0) == 0.0 && Double.compare(hitBracket[1],0.0) == 0.0 )
		{
			hitBracket[0] =  angle;
			hitBracket[1] =  angle;
			//System.out.println(angle + " Guessfactor added to bracket.");
		}
		else if ( angle > hitBracket[1] )
		{
			hitBracket[1] = angle;
			//System.out.println(angle + " Guessfactor added to bracket.");
		}
		else if ( angle < hitBracket[0] )
		{
			hitBracket[0] = angle;
			//System.out.println(angle + " Guessfactor added to bracket.");
		}
	}

	// TODO:  Offload this code into a single object, or maybe Bot... this is too enormous to have
	//       on so many waves.
	public void update()
	{
		lifetime = target.getTime() - launchtime;
		radius = velocity*lifetime;
		double d = location.distance(target.getLocation());
		if ( state != DEAD && radius > d + 25.45585 + 1.5*velocity )
		{
			state = DEAD;
		}
		else if (  state == ALIVE && radius >= d - 25.45585 )
		{
			state = HITTING;
		}

		if ( state != HITTING )
		{
			return;
		}
	
		// Displacement Vector
		double absTargetAngle = FastTrig.atan2(target.getX()-getX(), target.getY()-getY());
		double relTargetAngle = cW*Utils.normalRelativeAngle( absTargetAngle - minCenterMax[1] );
		displacementVector = new double[2];
		displacementVector[0] = d/START_D;
		displacementVector[1] = relTargetAngle;
		
		// Begin getting precise intersection.
		// Bottom left corner
		double x_check = target.getX()-18.0;
		double y_check = target.getY()-18.0;
		double d_check = location.distance(x_check,y_check);
		boolean BL_beyond_outer = Double.compare(d_check,radius) > 0;
		boolean BL_beyond_inner = Double.compare(d_check,radius-velocity) > 0;
		if( BL_beyond_inner && !BL_beyond_outer )
		{
			addToBracket(x_check,y_check);
		}
		// Top left corner
		x_check = target.getX()-18.0;
		y_check = target.getY()+18.0;
		d_check = location.distance(x_check,y_check);
		boolean TL_beyond_outer = Double.compare(d_check,radius) > 0;
		boolean TL_beyond_inner = Double.compare(d_check,radius-velocity) > 0;
		if( TL_beyond_inner && !TL_beyond_outer )
		{
			addToBracket(x_check,y_check);
		}
		// Bottom right corner
		x_check = target.getX()+18.0;
		y_check = target.getY()-18.0;
		d_check = location.distance(x_check,y_check);
		boolean BR_beyond_outer = Double.compare(d_check,radius) > 0;
		boolean BR_beyond_inner = Double.compare(d_check,radius-velocity) > 0;
		if( BR_beyond_inner && !BR_beyond_outer )
		{
			addToBracket(x_check,y_check);
		}
		// Top right corner
		x_check = target.getX()+18.0;
		y_check = target.getY()+18.0;
		d_check = location.distance(x_check,y_check);
		boolean TR_beyond_outer = Double.compare(d_check,radius) > 0;
		boolean TR_beyond_inner = Double.compare(d_check,radius-velocity) > 0;
		if( TR_beyond_inner && !TR_beyond_outer )
		{
			addToBracket(x_check,y_check);
		}
		
		d_check = radius-velocity;
		
		//Left Side
		x_check = target.getX()-18.0;
		y_check = target.getY()-18.0;
		double x_check2 = target.getX()-18.0;
		double y_check2 = target.getY()+18.0;
		double[] sidecheck = {0.0};
		// if BL and TL have different circle status... check that side.
		// Outer circle..
		if ( (BL_beyond_outer && !TL_beyond_outer) || ((!BL_beyond_outer && TL_beyond_outer)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),radius);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		// Inner
		if ( (BL_beyond_inner && !TL_beyond_inner) || ((!BL_beyond_inner && TL_beyond_inner)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),d_check);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		
		//Right Side
		x_check = target.getX()+18.0;
		y_check = target.getY()-18.0;
		x_check2 = target.getX()+18.0;
		y_check2 = target.getY()+18.0;
		if ( (BR_beyond_outer && !TR_beyond_outer) || ((!BR_beyond_outer && TR_beyond_outer)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),radius);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		if ( (BR_beyond_inner && !TR_beyond_inner) || ((!BR_beyond_inner && TR_beyond_inner)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),d_check);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		
		//Top
		x_check = target.getX()+18.0;
		y_check = target.getY()+18.0;
		x_check2 = target.getX()-18.0;
		y_check2 = target.getY()+18.0;
		if ( (TR_beyond_outer && !TL_beyond_outer) || ((!TR_beyond_outer && TL_beyond_outer)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),radius);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		if ( (TR_beyond_inner && !TL_beyond_inner) || ((!TR_beyond_inner && TL_beyond_inner)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),d_check);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		
		//Bottom
		x_check = target.getX()+18.0;
		y_check = target.getY()-18.0;
		x_check2 = target.getX()-18.0;
		y_check2 = target.getY()-18.0;
		if ( (BR_beyond_outer && !BL_beyond_outer) || ((!BR_beyond_outer && BL_beyond_outer)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),radius);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		if ( (BR_beyond_inner && !BL_beyond_inner) || ((!BR_beyond_inner && BL_beyond_inner)) )
		{
			sidecheck = tjkUtil.circleLineIntersect(x_check,y_check,x_check2,y_check2,location.getX(),location.getY(),d_check);
			if ( sidecheck[0] > 0.0 )
			{
				addToBracket(sidecheck[1],sidecheck[2]);
				if ( sidecheck.length > 3 )
				{
					addToBracket(sidecheck[3],sidecheck[4]);
				}
			}
		}
		
		
	}
	
}																		