/*
 * Created on 25/01/2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.pilot;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import axeBots.Okami;
import axeBots.okami.AxeTarget;
import axeBots.okami.AxeVector;
import axeBots.util.RoboMath;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AntiMirrorPilot extends AxePilot {

    private ArrayList future= new ArrayList();
    private AxeTarget him= null;
    private Okami me= null;
    private int radius= 250;
    private static final int WALL_DIST= 100;
    private static final int OPERATIONAL_SLACK= 10;
    private Point2D.Double fieldCenter= null;
    private int distanceManager= HOLD_OFF;
    private static AntiMirrorPilot singleton;

    /**
     * 
     */
    public AntiMirrorPilot() {
    	
        super();
        me= super.getMe();
        Rectangle2D.Double field= me.getField();
        fieldCenter= new Point2D.Double(field.getCenterX(), field.getCenterY());
        radius=
            (int)Math.min(500, Math.min(field.height, field.width) - WALL_DIST)
                / 2;
        super.setWallsFear(false);
        singleton= this;

        // TODO Auto-generated constructor stub
    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#move()
     */
    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#move()
     */
    public void move() {

        him= getMe().getMyTarget();
        if (him == null) {
            return;
        }

        if (future.isEmpty()) {
            this.doFuture();
        }

        int hisTimeToHit=
            RoboMath.estimateBullTravelTime(
                him.getLastBulletPow(),
                him.getDistance());
        int myTimeToHit=
            RoboMath.estimateBullTravelTime(3.0, him.getDistance());
        int nextRevert= ((Integer)future.get(0)).intValue();
        int invertDelta= (int) (me.getTime() - super.getLastReversed());

        if (invertDelta >= nextRevert) {
            super.invert();
            this.doFuture();

        }
        double d= RoboMath.getrange(me.pos(), fieldCenter);
        if (d < (radius - 5)) {
            this.distanceManager= GET_AWAY;
        } else if (d > (radius + 5)) {
            this.distanceManager= GET_CLOSER;
        } else {
            this.distanceManager= HOLD_OFF;
        }

        super.setWallsFear(!isOperational());

        super.doPerpendicularGigle(0, distanceManager, fieldCenter);

        this.walk(50);

    }

    public Point2D.Double clairvoyance(double bvel) {

        AxeTarget target= me.getMyTarget();

        if (!isOperational()
            || (target == null)
            || ((me.getTime() - super.getLastReversed()) < 14)) {
            return null;
        }

        AxeVector line= new AxeVector(fieldCenter, target.pos());

        double d= RoboMath.getrange(me.pos(), fieldCenter);
        double cc= Math.PI * 2 * d;
        double tick= 360D / cc;
        int timeCount= 0;
        int futureIndex= 0;
        int nextRevert= ((Integer)future.get(futureIndex)).intValue() + 3;
        nextRevert -= (int) (me.getTime() - super.getLastReversed());

        Point2D.Double meNow= me.pos();
        Point2D.Double hisPos= line.getEndPoint();

        boolean re= me.isRe();

        boolean deacc= false;

        double hisvel= Math.abs(target.getVelocity());

        //timeCount += 3;

        while ((RoboMath.getrange(hisPos, meNow) - 20)
            > (bvel * (timeCount - 2))) {
            if (deacc) {
                hisvel -= 2;
                if (hisvel <= 0) {
                    hisvel= 0;
                    re= !re;
                    deacc= false;
                }
            } else if (hisvel < 8) {
                hisvel += 1;
            }

            timeCount++;
            nextRevert--;
            if (nextRevert == 0) {
                deacc= true;
                futureIndex++;
                nextRevert= ((Integer)future.get(futureIndex)).intValue();
            }

            double angDiff= (re) ? tick * hisvel : -tick * hisvel;
            line.addTheta(angDiff);
            hisPos= line.getEndPoint();

        }
        return hisPos;

    }

    public boolean isOpposite(AxeTarget trg) {

        AxeVector myLine= new AxeVector(fieldCenter, me.pos());
        myLine.addTheta(180);
        double d= RoboMath.getrange(myLine.getEndPoint(), trg.pos());
//        System.out.println("isOpposite:" + d);
        return d < 60;
    }

    public static double getOpposite(AxeTarget trg) {

        AxeVector myLine=
            new AxeVector(singleton.fieldCenter, singleton.me.pos());
        myLine.addTheta(180);
        double d= RoboMath.getrange(myLine.getEndPoint(), trg.pos());
        return d;

    }

    public boolean isOperational() {
        double d= RoboMath.getrange(me.pos(), fieldCenter);
        return this.isOpposite(me.getMyTarget())
            && ((d > (radius - OPERATIONAL_SLACK))
                && (d < (radius + OPERATIONAL_SLACK)));
    }

    /**
     * 
     */
    private void doFuture() {
        int min= 14;
        int max=
            RoboMath.estimateBullTravelTime(
                him.getLastBulletPow(),
                him.getDistance());
        //max = (max<min)?min:max;

        int myTimeToHit=
            RoboMath.estimateBullTravelTime(3.0, him.getDistance());
        if (!future.isEmpty()) {

            future.remove(0);
        }
        int amt= 0;
        for (int i= 0; i < future.size(); i++) {
            amt += ((Integer)future.get(i)).intValue();

        }

        while (amt < (myTimeToHit * 5)) {
            int next= (int) (Math.floor(Math.random() * (max)) + min);
            amt += next;
            future.add(new Integer(next));
        }
    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#start()
     */
    public void start() {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#stop()
     */
    public void stop() {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#botHitBot()
     */
    public void botHitBot() {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see axeBots.pilot.AxePilot#botHitWall()
     */
    public void botHitWall() {
        invert();

    }

}
