package ph.intelligence;
import java.util.*;
import ph.*;
import java.io.*;

// persistent robot info
public class probotInfo implements Serializable {
    
    public probotInfo(ModularRobot robot, String name) {
        this.robot=robot;
        this.name=name;
    }
    
    protected transient ModularRobot robot;
    protected String name;
    
    public void setRobot(ModularRobot robot) {this.robot = robot; }
    public String name() {return name;}
    
    /* enemy's */
    private transient int[][] enemyGuessFactors=new int[21][31]; //distance, guess factor
    private transient Vector enemyWaves=new Vector();
    private transient int myDirection=1;
    /* ---------------------------------------------------------------------- */
    
    /* my */
    //distance from me, velocity, acceleration, guess factor
    //private int[][][][][][] guessFactors=new int[6][2][2][37][37][31];
    private transient int[][][][] guessFactors=new int[12][5][3][27];
    private transient Vector waves=new Vector();
    private transient int direction=1;
    /* ---------------------------------------------------------------------- */
    
    private byte[][][] cribSheet;
    
    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        guessFactors=new int[12][5][3][27];
        waves=new Vector();
        direction=1;
        enemyGuessFactors=new int[21][31];
        enemyWaves=new Vector();
        myDirection=1;
        for(byte i=0; i<12; i++) {
            for(byte j=0; j<5; j++) {
                for(byte k=0; k<3; k++) {
                    guessFactors[i][j][k][cribSheet[i][j][k]]=15;
                }
            }
        }
        cribSheet=null;
    }
    
    private void writeObject(ObjectOutputStream os) throws IOException {
        cribSheet = new byte[12][5][3];
        for(byte i=0; i<12; i++) {
            for(byte j=0; j<5; j++) {
                for(byte k=0; k<3; k++) {
                    byte bestindex=13;
                    for(byte l=0; l<27; l++) {
                        if(guessFactors[i][j][k][l]>guessFactors[i][j][k][bestindex]) {
                            bestindex=l;
                        }
                    }
                    cribSheet[i][j][k]=bestindex;
                }
            }
        }
        os.defaultWriteObject();
    }
    
    public void bulletFiredToOther(double power) {
        robotInfo ri;
        int robotIndex=robot.otherRobotsNames.indexOf(name);
        if(robotIndex<0) return;
        ri=(robotInfo)robot.otherRobotsInfo.elementAt(robotIndex);
        double bearing=utils.normalAngle(utils.getBearing(
        robot.getX(),robot.getY(),ri.x(),ri.y()));
        bulletFired(new VirtualBullet(robot.getTime(),
        power, robot.getX(), robot.getY(), bearing),ri);
    }
    
    public void bulletFired(VirtualBullet vb, robotInfo ri) {
        int distanceFromMe=Math.min(12,(int)utils.dist(robot.getX(),robot.getY(),ri.x(),ri.y())/80);
        double enemyVelocity=Math.abs(ri.velocity());
        int eVelocity;
        if(enemyVelocity<1)
            eVelocity=0;
        else if (enemyVelocity<=3)
            eVelocity=1;
        else if (enemyVelocity<=5)
            eVelocity=2;
        else if (enemyVelocity<=7)
            eVelocity=3;
        else
            eVelocity=4;
        int acceleration=1;
        if (ri.acceleration()>0)
            acceleration=2;
        else if(ri.acceleration()<0)
            acceleration=0;
        int[] stats=guessFactors[distanceFromMe][eVelocity][acceleration];
        double absBearing=utils.normalAngle(
        utils.getBearing(vb.launchX,vb.launchY,ri.x(),ri.y()));
        if (enemyVelocity != 0)
            if (Math.sin(Math.toRadians(
            utils.normalAngle(ri.heading()-absBearing)))*enemyVelocity < 0)
                direction = -1;
            else
                direction = 1;
        waves.addElement(new Wave(vb.launchX, vb.launchY, vb.launchTime,
        vb.power, vb.heading, direction, stats));
    }
    
    public void enemyBulletFired(VirtualBullet vb) {
        int[] stats=enemyGuessFactors[(int)Math.min(20,
        utils.dist(robot.getX(),robot.getY(),vb.launchX,vb.launchY)/50)];
        int robotIndex=robot.otherRobotsNames.indexOf(name);
        if(robotIndex<0) return;
        robotInfo ri=(robotInfo)robot.otherRobotsInfo.elementAt(robotIndex);
        double absBearing=utils.normalAngle(
        utils.getBearing(vb.launchX,vb.launchY,robot.getX(),robot.getY()));
        if (robot.getVelocity() != 0)
            if (Math.sin(Math.toRadians(
            utils.normalAngle(robot.getHeading()-absBearing)))*robot.getVelocity() < 0)
                myDirection = -1;
            else
                myDirection = 1;
        enemyWaves.addElement(new Wave(vb.launchX, vb.launchY, vb.launchTime,
        vb.power, vb.heading, myDirection, stats));
    }
    
    public void enemyCheckHit(double robotX, double robotY, double robotEnergy,long curTime) {
        for(int i=0; i<enemyWaves.size(); i++) {
            Wave w=(Wave)enemyWaves.elementAt(i);
            if(w.checkHit(robotX,robotY, robotEnergy, curTime)) {
                enemyWaves.removeElementAt(i);
                i--;
            }
        }
    }
    
    public void checkHit(double enemyX, double enemyY, double enemyEnergy, long curTime) {
        for(int i=0; i<waves.size(); i++) {
            Wave w=(Wave)waves.elementAt(i);
            if(w.checkHit(enemyX,enemyY,enemyEnergy,curTime)) {
                waves.removeElementAt(i);
                i--;
            }
        }
    }
    
    public double gfEnemyAimingHeading(double enemyX, double enemyY, double power) {
        double robotX=robot.getX();
        double robotY=robot.getY();
        double distance=utils.dist(robotX,robotY,enemyX,enemyY);
        int[] stats=enemyGuessFactors[(int)Math.min(20,distance/50)];
        int bestindex = 15;	//initialize it to be in the middle, guessfactor 0.
        for (int i=0; i<31; i++)
            if (stats[bestindex] < stats[i])
                bestindex = i;
        
        //this should do the opposite of the math in the WaveBullet:
        double guessfactor = (double)((2d*(double)bestindex)/((double)stats.length-1d))-1d;
        double angleOffset = myDirection*guessfactor*Math.toDegrees(Wave.maxEscapeAngle(power));
        double bearing=utils.normalAngle(utils.getBearing(enemyX,enemyY,robotX,robotY));
        return utils.normalAngle(bearing+angleOffset);
    }
    
    public double gfAimingHeading(robotInfo ri, double power) {
        int distanceFromMe=Math.min(12,(int)utils.dist(robot.getX(),robot.getY(),ri.x(),ri.y())/80);
        double enemyVelocity=Math.abs(ri.velocity());
        int eVelocity;
        if(enemyVelocity<1)
            eVelocity=0;
        else if (enemyVelocity<=3)
            eVelocity=1;
        else if (enemyVelocity<=5)
            eVelocity=2;
        else if (enemyVelocity<=7)
            eVelocity=3;
        else
            eVelocity=4;
        int acceleration=1;
        if (ri.acceleration()>0)
            acceleration=2;
        else if(ri.acceleration()<0)
            acceleration=0;
        int[] stats=guessFactors[distanceFromMe][eVelocity][acceleration];
        int bestindex = (stats.length-1)/2;	//initialize it to be in the middle, guessfactor 0.
        for (int i=0; i<stats.length; i++)
            if (stats[bestindex] < stats[i])
                bestindex = i;
        
        double robotX=robot.getX();
        double robotY=robot.getY();
        //this should do the opposite of the math in the WaveBullet:
        //double guessfactor = (double)(bestindex-(stats.length-1)/2)/((stats.length-1)/2);
        double guessfactor=(double)((2d*(double)bestindex)/((double)stats.length-1d))-1d;
        double angleOffset = (double)direction*guessfactor*Wave.maxEscapeAngle(power);
        double bearing=utils.normalAngle(utils.getBearing(robotX,robotY,ri.x(),ri.y()));
        return utils.normalAngle(bearing+angleOffset);
    }
    
}
