package hirataatsushi;
import robocode.*;
import java.awt.geom.Point2D;



/**
 * A class to hold often accessed game dimensions and
 * provides methods that work with those dimensions to
 * help improve game play.
 */
public final class BattleFieldManager {

    private static final double BUFFER_TARGET   = 400;
    private static final double BUFFER_WALL     = 35;


    /** Lower x coordinate with safety buffer. */
    public static double   lowerX = 0;
    /** Lower y coordinate with safety buffer. */
    public static double   lowerY = 0;
    /** Upper x coordinate with safety buffer. */
    public static double   upperX = 0;
    /** Upper y coordinate with safety buffer. */
    public static double   upperY = 0;
    /** Absolute minimum x coordinate possible for a robot. */
    public static double   minX = 0;
    /** Absolute minimum y coordinate possible for a robot. */
    public static double   minY = 0;
    /** Absolute maximum x coordinate possible for a robot. */
    public static double   maxX = 0;
    /** Absolute maximum y coordinate possible for a robot. */
    public static double   maxY = 0;
    /** Absolute middle x coordinate. */
    public static double   midX = 0;
    /** Absolute middle y coordinate. */
    public static double   midY = 0;
    /** Smallest dimension of a robot measured from center out. */
    public static double   robotSize = 0;
    /** Preferred buffer distance between your bot and enemy bots. */
    public static double   targetBuffer = 0;


	private AdvancedRobot myBot = null;

	/**
	 * Singleton Methods
	 */
	private static BattleFieldManager singleton = new BattleFieldManager();
	//RXgN^B
	private BattleFieldManager(){
		System.out.println("BattleFieldManager : Singleton instance created...");
	}
	//BattleField}l[W[̃CX^XԂB
	public static BattleFieldManager getInstance(){
		return singleton;
	}
	
	
	//@ւ̎QƂZbg
	//ƂɎg	
	public void setMyBot(AdvancedRobot bot){
		myBot = bot;
		
		
        robotSize = Math.min(
            (myBot.getWidth()  / 2 - 2),
            (myBot.getHeight() / 2 - 2));

        minX = robotSize;
        minY = robotSize;
        maxX = myBot.getBattleFieldWidth()  - robotSize;
        maxY = myBot.getBattleFieldHeight() - robotSize;
        midX = myBot.getBattleFieldWidth()  / 2;
        midY = myBot.getBattleFieldHeight() / 2;

        lowerX = minX + BUFFER_WALL;
        lowerY = minY + BUFFER_WALL;
        upperX = maxX - BUFFER_WALL;
        upperY = maxY - BUFFER_WALL;

        targetBuffer = Math.min(
            (upperX - lowerX),
            (upperY - lowerY)) / 2;

        targetBuffer = Math.min(targetBuffer, BUFFER_TARGET);
	}

		


    /**
     * Create a BattleField object.
     *
     * @param r     A reference to your robot object.
     */
/*    public BattleField(Robot r) {

        robotSize = Math.min(
            (r.getWidth()  / 2 - 2),
            (r.getHeight() / 2 - 2));

        minX = robotSize;
        minY = robotSize;
        maxX = r.getBattleFieldWidth()  - robotSize;
        maxY = r.getBattleFieldHeight() - robotSize;
        midX = r.getBattleFieldWidth()  / 2;
        midY = r.getBattleFieldHeight() / 2;

        lowerX = minX + BUFFER_WALL;
        lowerY = minY + BUFFER_WALL;
        upperX = maxX - BUFFER_WALL;
        upperY = maxY - BUFFER_WALL;

        targetBuffer = Math.min(
            (upperX - lowerX),
            (upperY - lowerY)) / 2;

        targetBuffer = Math.min(targetBuffer, BUFFER_TARGET);
    }
*/



    /**
     * Given x,y coordinates and a heading in degrees, returns the
     * distance from x,y to the game boundaries in the given heading.
     * Game boundaries are defined as the absolute game dimensions
     * less half the smallest dimension of a robot.
     *
     * @param   x           The x coordinate.
     * @param   y           The y coordinate.
     * @param   heading     Direction in radians (compass orientation).
     * @return  Distance from x,y to game boundaries along the given
     *          heading.
     *
     */
    public static double distanceToWall(double x,
                                        double y,
                                        double heading) {

        if (heading == 0 || heading == Math.PI*2) return (maxY - y);
        if (heading == Math.PI/2)                 return (maxX - x);
        if (heading == Math.PI)                   return (y - minY);
        if (heading == Math.PI/2*3)               return (x - minX);


        x = (heading > 0  && heading < Math.PI ? maxX - x : minX - x);
        y = (heading > Math.PI/2 && heading < Math.PI/2*3 ? minY - y : maxY - y);

        x /= Math.sin(heading);
        y /= Math.cos(heading);
        return Math.min(x,y);
    }


    /**
     * Returns true if given x,y coordinate is close to a wall
     * and the current given heading will take us into that wall.
     *
     * @param x         The x coordinate.
     * @param y         The y coordinate.
     * @param heading   The current heading in degrees.
     * @return          True if heading into wall; false otherwise.
     */
    public static boolean headedForWall(double x,
                                        double y,
                                        double heading) {

        return distanceToWall(x, y, heading) < BUFFER_WALL;
    }


    /**
     * Tests if a coordinate is near a wall.
     *
     * @param x The x coordinate.
     * @param y The y coordinate.
     * @return  True if the x,y coordinate is near a wall;
     *          false otherwise.
     */
    public static boolean nearWall(double x,double y) {

        return (x < lowerX ||
                x > upperX ||
                y < lowerY ||
                y > upperY );
    }


    /**
     * If Bot is set, returns the best point to be in
     * in relation to that bot; otherwise returns the
     * battlefield midpoint.
     *
     * #param b Enemy bot to base position on.
     * @return  Best point to be at in relation to given bot target.
     */
    public static Point2D.Double pickBestPosition(Enemy enemy) {

        Point2D.Double p = new Point2D.Double(midX, midY);

        if (enemy != null) {


            double bestDistance = 0;
            double targetToMidX = enemy.getX() - midX;
            double targetToMidY = enemy.getY() - midY;
            double targetDistanceToMid =
                Math.sqrt(Math.pow(targetToMidX, 2) +
                             Math.pow(targetToMidY, 2));


            if (targetDistanceToMid < targetBuffer) {

                bestDistance = (targetDistanceToMid -
                    targetBuffer) / targetDistanceToMid;

            } else {

                bestDistance = targetDistanceToMid/
                    (targetDistanceToMid + targetBuffer);
            }

            p.x = targetToMidX * bestDistance + midX;
            p.y = targetToMidY * bestDistance + midY;

            p.x = Math.max(p.x, lowerX);
            p.x = Math.min(p.x, upperX);
            p.y = Math.max(p.y, lowerY);
            p.y = Math.min(p.y, upperY);

        }
        return p;
    }
}
