/**
 * 
 */
package staticline.whiskey;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

import robocode.Rules;
import staticline.AbstractAdvancedRobot;
import staticline.whiskey.utils.Alphabet;
import staticline.whiskey.utils.LStack;
import staticline.whiskey.utils.Pattern;
import weka.classifiers.trees.RandomForest;

/**
 * Proof of concept version of Whiskey
 * Loads classifier and tries to recognize the type of the enemy bot.
 * Ignores all security features of Robocode! 
 */
public class Whiskey extends AbstractAdvancedRobot {
    //bot vars
	public double bulletPower = 2.;
	public double bulletSpeed = Rules.getBulletSpeed(this.bulletPower);
	public double bulletFlightTime = 1.;
	public double move = 0.; //amount of pixel to move in the next movement-step
   
	
    //log vars
    // t_... == 'target'...
    public int t_name;
    public double t_velocity_old = 0.;
    public double t_heading_old = 0.;
    public double t_delta_v = 0.;
    public double t_delta_h = 0.;
    public double t_delta_x = 0.;
    public double t_delta_y = 0.;
    public double t_energy_old = 0.;
    public double t_delta_energy = 0.;
    public double energy_old = 0.;
    public double delta_energy = 0.;
    public double t_distance = .0;
    public Rectangle2D.Double fieldRect;
    
    //simple pm
    public static final Alphabet alphabet = new Alphabet();
    public static final int windowSize = 7;
    public int best_dv_index = -1;  //index of best found delta-velocity
    public int best_dh_index = -1;  //index of best found delta-heading
    
    public LStack<Double> dv = new LStack<Double>(50);//last 300 delta velocities
    public LStack<Double> dh = new LStack<Double>(50);//last 300 delta headings
    //public Stack<Double> dv = new Stack<Double>();//delta velocities
    //public Stack<Double> dh = new Stack<Double>();//delta headings
    
    //Classifiers
    public RandomForest classifier;
    public String arffHeader;
    public Vector<Vector<Pattern>> allPatterns = new Vector<Vector<Pattern>>();
    public LStack<String> dv_sym = new LStack<String>(windowSize);
    public LStack<String> dh_sym = new LStack<String>(windowSize);
    public int towards = 0;//to me 
	public int across = 0;//~90° across my direction
	public int away = 0;//away from me
    
	//graphics
    public int scannedX = Integer.MIN_VALUE;
    public int scannedY = Integer.MIN_VALUE;
    public int[] intermediateX;
    public int[] intermediateY;
    public int projectedX = 0;
    public int projectedY = 0;
    public static double forward_left_angle = 0d;
    public static double forward_right_angle = 0d;
    public static double backward_left_angle = 0d;
    public static double backward_right_angle = 0d;
    
    
	@Override
	public void run(){
        // unlock radar and turret
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setAdjustRadarForRobotTurn(true);
        
        // color the bot
        setColors(Color.ORANGE, Color.BLACK, Color.ORANGE, Color.WHITE, Color.GRAY);
        
        //infinite loop in here - call last!
        super.run();
    }
}
