package dft.bin;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DangerAnalysis {

	private ArrayList <PositionScore> possibilities;
	
	public DangerAnalysis() {
		possibilities = new ArrayList();
	}
	
	public void clear() {
		possibilities.clear();
	}
	
	public int size() {
		return possibilities.size();
	}
	
	public void add(Position newPosition) {
		possibilities.add(new PositionScore(newPosition));
	}
	
	public void updatePosition(int index, Point2D source, double maxVelocity, double targetAngle, double orbitDirection, Rectangle2D battleField, boolean smoothAway) {		
		possibilities.get(index).position.predict(source,maxVelocity,targetAngle,orbitDirection,battleField,smoothAway);
	}
	
	public void updateScore(int index, double scoreUpdate) {
		PositionScore pScore = possibilities.get(index);
		pScore.score += scoreUpdate; 
	}
	
	public void updateScore(int index, MoveWave b, int ticks, ArrayList buffers) {
		Point2D waveProjection = Utils.project(b.waveLocation,b.angle,b.velocity*ticks);
		PositionScore pScore = possibilities.get(index);
		Position p = pScore.position;
		double waveDistance = waveProjection.distance(b.waveOrigin);
		double pDistance = p.getLocation().distance(b.waveOrigin);
		if (!pScore.complete&&waveDistance<pDistance+20&&waveDistance>pDistance-20) {		
			pScore.complete = true;
			for (int i = 0; i < buffers.size(); i++) {
				double[] currentBuffer = (double[])buffers.get(i);
				int factorsInRange = Utils.hittableFactors(pDistance,currentBuffer.length,b.velocity);					
				double GF = Utils.getGF(Utils.normalRelativeAngle(
						Utils.absoluteBearing(b.waveOrigin,p.getLocation())-b.angle),
						b.escapeEnvelope);	
				int GFindex = Utils.getIndex((currentBuffer.length-1)/2,GF);
				/*int lowIndex = GFindex-(factorsInRange-1)/2-1;
				int highIndex = GFindex+(factorsInRange)/2+1;
				for (int j = lowIndex; j <= highIndex; j++) {
					if (j > 0 && j < currentBuffer.length) {
						pScore.score += 1.0;///ticks;
					}
				}*/	
				/*for (int j = 0; j < currentBuffer.length; j++) {
					System.out.print(currentBuffer[j]+ " ");
				}
				System.out.println();*/
				pScore.score += Utils.smoothed(GFindex,currentBuffer,currentBuffer.length);///Math.pow(ticks,2)*b.probability;
				
			}			
		}	
	}
	
	public double getScore(int index) {
		return possibilities.get(index).score;
	}
	
	public Position getPosition(int index) {
		return possibilities.get(index).position;
	}
	
	private class PositionScore {
		
		Position position;
		double score;
		boolean complete;
		
		public PositionScore(Position newPosition) {
			position = newPosition;
			complete = false;
		}
		
	}
		
}
