package genprog;
import robocode.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;

public class Zafaran extends AdvancedRobot {
	public void run() {
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		setFire( 2 );
		setTurnRight(getRadarHeading());
		execute();
	}
	
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeading() + e.getBearing();
		double bearingFromGun = normalRelativeAngleDegrees(absoluteBearing - getGunHeading());
		setTurnGunRight(bearingFromGun);
		setFire( 2 );
		setAhead(getY());
		setFire( 2 );
		execute();
	}
	
	
	
	
	public void onHitRobot(HitRobotEvent e) {
		setAhead(getEnergy());
		setFire( 2 );
		execute();
	}
	
	
	public void onHitWall(HitWallEvent e) {
		if( ( ( getGunHeading() / getY() ) <=  ( ( getX() *  180  ) + getY() ) ) )
		{
			setAhead(( ( ( getHeading() * getHeading() ) * ( ( getRadarHeading() * getRadarHeading() ) / ( ( getGunHeading() / getY() ) + getY() ) ) ) % ( getGunHeading() + getGunHeading() ) ));
			execute();
		}
		setTurnRight(getRadarHeading());
		execute();
	}
}