package tm;

/********************************************************************
* Radar360B.java -- 360][_[
*
* Date:		2002/Nov/22
*
********************************************************************/
class Radar360B implements Radar {
	MyRobot my;
	FieldMap map;
	int radarDirection = 1;


	public Radar360B(MyRobot my) {
		this.my = my;
		this.map = my.map;
	}
	
	public void radarTurnComplete() {
		Enemy ene = map.getNearestEnemy(my.getTime());
		double angle;
		double bearing, distance, absoluteBearing;
		
		if (ene == null) {
			my.setTurnRadarRight(360);
			return;
		}

		
		bearing = ene.getBearing();
		distance = ene.getDistance();

		absoluteBearing = bearing + my.getHeading();		
				
		//[_[]
		angle = absoluteBearing - my.getRadarHeading();
		angle = M.angleUnder180(angle);
		angle = angle + M.sign(angle) * 22;

		if (my.getTime() - ene.getMtime() > 3) {
			angle = 45;
		}		
				
		my.setTurnRadarRight(angle);


		my.map.update(my.getTime());
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void turn360() {
		my.setTurnRadarRight(380);
	}
}