package wiki.twin;
import robocode.*;
//import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;
import java.util.*;
import java.io.*;

/* Based off RaikoMirco, the creation of Jam */
public class InevitableAlpha extends TeamRobot {
	/////////////////////////////////////////////////
	private static final boolean TC = false;
	/////////////////////////////////////////////////
	/* Team stuff */
	static final boolean combineBuddyBin = false;
//	static final boolean targetSameEnemy = true;
	static boolean isDrone = true;
	static boolean onTeam = false;
	static boolean enemyAlive;
	String enemyName;
	static double buddyDirection;
	
	static Point2D.Double robotLocation, enemyLocation, buddyLocation;
	
	/* Movement stuff */
	static final double BEST_DISTANCE = 525;
	static boolean flat = false;
	static double enemyDistance, enemyDelta, enemyEnergy, lastReverseTime, lastVChangeTime, circleDir = 1;
	static int numBadHits, enemyVelocity;
	static Rectangle2D.Double battlefield = new Rectangle2D.Double(18, 18, 764, 764);

	static final int GF_ZERO = 15;
	static final int GF_ONE = 30;
	static int[][][][] guessFactors = new int[6][2][4][GF_ONE+1]; 
	static double bulletPower = 1.9;
	static double bPower = bulletPower;

	static Vector waves = new Vector();
	
	public void run() {
		setColors(Color.black, Color.yellow, Color.red);
		
		//It assumes that if there are more then 1 other bots, then its on a twin team.
		if(!onTeam && getOthers() > 1) onTeam = true;
		//Only happens at beginning of turn, not enough time to hit and gain energy
		if(isDrone && onTeam && getEnergy() > 101) isDrone = false;
		
		waves = new Vector();
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		while(true) {
			enemyAlive = false;
			turnRadarRightRadians(Math.PI*2);
			if(enemyAlive == false) enemyName = null;
		}
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{	
		/* Startup */
		int A, W, D;
		
        double absAngle = getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();

		double velocity = e.getVelocity();

		robotLocation = new Point2D.Double(getX(), getY());
		enemyLocation = new Point2D.Double(getX() + Math.sin(absAngle) * enemyDistance, getY() + Math.cos(absAngle) * enemyDistance);
		
        if ((enemyEnergy -= e.getEnergy()) >= 0.1 && enemyEnergy <= 3.0) 
            enemyDelta = enemyEnergy;
		
        enemyEnergy = e.getEnergy();

		/* Send enemy name to partner */
		if(onTeam)
		{
			String tempName = e.getName();
			if((enemyName == null && !isTeammate(tempName) && !isDrone))
			{
				enemyName = tempName;
				try {
					// Send enemy position to teammates
					broadcastMessage(enemyName);
				} catch (IOException ex) {
					out.println("Unable to send data: " + ex);
				}
			}
			else if(isTeammate(tempName)) return;
			else if(enemyName == null) enemyName = tempName; //Incase only the drone is left
			else if(tempName != enemyName) return;
			enemyAlive = true;
		}

		/* Movement */
		Point2D.Double newDestination;
		
		double distDelta = 0.02 + Math.PI/2 + (enemyDistance > BEST_DISTANCE ? -.1 : .5);
		while (!battlefield.contains(newDestination = project(robotLocation, absAngle + circleDir*(distDelta-=0.02), 170)));

		double theta = 0.5952*(20.0 - bPower * enemyDelta) / enemyDistance;
		if ((Math.random() > Math.pow(theta, theta) && flat) || distDelta < Math.PI/3.5)
		{
			circleDir = -circleDir;
			lastReverseTime = getTime();
		}
		
		theta = absoluteBearing(robotLocation, newDestination) - getHeadingRadians();
		if(!TC){
			setAhead(Math.cos(theta)*100);
			setTurnRightRadians(Math.tan(theta));
		}
		
		/* Gun */
		if(TC) bPower = 3;
		Wave w;
		addCustomEvent(w = new Wave());
		w.bearingDirection = (theta = e.getVelocity())*Math.sin(e.getHeadingRadians() - absAngle) > 0 ? .7D/GF_ZERO : -.7D/GF_ZERO;
		w.speed = 20-bPower*3;
		A = Math.min(4, (int)(Math.sqrt(224D*lastVChangeTime++/enemyDistance)))+1;
		if (enemyVelocity > (enemyVelocity = (int)Math.abs(theta))){
			lastVChangeTime = 0;
			A = 0;
		}
		w.firePosition = robotLocation;
		w.enemyAbsBearing = absAngle;

		if(enemyDistance < 300) D = 0; else if(enemyDistance < 375) D = 1; else if(enemyDistance < 500) D = 2; else D = 3;
		W = battlefield.contains(project(robotLocation, absAngle + w.bearingDirection*GF_ZERO, enemyDistance)) ? 0 : 1;
		w.waveGuessFactors = guessFactors[A][W][D];
		
		int bestGF = GF_ZERO;
		for (int gf = GF_ONE; gf >= 0 && e.getEnergy() > 0; gf--)
			if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF])
				bestGF = gf;

		if(onTeam && buddyLocation != null)
		{
			if(robotLocation.distance(buddyLocation) > 80 ||
			   (normalRelativeAngle(absoluteBearing(robotLocation, buddyLocation)-absAngle) > Math.PI/12 &&
			   robotLocation.distance(buddyLocation) > 400))
					if (getEnergy() > bPower) setFire(bPower);

			if(robotLocation.distance(buddyLocation) < 250 && getTime() - lastReverseTime > 40)
			{
				if(circleDir != buddyDirection)
				{
					lastReverseTime = getTime();
					circleDir=-circleDir;
				}
				else if(isDrone)
				{
					lastReverseTime = getTime();
					circleDir=-circleDir;
				}
			}
		}
		else if (getEnergy() > bPower) setFire(bPower);
		
		
		double avgAngle = w.bearingDirection*(bestGF-GF_ZERO);
		
		if(enemyDistance < 210 || enemyEnergy < 0)
		{
			avgAngle = 0;
			bPower = 3;
		}
		else
			if(enemyEnergy < 10 || getEnergy() < 10)
				bPower = Math.min(enemyEnergy, getEnergy())/(Math.PI*2);
			else
				bPower = bulletPower;

		setTurnGunRightRadians(normalRelativeAngle(absAngle - getGunHeadingRadians() + avgAngle));

		/* send data to team */
		if(onTeam)
		{
			try {
				// Send enemy position to teammates
				broadcastMessage(new TeamMsg(robotLocation.x, robotLocation.y, circleDir, guessFactors));
			} catch (IOException ex) {
				out.println("Unable to send data: " + ex);
			}
		}


		/* setup for next round */
		setTurnRadarRightRadians(normalRelativeAngle(absAngle - getRadarHeadingRadians()) * 2);	
	}

    public void onHitByBullet(HitByBulletEvent e) {
		/* 
			The infamous Axe-hack
	 		see: http://robowiki.net/?Musashi
		*/
		if ((double)(getTime() - lastReverseTime) > enemyDistance/e.getVelocity() && enemyDistance > 200 && !flat) 
	    	flat = (++numBadHits/(getRoundNum()+1) > 1.1);
    }
	public static double normalRelativeAngle(double angle)
		{ return Math.atan2(Math.sin(angle), Math.cos(angle)); }
	public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length)
		{ return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length); }
	private static double absoluteBearing(Point2D.Double source, Point2D.Double target)
		{ return Math.atan2(target.x - source.x, target.y - source.y); }
    public static double absoluteBearing(Point2D source, Point2D target)
		{ return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()); }
	public void onMessageReceived(MessageEvent e) {
		if (e.getMessage() instanceof String) {
			String s = (String) e.getMessage();
			enemyName = s;
		}
		else if (e.getMessage() instanceof TeamMsg) {
			TeamMsg m = (TeamMsg) e.getMessage();
			buddyLocation = new Point2D.Double(m.x,m.y);
			buddyDirection = m.direction;
			
			if(combineBuddyBin) {
				for(int i=0;i<6;i++)
				for(int ii=0;ii<2;ii++)
				for(int iii=0;iii<4;iii++)
				for(int iv=0;iv<(GF_ONE+1);iv++) {
					guessFactors[i][ii][iii][iv] /= 2;
					guessFactors[i][ii][iii][iv] += m.gf[i][ii][iii][iv]/2;
				}
			}
		}
	}

	public void onHitRobot(HitRobotEvent e)
	{
		//If you hit something, bounce off
		if(e.isMyFault())
			circleDir = -circleDir;
	}

	class Wave extends Condition
	{
	
		Point2D.Double firePosition;
		int[] waveGuessFactors;
		double enemyAbsBearing, speed, distance, bearingDirection;
	
		public boolean test(){

			if (enemyLocation.distance(firePosition) <= (distance+=speed)+(-1.5*speed)){
				try {
					waveGuessFactors[(int)Math.round(normalRelativeAngle(absoluteBearing(firePosition, enemyLocation) - enemyAbsBearing)/bearingDirection + GF_ZERO)]++;
				} catch (ArrayIndexOutOfBoundsException e){}
				removeCustomEvent(this);
			}
		return false;
		}
	}
}

class TeamMsg implements Serializable {
	public double x, y, direction;
	int gf[][][][];
	public TeamMsg(double _x, double _y, double _d, int _gf[][][][])
	{
		x=_x;
		y=_y;
		direction = _d;
		gf=_gf;
	}
}
