package pl.Abstract;

/*******************************************************************************
 * An abstract class for guns. A robot using Guns should increment the misses in
 * onBulletMissed() and onBulletHitBullet(), and increment hits in
 * onBulletHit(). This class conveniently defines a class called getGrade() that
 * calculates a 'grade' for the gun, which is useful when deciding the best gun
 * to use when using multiple guns based on previous performance.
 ******************************************************************************/
public abstract class Gun {
	/**
	 * The amount of times the gun has missed. This should be incremented in the
	 * robot's onBulletMissed() and onBulletHitBullet() methods.
	 */
	public int misses;
	/**
	 * The amount of times the gun has hit. This should be incremented in the
	 * robot's onBulletHit() method.
	 */
	public int hits;
	/**
	 * The name of the gun.
	 */
	public String name;
	/**
	 * The AdvancedRobot that uses this gun. All actions done by Guns will call
	 * it through this variable.
	 */
	public static robocode.AdvancedRobot robot;

	/**
	 * Constructor for the gun with the name for the gun
	 * 
	 * @param name name to assign to the gun
	 * @param robot robot using this gun
	 */
	public Gun(String name, robocode.AdvancedRobot robot) {
		this.name = name;
		Gun.robot = robot;
	}

	/**
	 * Method for controlling the gun.
	 * 
	 * It should be called by whatever needs to shoot with the gun.
	 * 
	 * @param enemy the enemy to use the gun against
	 */
	public abstract void run(pl.Enemy.AdvancedEnemy enemy);

	/**
	 * Calculates the 'grade' of the gun.
	 * 
	 * @return the number of hits divided by the total bullets fired; infinity
	 *         if both are 0.
	 */
	public double getGrade() {
		// Favor guns that haven't been used yet.
		if (hits == 0 && misses == 0)
			return Double.POSITIVE_INFINITY;
		else
			return (double) hits / (hits + misses);
	}
}