package hamilton;

public class HalfLinearAiming extends StationaryAiming
{
	static public FiringSolution getSolution(AimingInfo someInfo)
	{
		double firepower = calculateFirepower(someInfo);
		double bulletVelocity = 20 - (3 * firepower);
		
		double theta = .5 * Math.asin((Math.sin(someInfo.getTargetRelativeHeading()) * someInfo.getTargetVelocity()) / bulletVelocity);

		double bearing = Calculator.normalizeAngle(someInfo.getTargetAbsoluteBearing() + theta);
		
		boolean validity = true;
				
		bearing = Calculator.normalizeAngle(someInfo.getTargetAbsoluteBearing() + theta);
		return new FiringSolution(bearing, firepower, validity);
	}

}
