package hamilton;

import java.util.*;
import java.io.*;

public class Target
{
	String name;
	Stack scans;
	
	Memory stats;

	double acceleration;
	double changeInHeading;
	
	double timeSinceLastScan;
	double changeInEnergy;
	double energyCorrection;
	double gunHeat;
	
	double lastReverseTime;
	
	public Target(String someName, File someFile, ScanInfo someScan)
	{
		name = someName;
		
		scans = new Stack();
		
		stats = new Memory(someFile);
		
		acceleration = 0;
		changeInHeading = 0;
		
		timeSinceLastScan = 0;
		changeInEnergy = 0;
		energyCorrection = 0;
		gunHeat = 0;
		
		lastReverseTime = 0;
				
		scans.add(someScan);
	}
	
	public void update(ScanInfo someScan)
	{
		acceleration = ((someScan.absoluteVelocity - getLastScan().absoluteVelocity) / (someScan.timeStamp - getLastScan().timeStamp));
		changeInHeading = Calculator.relativeAngle((someScan.heading - getHeading()) / (someScan.timeStamp - getLastScan().timeStamp));	
		
		timeSinceLastScan = someScan.timeStamp - getLastScan().timeStamp;
		
		// adjust absoluteHeading for stationary bot
		if (someScan.absoluteVelocity == 0)
		{
			someScan.absoluteHeading = getLastScan().absoluteHeading;
		}
		
		// change in direction statistics
		if (timeSinceLastScan <= 1)
		{
			if ((someScan.absoluteVelocity > 0) && (getLastScan().absoluteVelocity <= 0)) 
			{
				double halfPeriod = someScan.timeStamp - lastReverseTime;
				stats.averageHalfPeriod.addObservation(halfPeriod);
				lastReverseTime = someScan.timeStamp;	
				System.out.println("reverse");			
			}
		}
		
		// fired bullet detection
		changeInEnergy = getLastScan().energy - someScan.energy + energyCorrection;	
		energyCorrection = 0;
		gunHeat -= (timeSinceLastScan * .1);
		if (gunHeat < 0) gunHeat = 0;
		double timeUntilNextShot = gunHeat / .1;
		
		
		
		// System.out.println(someScan.timeStamp + ": " + timeUntilNextShot + " ticks until next shot.");

		scans.add(someScan);	
	}
	
	public ScanInfo getLastScan()
	{
		return (ScanInfo)scans.peek();
	}
	
	public double getTimeStamp()
	{
		return getLastScan().timeStamp;
	}
	
	public Coordinate getCoordinates()
	{
		return getLastScan().coordinates;
	}
	
	public double getVelocity()
	{
		return getLastScan().velocity;
	}
	
	public double getHeading()
	{
		return getLastScan().heading;
	}
	
	public double getChangeInHeading()
	{
		return changeInHeading;
	}
	
	public double getAbsoluteVelocity()
	{
		return getLastScan().absoluteVelocity;
	}
	
	public double getAbsoluteHeading()
	{
		return getLastScan().absoluteHeading;
	}
	
	public double getEnergy()
	{
		return getLastScan().energy;
	}
	
	public double getAcceleration()
	{
		return acceleration;
	}
	
	public String getBestAlgorithm()
	{
		Collection c = stats.algorithmMap.keySet();
		Iterator i = c.iterator();
		
		String bestName = "stationary";
		double bestAverage = 0;
		
		while(i.hasNext())
		{
			String nextName = (String)i.next();
			Statistic nextStat = (Statistic)stats.algorithmMap.get(nextName);
			double nextAverage = nextStat.getMean();
			
			if (nextAverage >= bestAverage)
			{
				bestName = nextName;
				bestAverage = nextAverage;
			}
		}
		
		return bestName;
	}
	
	public void hamiltonHitTarget(double somePower)
	{
		double damage = 4 * somePower; 
		if (somePower > 1) damage += 2 * (somePower-1);
		
		energyCorrection -= damage;
	}
	
	public void targetHitHamilton(double somePower)
	{
		double reward = 3 * somePower;
		
		energyCorrection += reward;
	}
	
	public void updateAimingStats(String name, double value)
	{
		if (!stats.algorithmMap.containsKey(name))
		{
			stats.algorithmMap.put( name, new Statistic(value));
			
		}
		
		else
		{
			Statistic s = (Statistic)stats.algorithmMap.get(name);
			s.addObservation(value);		
		}
	}	
	
	public void writeMemory()
	{
		stats.writeFile();
	}	

}

