/**
Notes: 	Just a place for me to keep track of what needs to be done.
		
		Targeting Strategies:
			Head-on
			Linear/Circular
			Random
			PatternMatching
			Relative Angele PM	*need to add*
			GuessFactor segmented on:
				Distance
				latV			*need to add*
				nearwall		*need to add*
				my FirePower	*need to add*
				Distance/latV	*need to add*
			
		Movement Strategies:
			Random GoTo
			AntiGravity
			Random Oscillation
			Random Corner
			Wave Surfing	*need to add*
			Bullet Dodging	*need to add*
			CurveFlatening	*need to add*
**/

package ne;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.io.*;
import java.util.zip.*;

/**
 	Chimera - a robot by Nathaniel Summers
	This bot is basically a ton of wildly different
	movement and targeing strategies rolled into one bot.
	
	The different movement and targeting styles are not simply
	chosen but rather every one is used at once by the use of weights.
	The methods that are most successful are the one's that are
	given more weight. Essentially this means that there is a smooth
	transition from one mode to another. It's all based off of a
	gain/loss function. Certain things reward the highest weight and
	certain things punish the highest weight.
	
	This should make this bot unique in comparison to how other bots operate.
	SpareParts comes close but it doesn't really average styles together.
	
	Theoretical advantages:
		1) Difficult to predict because it's allways changing.
		2) Versitile because it can adapt to any situation.
	Disadvantages:
		1) Every movement and targeting style must retun a point in space
			for it to shoot at or move to. This makes for a bit extra work
			making the movement work for a goTo function and the targeting
			work for a shootAt function. This doesn't really apply to battle
			but rather to how difficult it is to code.
		2) Big as all hell, not to mention slow.
		3) Predictability of the GoTo Style movement.
 **/
public class Chimera extends utils
{
	
	/**
	 * run: default behavior
	 */
	static Hashtable Bots;			//Keeps track of all the bot's stats. It's static to save info between rounds.
	Hashtable MovePoints;			//places to move to.
	double movlosscount = 0,movgaincount = 0;
	static String lasthitme;		//the name of the bot that last hit me with a bullet.
	bot target;						//the one we're after.
	Hashtable Bullets;				//Keeps track of bullets with specific direction, 
									//IE: Team robot bullets, and circular/linear targeting VBullets, etc...
	Hashtable Waves;				//Keeps track of enemy waves.
	Hashtable MyWaves;				//Keeps track of our waves.
	static double PI = Math.PI;		//just a constant
	int botCount = 0;				//number of bots
	double firePower = .1;			//how strong our bullts are.
	double energy = 100;			//our energy.
	boolean canFire=true, canMove=true, bulletBlind=false;		//some configurations
	String MovType = "";			//Restriction on movement type. Set to "" for no restriction;
									//Move types are: agrav, oscillate, randmove, cornermove
	double FPLimit = 3;				//The highest firepower we can use.
	double FPis = 0;				//If this isn't zero, This is the FP.
	int direction = 1, counter = 0, stillcount = 0;
	double randcount = 0, randX, randY, cornerX, cornerY, oscOffset;
	static double Fwidth, Fheight;
	double midpointstrength = 0;	//The strength of the gravity point in the middle of the field
	int midpointcount = 0;			//Number of turns since that strength was changed.
	double changehead=0,lastheading;	//My last heading change.
	int bltCount = 0;				//number of bullets in the air.
	double  Hang, Pang, Cang, Rang, Gang;	//Angles of every targeting method.
	
	public void run() {
		setColors(Color.orange,Color.yellow,Color.red);	//sets the colours of the robot
		Fwidth = getBattleFieldWidth();
		Fheight = getBattleFieldHeight();
		
		if (Bots == null)	{
			Bots = new Hashtable();
		}
		if (MovePoints == null)	{
			MovePoints = new Hashtable();
		}
		target = new bot();
		target.distance = 1000;
		target.name = "";
		Bullets = new Hashtable();
		Waves = new Hashtable();
		MyWaves = new Hashtable();
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		target.live = false;		//to make sure we can pick that first target.
		if (Bots != null) {
			bot bt;
			Enumeration e = Bots.elements();
	    	//cycle through all the enemies and default them to dead.
			while (e.hasMoreElements()) {
    	   	 	bt = (bot)e.nextElement();
				bt.live = false;
	    	}
		}
		lastheading = getHeading();

		//out.println("about to run");
		while(true) {
			changehead = lastheading-getHeadingRadians();
			lastheading = normaliseBearing(getHeadingRadians());
			
			doScanner();
			doTargetSelect();
			if (canMove) doMovement();
			
			doFirePower();
			if ((getGunHeat()<=getGunCoolingRate()*2)&&(target.live)&&(getTime()-target.ctime < 8)) {
				//if we're getting ready to fire, take aim ahead of time.
				doGun();
			} else {
				//Otherwise, point the gun directly at the target.
				setTurnGunLeftRadians(normaliseBearing(getGunHeadingRadians() - (Math.PI/2 - Math.atan2(target.y - getY(), target.x - getX()))));
			}
		
			if ((firePower>0)&&(getGunHeat()==0)&&(getGunTurnRemaining()<5)&&(target.live)&&(getTime()-target.ctime<2)&&(canFire)) {
				target.shotAt++;
				if (FPis != 0)	firePower = FPis;
				setFire(firePower);
				fireWave();
			}
			//drawBullets();
			//drawWaves();
			//drawFBots();
			updateWaves();
			execute();
		}
	}


			/**keep the scanner turning**/
	void doScanner() {
    	//standard absolute bearing
		double offset = target.bearing+getHeadingRadians();
		if (((getTime() > target.ctime+4)||(target.live==false)||((getGunHeat()>getGunCoolingRate()*4)&&(getOthers()>1)))||(target.gunheat>getGunCoolingRate()*4&&target.gunheat<-getGunCoolingRate()*4)) {
			offset = PI*2;
			//if we havent seen anyone in a while, sweep our radar and increase the weight of the sweep behavior.
			if (getTime() > target.ctime+10)	{
				movpt p;
				Point2D.Double point;
				if (MovePoints.containsKey("sweep"))	{
					p = (movpt)MovePoints.get("sweep");
					p.weight*=1.1;
				}
				normMovement();
			}
			if (getTime() > target.ctime+1000)	{
				movpt p;
				Point2D.Double point;
				if (MovePoints.containsKey("walls"))	{
					p = (movpt)MovePoints.get("walls");
					p.weight*=1.2;
				}
				normMovement();
			}
		} else {
			//Turn towards the target.
			offset = normaliseBearing(offset-getRadarHeadingRadians());
			//Oscilate in order to avoid loosing the target.
			offset += (offset > 0) ? 100/target.distance : -100/target.distance;
		}
		//now spin the radar ;)
		setTurnRadarRightRadians(offset);
        }

void doFirePower() {
		energy = getEnergy();
				//fire bullets based on how easily we can hit the target.
				//firePower = Math.min(2.2+target.hitRate,(1200/target.distance+1)*Math.max(target.hitRate,.1));
				int seg = (int)Math.max(0,Math.min(target.distance/100-1,9));
				if (target.name != "") 
				firePower = 2.2+((target.Pang[seg]+target.Hang[seg]+target.Cang[seg]+target.Rang[seg]+target.Gang[seg])/5);
				
				//out.println(target.name + ": " + ((int)(target.hitRate*100)) + "% HitRate");
				//Don't fire a bullet more powerful than needed to kill the enemy.
				if (firePower > target.energy/4)
				firePower = (target.energy/4)+.1;
				
				//Don't fire a bullet that will disable us.
				if (firePower > energy/4)
				firePower = (energy/4)-.1;
				
				//if it's disabled, and the only one, ram it.
				if ((target.energy < .8)&&((getOthers()<=1)||(target.distance<200)))	{
					firePower = 0;
					Point2D.Double Fpos = CircularTargeting();
					goTo(Fpos.x,Fpos.y);
				}
				
				firePower = Math.min(firePower,FPLimit);
	}

void doLOS(double ang)	{
	//This funciton simply checks to see if there are any teammates in the way of our firing angle.
	//It translates the firepower to zero if this is the case.
	Point2D.Double fpos = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
	bot bt;
	Enumeration e = Bots.elements();
	while (e.hasMoreElements())	{
		double d = 1000;
		bt = (bot)e.nextElement();
		if ((bt.live)&&(isTeammate(bt.name)==true))	{
			d = getRange(fpos.x,fpos.y,bt.x,bt.y);
			d = getRange(bt.x,bt.y,d*Math.sin(ang),d*Math.cos(ang));
			if (d <= 50) firePower = 0;
		}
	}
}
	
	/**Move the gun to the predicted next bearing of the enemy**/
	void doGun()	{
		int seg = (int)Math.min(target.distance/100-1,9);
		//offsets the gun by the angle to the next shot based on linear targeting provided by the enemy class
		Point2D.Double fpos = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
		Point2D.Double Pfpos = PatternTargeting();
		Point2D.Double Hfpos = HOTargeting();
		Point2D.Double Cfpos = CircularTargeting();
		Point2D.Double Rfpos = RandomTargeting();
		Point2D.Double Gfpos = GFTargeting();
		Point2D.Double efpos = Pfpos;
		double xforce = 0, yforce = 0,ang,force;
		
		//We initialize the original location to targeting method that is most accurate.
		double best = 0;
		if (target.Pang[seg] > best)	{
			efpos = Pfpos;
			best = target.Pang[seg];
		}
		if (target.Hang[seg] > best)	{
			efpos = Hfpos;
			best = target.Hang[seg];
		}
		if (target.Cang[seg] > best)	{
			efpos = Cfpos;
			best = target.Cang[seg];
		}
		if (target.Rang[seg] > best)	{
			efpos = Rfpos;
			best = target.Rang[seg];
		}
		if (target.Gang[seg] > best)	{
			efpos = Gfpos;
			best = target.Gang[seg];
		}
		
		//next we adjust the final targeting location based on all the targeting methods.
	    //Find the bearing from the point to us
	    ang = normaliseBearing(Math.PI/2 - Math.atan2(Pfpos.y - efpos.y, Pfpos.x - efpos.x)); 
		force = Math.pow(target.Pang[seg],3);
	    //Add the components of this force to the total force in their respective directions
	    xforce += Math.sin(ang) * force;
	    yforce += Math.cos(ang) * force;
	
		ang = normaliseBearing(Math.PI/2 - Math.atan2(Hfpos.y - efpos.y, Hfpos.x - efpos.x)); 
		force = Math.pow(target.Hang[seg],3);
	    //Add the components of this force to the total force in their respective directions
	    xforce += Math.sin(ang) * force;
	    yforce += Math.cos(ang) * force;
	
		ang = normaliseBearing(Math.PI/2 - Math.atan2(Cfpos.y - efpos.y, Cfpos.x - efpos.x)); 
		force = Math.pow(target.Cang[seg],3);
	    //Add the components of this force to the total force in their respective directions
	    xforce += Math.sin(ang) * force;
	    yforce += Math.cos(ang) * force;
	
		ang = normaliseBearing(Math.PI/2 - Math.atan2(Rfpos.y - efpos.y, Rfpos.x - efpos.x)); 
		force = Math.pow(target.Rang[seg],3);
	    //Add the components of this force to the total force in their respective directions
	    xforce += Math.sin(ang) * force;
	    yforce += Math.cos(ang) * force;
	
		ang = normaliseBearing(Math.PI/2 - Math.atan2(Gfpos.y - efpos.y, Gfpos.x - efpos.x)); 
		force = Math.pow(target.Gang[seg],3);
	    //Add the components of this force to the total force in their respective directions
	    xforce += Math.sin(ang) * force;
	    yforce += Math.cos(ang) * force;
		
		//Apply the forces;
		efpos.x += xforce;
		efpos.y += yforce;
		drawCircle(efpos,23,Color.RED);
		ang = (Math.PI/2 - Math.atan2(efpos.y - fpos.y, efpos.x - fpos.x));
		doLOS(ang);
		setTurnGunLeftRadians(normaliseBearing(getGunHeadingRadians() - ang));
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//predict the location of an object one tick head in time.
	Point2D.Double futurePosition(Point2D.Double pos, double speed, double heading, double time) {
		//need to add a for loop for time.
			pos.x += speed*Math.sin(heading);
			pos.y += speed*Math.cos(heading);
		return pos;
	}
	
	
	Point2D.Double PatternTargeting() {
		//A symbolic pattern matching targeting system that extends the use of 'futurePosition'
		//Take the movement of the target from our current battern block.
		String Pattern = target.PatternBuffer[target.PBIndex];
		
		

		double d = 0;
		Point2D.Double fpos = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
		double myX = fpos.x;
		double myY = fpos.y;
		fpos = new Point2D.Double(target.x,target.y);
		double s = target.speed;
		double h = target.heading;
		int step = 0;
		//Stick in a loop until the target has moved long enough for the bullet to have hit it.
		//out.println("Predicting target bullet intercept: myX" + myX +" myY:" + myY + " distance:" + target.distance + " heading:" + h);
		do {
			
			///////////////////////////////////////////////////////////
			
		boolean found = false;
		int searchlength = Math.max(0,Math.min(140,Pattern.length()-1));
		if (searchlength % 2 != 0) searchlength = Math.max(2,searchlength-1);
		String Future = "";
		String[] f;
		int[] Fcount;
		int index;
		int Flength, Ftotal;
		do	{
			f = new String[400];
			String eval = "";
			Fcount = new int[400];
			Flength = 0;
			for(int i = 0; i < 400; i++)	{
				f[i] = "";	//null pointer protection.
				Fcount[i] = 0;
			}
			Pattern = Pattern.toString().substring(Pattern.length()-searchlength,Pattern.length());
			for(int i = 0; i<99; i++)	{	//search all the blocks for our pattern.
				int r = 0, b = 0;
				index = 0;
				if (target.PatternBuffer[i] == null) target.PatternBuffer[i] = "";	//null pointer protection.
			//the following loop is mostly to gather up to four matches in each block.
			do	{
				eval = target.PatternBuffer[i].substring(r,target.PatternBuffer[i].length());
				if (i == target.PBIndex) eval = eval.substring(0,eval.length()-searchlength);
				index = eval.toString().indexOf(Pattern);
				if (( index & 1 ) != 0) index = -1;
				if (index > -1)	{			//if we find our pattern.
					found =  true;
					Future = eval.toString().substring
						(index+searchlength,Math.max
						(0,Math.min(eval.length(),index+searchlength+2)));
					if ((Future=="")||(Future==null)) found = false;
					if (Future.length()<2) {	
						found = false;
						Future = "";
					}
					int j = 0;
					for(j = 0; j < Flength; j++)	{
						if (f[j] == null) f[j] = "";	//null pointer protection.
						if ((f[j] == Future)&&(Future!=""))	{
							Fcount[j]++;	//if it exists, add one to it's bucket.
							j = 9999;		//and end the loop.
						}
					}
					if ((j != 9999)&&(Flength<400))	{
						f[Flength] = Future;		//if it doesn't allready exit, add it at the end.
						Fcount[Flength] = 1;
						Flength++;			//and add to the number of buckets.
						b++;
					}
					if ((Flength >=399)||(b>4))	index = -1;	//if there is more than four matches in the block, fall out of the loop.
				}
				r += index+searchlength;
			} while	(index > -1);	//fall out of the loop if there is no match
			}
			searchlength-=2;
			Ftotal = 0;
			for (int j = 0; j<399; j++)	{
				Ftotal+=Fcount[j];
			}
			if (Ftotal<5) found = false;			//If we've only found a few matches, keep looking.
			if (searchlength <= 0) found = true;	//If we can't find a match to our pattern, drop out of the loop.
		} while (!found);	//if we havn't found a pattern match, keep looking.
		
		//search through the future tick buckets for the one with the highest probability.
		//searchlength now becomes a bucket drop counter.
		searchlength = -10;
		for (int j = 0; j <399; j++)	{
			if ((Fcount[j] > searchlength)&&(f[j]!=""))	{
				searchlength = Fcount[j];
				Future = f[j];
			}
		}
		if (Future.length()<2) Future = "";	//if the future string is too short, make it nothing.
				
		found = true;
		//Extracts the v and ch data from the'Future' string.
		if (Future.length() == 0)	{	//if the future prediction comes up with not enough data, use circular/linear prediction.
			//If the pattern we're looking for is long enough, just use circ/lin targeting past what we don't know.
			if (Pattern.length() >= 2) Future = Pattern.toString().substring(Pattern.length()-2,Pattern.length());
			else Future = "" + ((char)(Math.round(s*4)+32))+(char)Math.round(target.changehead*18+32);
			//if we have no clue what we're looking for, just use the last data we had.
			found = false;
		}
			
			//This predicts the location one tick ahead.
			d += 20-3*firePower;
			fpos = futurePosition(fpos, s, h, 1);
			
			
			/**		wall collision handeling.
			essentially if we can tell that the bot is close enough that it might hit the wall,
			we find each one of the bot's corners and determine if they are out of bounds.
			if they are found to be out of bounds, we alter the future string such that the bot's
			next velocity is zero. This is accurate enough to handle walls and spinbot's wall 
			collisions and that's good enough for me.
			**/
			if ((fpos.x < 24)||(fpos.y < 24)||(fpos.x > Fwidth-24)||(fpos.y > Fheight-24))	{
				//initialize the angle to the first corner.
				double ang = normaliseHeading(h + (PI/4));
				double x = fpos.x;
				double y = fpos.y;
				//step through all the corners.
				for(int i = 0; i <3; i++)	{
					//22.63 is the approximate distance from the center of a bot to any of it's corners.
					x = fpos.x + 22.63*Math.sin(ang);
					y = fpos.y + 22.63*Math.cos(ang);
					//check if out of bounds
					if ((x < 0)||(y < 0)||(x > Fwidth)||(y > Fheight))	{
						String temp = Future;
						Future = "" + (char)(32) + temp.charAt(1);
						found = true;
					}
					//next corner.
					ang = normaliseHeading(ang+(PI/2));
				}
			}
			
			//if at any time a bot's predicted location is REALLY out of bounds, correct it.
			if (fpos.x < 16)
			fpos.x = 16;
			if (fpos.y < 16)
			fpos.y = 16;
			if (fpos.x > Fwidth-16)
			fpos.x = Fwidth-16;
			if (fpos.y > Fheight-16)
			fpos.y = Fheight-16;
		
		
			s = (((byte)Future.charAt(0))-32)/4;
			h = normaliseHeading(h + (((double)((byte)Future.charAt(1))-32)/18));
			if (found)	Pattern+= Future;
			//out.println(d);
		}while (d < getRange(myX,myY,fpos.x,fpos.y));
		if (target.energy == 0)	fpos = new Point2D.Double(target.x,target.y);
		
		Pang = normaliseBearing(Math.PI/2 - Math.atan2(fpos.y - myY, fpos.x - myX));
		return fpos;
	}

	Point2D.Double CircularTargeting() {
		//Circular/linear targeting system that extends the use of 'futurePosition'
		double d = 0;
		Point2D.Double fpos = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
		double myX = fpos.x;
		double myY = fpos.y;
		fpos = new Point2D.Double(target.x,target.y);
		double h = target.heading;
		//Stick in a loop until the target has moved long enough for the bullet to have hit it.
		//out.println("Predicting target bullet intercept: myX" + myX +" myY:" + myY + " distance:" + target.distance + " heading:" + h);
		do {
			d += 20-3*firePower;
			fpos = futurePosition(fpos, target.speed, h, 1);
			
			//A somewhat stupid version of wall collision handeling.
			if (fpos.x < 22)
			fpos.x = 22;
			if (fpos.y < 22)
			fpos.y = 22;
			if (fpos.x > Fwidth-22)
			fpos.x = Fwidth-22;
			if (fpos.y > Fheight-22)
			fpos.y = Fheight-22;
			
			h = normaliseHeading(h+target.changehead);
			//out.println(d);
		}while (d < getRange(myX,myY,fpos.x,fpos.y)-10);
		Cang = normaliseBearing(Math.PI/2 - Math.atan2(fpos.y - myY, fpos.x - myX));
		return fpos;
	}

	Point2D.Double HOTargeting() {
		Point2D.Double fpos = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
		Hang = normaliseBearing(Math.PI/2 - Math.atan2(target.y - fpos.y, target.x - fpos.x));
		return new Point2D.Double(target.x,target.y);
	}

	Point2D.Double RandomTargeting()	{
		Point2D.Double fpos = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
		double myX = fpos.x;
		double myY = fpos.y;
		double ang = (Math.PI/2 - Math.atan2(target.y - getY(), target.x - getX()));
		ang += Math.random()*maxBearing()*2-maxBearing();
		fpos.x += target.distance*Math.sin(ang);
		fpos.y += target.distance*Math.cos(ang);
		Rang = normaliseBearing(Math.PI/2 - Math.atan2(fpos.y - myY, fpos.x - myX));
		return fpos;
	}

	Point2D.Double GFTargeting() {
		Point2D.Double fpos = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
		double myX = fpos.x;
		double myY = fpos.y;
		int seg = (int)Math.min(target.distance/100-1,9);
		double[] gf;
		gf = (double[])target.GuessFactor.get(""+seg);
		double best = 0, ang = 0, o;
		int b = bins(Math.max(0,seg-1));
		o =(maxBearing()*2)/b;
		for(int i = 0; i < b; i++)	{
			if (gf[i] > best)	{
				best = gf[i];
				ang = i;
			}
		}
		//I think this is working well enough for the most part.
		//it still needs some tweaking but otherwise I think it's doing ok.
		ang = Hang+(((ang*(target.latV < -.01 ? -1 : 1))-((b-1)/2))*o);
		fpos.x = myX + target.distance*Math.sin(ang);
		fpos.y = myY + target.distance*Math.cos(ang);
		//drawLine(new Point2D.Double(myX,myY),fpos,Color.yellow);
		Gang = normaliseBearing(Math.PI/2 - Math.atan2(fpos.y - myY, fpos.x - myX));
		return new Point2D.Double(fpos.x,fpos.y);
	}

	public double maxBearing() {
        return Math.abs(Math.asin(8/(20-3*firePower)));
    }

	void fireWave()	{
		Mwave mw;
		mw = new Mwave();
		MyWaves.put(""+target.name+(getTime()-1),mw);
		//The origin of the wave based on where we'll be in one tick.
		mw.origin = futurePosition(new Point2D.Double(getX(),getY()), getVelocity(),getHeading(),1);
		mw.target = target.name;	//who we where shooting at, because I know we can change targets before a bullet hits them.
		mw.time = getTime()-1;
		mw.radius = 0;
		mw.speed = 20-3*firePower;
		mw.power = firePower;
		mw.maxang = maxBearing();
		mw.zero = Hang;
		mw.Pang = Pang;
		mw.Cang = Cang;
		mw.Rang = Rang;
		mw.Gang = Gang;
		mw.live = true;
		mw.seg = (int)Math.min(target.distance/100-1,9);
		mw.dir = (target.latV < -.01 ? -1 : 1);
	}


	
	//Function that updates the waves and puts drops in the appropriate bins if a hit is registered.
	void updateWaves()	{
		bot bt;
		Mwave wv;
		double[] gf;
		Enumeration e = MyWaves.elements();
		while (e.hasMoreElements()) {
			wv = (Mwave)e.nextElement();
			bt = (bot)Bots.get(wv.target);
			gf = (double[])bt.GuessFactor.get(""+wv.seg);
			double TD = getRange(bt.x,bt.y,wv.origin.x,wv.origin.y);
			wv.radius = (getTime()-wv.time)*wv.speed;
			double ang = normaliseBearing(wv.zero-absbearing(wv.origin.x,wv.origin.y,bt.x,bt.y));
			int b = bins(Math.max(0,wv.seg-1));
		//	drawCircle(wv.origin,wv.radius,Color.green);
		//	drawLine(new Point2D.Double(wv.origin.x+wv.radius*Math.sin(wv.zero),wv.origin.y+wv.radius*Math.cos(wv.zero)),wv.origin,Color.red);
			for (int i = 0; i < b; i++)	{
				gf[i] = Math.max(0,gf[i]-.25);
			}
			if (bt.live == false)	{
				//If the bot this wave was targeting is dead, kill the wave.
				wv.live = false;
				MyWaves.remove(""+wv.target+wv.time);
			}
			if ((TD-wv.radius < 22)&&(wv.live))	{
				/**
				hits should start being registered at a distance of 22 from the target's center
				and hits should continue to be registered up to 22 past the target's center.
				This should insure that we get drops for ALL correct angles.
				**/
				double s =(wv.maxang*2)/b;
				int g = Math.max(0,
						Math.min(b-1,
						(int)Math.round(
						((b-1)/2)+(ang*s*wv.dir)
						)));
				gf[g]+=3;
				gf[Math.max(0,g-1)]+=1.5;
				gf[Math.max(0,g-2)]+=.25;
				gf[Math.min(b-1,g+1)]+=1.5;
				gf[Math.min(b-1,g+2)]+=.25;
				
				/**@here I need to come up with a way to evaluate the accuracy of each targeting method here 
				for my super hybrid fuzzy logic gun array. So far both my stastical symbolic pattern matcher
				and my guessfactor gun are performing fairly well. Now I simply must combine all of the guns
				in order to produce one that takes all targeting methods into account. I may even work on a 
				function that changes the firepower based on the combined stastical probability of getting a
				hit from all the targeting methods, such that it fires bullets of higher power when the
				various targeting methods are in relative agreement.
				**/
				ang = normaliseBearing(absbearing(wv.origin.x,wv.origin.y,bt.x,bt.y));
				bt.Hang[wv.seg] = ((bt.Hang[wv.seg]*8)+GFAngEval(wv.origin,wv.radius,ang,wv.zero))/9;
				bt.Pang[wv.seg] = ((bt.Pang[wv.seg]*8)+GFAngEval(wv.origin,wv.radius,ang,wv.Pang))/9;
				bt.Cang[wv.seg] = ((bt.Cang[wv.seg]*8)+GFAngEval(wv.origin,wv.radius,ang,wv.Cang))/9;
				bt.Rang[wv.seg] = ((bt.Rang[wv.seg]*8)+GFAngEval(wv.origin,wv.radius,ang,wv.Rang))/9;
				bt.Gang[wv.seg] = ((bt.Gang[wv.seg]*8)+GFAngEval(wv.origin,wv.radius,ang,wv.Gang))/9;
			}
			if (TD-wv.radius < -22)	{
				//after the wave has completely past the target, delete it.
				wv.live = false;
				MyWaves.remove(""+wv.target+wv.time);
			}
	    }
	}

	double GFAngEval(Point2D.Double o, double dist, double a, double e)	{
		double x;
		Point2D.Double Actual = new Point2D.Double(0,0), Eval= new Point2D.Double(0,0);
		Actual.x 	= o.x+dist*Math.sin(a);
		Actual.y 	= o.y+dist*Math.cos(a);
		Eval.x 		= o.x+dist*Math.sin(e);
		Eval.y 		= o.y+dist*Math.cos(e);
		x = getRange(Actual.x,Actual.y,Eval.x,Eval.y);
		//out.println(x);
		if (x > 16)	{
			return 0;
		}	else	{
			return 1;
		}
	}

	//This funciton alters the number of GF bins based on what distance segment it's fed.
	int bins(int i)	{
		i *= 3;
		//if it's even, add one to it. We need an odd number so that the zero bin is always dead on.
		if (i % 2 == 0) i++;
		return i;	
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		bot bt;
		if (Bots.containsKey(e.getName())) {
			bt = (bot)Bots.get(e.getName());
		} else {
			bt = (bot)readObject(e.getName());
			if (bt != null)	{
				Bots.put(e.getName(),bt);
			}else	{
			bt = new bot();
			Bots.put(e.getName(),bt);
			bt.name = e.getName();
			bt.rounds = 0;
			bt.PatternBuffer = new String[100];
			bt.PBIndex = 0;
			bt.PBLength = 10;
			botCount ++;
			bt.GuessFactor = new Hashtable();		//the guess factors, factored by distance.
			
			//the accuracy of each targeting method, factored by distance.
			bt.Hang = new double[10];
			for (int i = 0; i < 10; i++)	{
				bt.Hang[i] = 1;
			}
			bt.Pang = bt.Hang;
			bt.Cang = bt.Hang;
			bt.Rang = bt.Hang;
			bt.Gang = bt.Hang;
			
			//Initializes the GF Bins
			for(int i = 0; i <= 10; i++)	{
				double[] gf;
				gf = new double[bins(i)];
				//out.println(i + " : " + bins(i));
				bt.GuessFactor.put(""+i,gf);
			//	gf[(bins(i)-1)/2] = 1;
			}
			}
		}
		if ((bt.name == target.name)&&(isTeammate(bt.name)==false))	{
			bt = target;
		}
		//the next line gets the absolute bearing to the point where the bot is
		double absbearing_rad = (getHeadingRadians()+e.getBearingRadians())%(2*PI);
		
		bt.changehead = (normaliseBearing(e.getHeadingRadians() - bt.heading))/(getTime() - bt.ctime);
		bt.x = getX()+Math.sin(absbearing_rad)*e.getDistance(); //works out the x coordinate of where the target is
		bt.y = getY()+Math.cos(absbearing_rad)*e.getDistance(); //works out the y coordinate of where the target is
		bt.bearing = e.getBearingRadians();
		bt.heading = e.getHeadingRadians();
		bt.speed = e.getVelocity();
		bt.distance = e.getDistance();
		if (bt.distance < 200)	{
			movpt p = (movpt)MovePoints.get("agrav");
			p.weight*= 200/bt.distance;
			normMovement();
		}
		bt.live = true;
		if ((bt.energy > e.getEnergy())&&((bt.energy - e.getEnergy())<=3)) {
				//here is where we'll put info about bullets and enemy waves, when we figure that garbage out.
		}
		bt.energy = e.getEnergy();
		bt.maxescapeangle = 8/firePower*1.3;
		bt.latV = bt.speed * Math.sin( bt.bearing - absbearing_rad);
		bt.advV = bt.speed * Math.cos( bt.bearing - absbearing_rad);
		
		/**	Pattern Storage.
			We actually store patterns very strange. The gun is actually going to be
			a stistical symbolic pattern matcher. This means that we store blocks of
			patterns in an array. Every time we skip a tick tracking a bot, we start
			a new block. Every time the block becomes greater than a certain amount 
			we start a new block.
			
			Later, when we do our pattern searches, we will find occurances of the
			last few ticks in each pattern block, then find the behavior that follows
			that pattern in each block. Then we will pick the pattern that occurs in 
			the highest frequency. In this way, we should be able to accurately 
			predict our targets movement while learning very quickly. I'm not sure 
			what the effect will be on memory consumption yet, but so far, it seems
			as if the Pattern Buffer storage isn't slowing us down.
		**/
		int len = bt.PBLength;				//defines the length of any given buffer.
		if (bt.PBIndex == 0)	{
			for(int i=0; i<len; i++)	{
				bt.PatternBuffer[0]+=(char)(32);
			}
			bt.PBIndex = 1;
		}
		if (getTime()!=bt.ctime)	{
		if (bt.PatternBuffer[bt.PBIndex] == null) bt.PatternBuffer[bt.PBIndex] = "";
		//Check the buffer for this index. If it is too long or we've missed ticks, move to the next smallest index.
		if ((getTime() - bt.ctime > 1)||(getTime() - bt.ctime < 0)||(bt.PatternBuffer[bt.PBIndex].length()>len))	{
			for(int i=0; i<99; i++)	{	//cycle through each buffer index and find the smallest one.
				if (bt.PatternBuffer[i] == null)	{
					bt.PatternBuffer[i] = "";	//to prevent null pointer exceptions.
				}
				if (bt.PatternBuffer[i] == "")	{
					bt.PBIndex = i;				//if we run into a zero length buffer, pick it and end the loop.
					i = 99;
				}else if(bt.PatternBuffer[i].length()<=len)	{
					len = bt.PatternBuffer[i].length();
					bt.PBIndex = i;
				}
			}
			bt.PatternBuffer[bt.PBIndex] = "";		//clear out this buffer to start a new pattern block.
			bt.PBLength = Math.min(1000,bt.PBLength*2);
		}
		
		bt.PatternBuffer[bt.PBIndex] += "" + ((char)Math.round(bt.speed*4+32))+(char)Math.round(bt.changehead*18+32);
		}
		//out.println(bt.PatternBuffer[bt.PBIndex]);
		//end pattern storage.
		
		bt.ctime = getTime();				//game time at which this scan was produced
		bt.gunheat -= getGunCoolingRate()*(bt.ctime-getTime());
		
		//leader detection.
		if ((bt.energy > 150)&&(getTime()<10))	{
			//if a bot is found to be a leader, make it very tasty to our target selection.
			bt.hitRate = 1;
			bt.killed = 900;
		}
		
		doTargetSelect();
	}

		void doTargetSelect() {
		double rank = 0;
		bot bt;
		
		Enumeration e = Bots.elements();
	    //cycle through all the enemies.  If they are alive, Rank them, choose the highest rank.
		while (e.hasMoreElements()) {
    	    bt = (bot)e.nextElement();
			if ((bt.live)&&(isTeammate(bt.name)==false)) {
				if ((bt.hitRate < .1)||(bt.hitRate > 1))
				bt.hitRate = .1;
				if ((bt.hitMe < .1)||(bt.hitMe > 1))
				bt.hitMe = .1;
				if ((bt.killedMe < .1)||(bt.killedMe > 1))
				bt.killedMe = .1;
				if ((bt.killed < .1)||(bt.killed > 1))
				bt.killed = .1;
				if (((bt.hitRate*bt.hitMe*bt.killed*(bt.advV+9))/((Math.pow(bt.distance,2)*bt.energy*bt.speed*bt.killedMe)) > rank*1.3)||(target.name=="")||(target.live==false)) {
					rank = (bt.hitRate*bt.hitMe*bt.killed*(bt.advV+9))/((Math.pow(bt.distance,2)*bt.energy*bt.speed*bt.killedMe));
					target = bt;
				}
			}
	    }
		
		if (getOthers()>4)	{
		e = Bots.elements();
	    //cycle through all the enemies.  Find an angle slice that contains the most bots.
		double[] ang = new double[16];
		for(int i = 0; i<15; i++)	{
			ang[i] = 0;
		}
		while (e.hasMoreElements()) {
			bt = (bot)e.nextElement();
			if ((bt.live)&&(isTeammate(bt.name)==false))	{
				ang[(int)((Math.toDegrees(absbearing(getX(),getY(),bt.x,bt.y)))/22.5)] += 1;
				//out.println(absbearing(getX(),getY(),bt.x,bt.y));
			}
		}
		double bestAng = 0;
		double Angi = 0;
		for(int i = 0; i<8; i++)	{
			if (ang[i]>=bestAng)	{
				bestAng = ang[i];
				Angi = i;
			}
		}
		//if there are more than 3 bots in any given slice, choose the one closest to the middle.
		if (bestAng > 3)	{
			bestAng = 0;
			e = Bots.elements();
			Angi = normaliseBearing(Math.toRadians(Angi*45))+11;
			while (e.hasMoreElements()) {
				bt = (bot)e.nextElement();
				if((bt.bearing-Angi<bestAng)&&(bt.live))	{
					bestAng = bt.bearing-Angi;
					target = bt;
				}
			}
		}
		}
		

		//cycle through all the enemies, if one is particularly close or low on energy, target them.
		e = Bots.elements();
		while (e.hasMoreElements()) {
    	    bt = (bot)e.nextElement();
			if ((bt.live)&&(isTeammate(bt.name)==false)) {
				if ((bt.energy < 4)&&(target.energy*1.3<bt.energy))	target=bt;
				if (((bt.distance < 250)||(getTime()-target.ctime > 16))&&(bt.distance*1.3<target.distance)) target=bt;
				if ((bt.energy == 0)&&(bt.distance<200)) target = bt;
			}
		}
	}		


	void drawWaves() {
	
		wave wv;
    	Enumeration e = Waves.elements();
	    //cycle through all the waves.  If they are alive, draw them
		//out.println("drawing waves");
		while (e.hasMoreElements()) {
    	    wv = (wave)e.nextElement();
			if (wv.live) {
				wv.radius=((getTime()-wv.time+2)*wv.speed);
				drawCircle(wv.origin,wv.radius,Color.BLUE);
				if (getRange(getX(),getY(),wv.origin.x,wv.origin.y)<wv.radius) {
					wv.live=false;
					Waves.remove(wv);
				}
			}
	    }
		
	}

	void drawFBots() {
		bot bt;
		Enumeration e = Bots.elements();
		//out.println("drawing future bot locations");
		while (e.hasMoreElements()) {
			bt = (bot)e.nextElement();
			if (bt.live) {
				drawCircle(futurePosition(new Point2D.Double(bt.x,bt.y), bt.speed, bt.heading, 1),23,Color.RED);
			}
		}
		drawCircle(CircularTargeting(),23,Color.GREEN);
	}
	
	void drawBullets() {
		
	}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


		//Here we perform all of our movement styles at once, then apply them based on their weight.
		void doMovement() {
			movpt p;
			Point2D.Double point;
			double bestAng = normaliseBearing(Math.PI/2 - Math.atan2(getY() - target.y, getX() - target.x));
			double a;
			if (MovePoints.containsKey("agrav")||MovePoints.containsKey("randmove")||MovePoints.containsKey("cornermove"))	{
				//if there are movepoitns stored, then lets update them.
				p = (movpt)MovePoints.get("agrav");
				point = antiGravMove();
				p.x = point.x;
				p.y = point.y;
				a = PI/Math.abs(normaliseBearing(absbearing(getX(),getY(),p.x,p.y)-bestAng));
				if (a > PI/2)		p.weight *= .9;
				else if (a > PI/4)	p.weight *= .98;
				else if (a > PI/10)	p.weight *= 1.01;
				else				p.weight *= 1.1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				//p = (movpt)MovePoints.get("sweep");
				//point = doSweep();
				//p.x = point.x;
				//p.y = point.y;
				//drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				//p = (movpt)MovePoints.get("walls");
				//point = doWalls();
				//p.x = point.x;
				//p.y = point.y;
				//drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				p = (movpt)MovePoints.get("oscillate");
				point = doOscillate();
				p.x = point.x;
				p.y = point.y;
				a = PI/Math.abs(normaliseBearing(absbearing(getX(),getY(),p.x,p.y)-bestAng));
				if (a > PI/2)		p.weight *= .9;
				else if (a > PI/4)	p.weight *= .98;
				else if (a > PI/10)	p.weight *= 1.01;
				else				p.weight *= 1.1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				p = (movpt)MovePoints.get("randmove");
				point = doRandMove();
				p.x = point.x;
				p.y = point.y;
				a = PI/Math.abs(normaliseBearing(absbearing(getX(),getY(),p.x,p.y)-bestAng));
				if (a > PI/2)		p.weight *= .9;
				else if (a > PI/4)	p.weight *= .98;
				else if (a > PI/10)	p.weight *= 1.01;
				else				p.weight *= 1.1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				p = (movpt)MovePoints.get("cornermove");
				point = doCornerMove();
				p.x = point.x;
				p.y = point.y;
				a = PI/Math.abs(normaliseBearing(absbearing(getX(),getY(),p.x,p.y)-bestAng));
				if (a > PI/2)		p.weight *= .9;
				else if (a > PI/4)	p.weight *= .98;
				else if (a > PI/10)	p.weight *= 1.01;
				else				p.weight *= 1.1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				//normalize everything.
				normMovement();
			} else	{
				//if there is nothing stored in the movepoints, then initialize them to the following.
				p = new movpt();
				MovePoints.put("agrav",p);
				p.name = "agrav";
				point = antiGravMove();
				p.x = point.x;
				p.y = point.y;
				p.weight = 1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				//p = new movpt();
				//MovePoints.put("sweep",p);
				//p.name = "sweep";
				//point = doSweep();
				//p.x = point.x;
				//p.y = point.y;
				//p.weight = .25;
				//drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				//p = new movpt();
				//MovePoints.put("walls",p);
				//p.name = "walls";
			//	point = doWalls();
			//	p.x = point.x;
			//	p.y = point.y;
			//	p.weight = 400/Math.min(Fwidth,Fheight);	//Initialize this such that the smaller the ring, the 
			//	drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				p = new movpt();
				MovePoints.put("oscillate",p);
				p.name = "oscillate";
				point = doOscillate();
				p.x = point.x;
				p.y = point.y;
				p.weight = 1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				p = new movpt();
				MovePoints.put("randmove",p);
				p.name = "randmove";
				point = doRandMove();
				p.x = point.x;
				p.y = point.y;
				p.weight = 1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				p = new movpt();
				MovePoints.put("cornermove",p);
				p.name = "cornermove";
				point = doCornerMove();
				p.x = point.x;
				p.y = point.y;
				p.weight = 1;
				drawCircle(new Point2D.Double(p.x,p.y),23*p.weight,Color.YELLOW);
				
				//normalize everything.
				normMovement();
			}
		
		if ((getTime() < 50)&&(getOthers()>4))	{
			p = (movpt)MovePoints.get("cornermove");
			p.weight*= 1+getOthers()/20;
			normMovement();
		}
		
		//if the velocity of our bot is really slow, then penalize the current movement style.
		if (getVelocity() <2 )	{ stillcount++;
		}	else stillcount = 0;
		
		if ((getVelocity() <1.5 )&&(stillcount > 3))	{
			lossMovement();
			direction *=-1;
			stillcount = 0;
		}
		counter++;
		
		//Move toward the points based on weight.
		double xforce = 0;
	    double yforce = 0;
		double force,ang;
		Enumeration e = MovePoints.elements();
	    //cycle through all the points and move toward them based on weight.
		while (e.hasMoreElements()) {
    	    p = (movpt)e.nextElement();
			if (MovType != "")	{
				if (p.name == MovType)	p.weight = 100;
				else					p.weight = 0;
			}
			//Attracted to points based on their weight
	        force = p.weight;
	        //Find the bearing from the point to us
	        ang = normaliseBearing(Math.PI/2 - Math.atan2(getY() - p.y, getX() - p.x)); 
	        //Add the components of this force to the total force in their respective directions
	        xforce += Math.sin(ang) * force;
	        yforce += Math.cos(ang) * force;
			//Uncomment to show the vlues of each movepoint.
			//out.println(p.name + ": " + p.weight);
	    }
			//out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
			goTo(getX()-xforce,getY()-yforce);
		}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
			//A function that is called to reward the highest weighted movement style
		void gainMovement()	{
			movgaincount++;
			if ((canMove)&&(movgaincount<=5))	{
				movgaincount = movlosscount = 0;
				String name = "";
				double weight = 0;
				movpt p;
				Enumeration e = MovePoints.elements();
		    	//cycle through all the points and increase the most highly weighted one.
				while (e.hasMoreElements()) {
    	    		p = (movpt)e.nextElement();
					if (p.weight > weight)	{
						weight = p.weight;
						name = p.name;
					}
					//multiply each weight by a random amount between 1 and 2
					//This should keep things from getting stale.
					p.weight*= (Math.random()+1);
		    	}
				p = (movpt)MovePoints.get(name);
				p.weight*=1.5;
				normMovement();
			}
		}
		
		//A function that is called to punish the highest weighted movement style
		void lossMovement()	{
			movlosscount++;
			if ((canMove)&&(movlosscount>=3))	{
				movgaincount = movlosscount = 0;
				String name = "";
				double weight = 0;
				movpt p;
				Enumeration e = MovePoints.elements();
		    	//cycle through all the points and decrease the most highly weighted one.
				while (e.hasMoreElements()) {
    		    	p = (movpt)e.nextElement();
					if (p.weight > weight)	{
						weight = p.weight;
						name = p.name;
					}
					//multiply each weight by a random amount between 1 and 1.2
					//This should keep things from getting stale.
					p.weight*= (Math.random()+1);
		    	}
				p = (movpt)MovePoints.get(name);
				p.weight*=.5;
				normMovement();
			}
		}
	
		//A function that insures that all values add up to around 1 and also that no value is under .05
		void normMovement()	{
			double weight = 0;
			movpt p;
			Enumeration e = MovePoints.elements();
	    	//cycle through all the points and add up their weights.
			while (e.hasMoreElements()) {
    	    	p = (movpt)e.nextElement();
				weight += p.weight;
	    	}
			e = MovePoints.elements();
	    	//cycle through all the points and reduce them such that they add up to about 1.
			//Values lower than .05 are stored as .05 to prevent them from moving so close to 0 as to become 0.
			while (e.hasMoreElements()) {
    	    	p = (movpt)e.nextElement();
				p.weight *= 1/weight;
				if (p.weight < .05) p.weight = .05;
	    	}
		}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		//Antigravity movement
		Point2D.Double antiGravMove() {
		energy = getEnergy();
   		double xforce = 0;
	    double yforce = 0;
	    double force;
	    double ang;
	    GravPoint p;
		bot bt;
    	Enumeration e = Bots.elements();
	    //cycle through all the enemies.  If they are alive, they are repulsive.  Calculate the force on us
		while (e.hasMoreElements()) {
    	    bt = (bot)e.nextElement();
			if (bt.live) {
				//Repelled by bots based on their energy
				p = new GravPoint(bt.x,bt.y, -5*bt.energy);
		        force = p.power/Math.pow(getRange(getX(),getY(),p.x,p.y),2);
				force *= bt.killedMe + .5;
		        //Find the bearing from the point to us
		        ang = normaliseBearing(Math.PI/2 - Math.atan2(getY() - p.y, getX() - p.x)); 
		        //Add the components of this force to the total force in their respective directions
		        xforce += Math.sin(ang) * force;
		        yforce += Math.cos(ang) * force;
			}
	    }
		
		//Center Avoidance
		p = new GravPoint(
		Fwidth/2,Fheight/2
		, -1*(Math.sin(getTime()/100)*2+2)*(getOthers()/4));
		force = p.power/Math.pow(getRange(getX(),getY(),p.x,p.y),2);
		//Find the bearing from the point to us
		ang = normaliseBearing(Math.PI/2 - Math.atan2(getY() - p.y, getX() - p.x)); 
		//Add the components of this force to the total force in their respective directions
		xforce += Math.sin(ang) * force;
		yforce += Math.cos(ang) * force;
		
	
		//corner avoidance.
		p = new GravPoint(0,0, -5);
		//Find the closest corner
		if (getRange(p.x,p.y,getX(),getY())>getRange(Fwidth,p.y,getX(),getY()))	p.x = Fwidth;
		if (getRange(p.x,p.y,getX(),getY())>getRange(p.x,Fheight,getX(),getY()))	p.y = Fheight;
		force = p.power/Math.pow(getRange(getX(),getY(),p.x,p.y),2);
		//Find the bearing from the point to us
		ang = normaliseBearing(Math.PI/2 - Math.atan2(getY() - p.y, getX() - p.x)); 
		//Add the components of this force to the total force in their respective directions
		xforce += Math.sin(ang) * force;
		yforce += Math.cos(ang) * force;
		
		
	    /**The following four lines add wall avoidance.  They will only affect us if the bot is close 
	    to the walls due to the force from the walls decreasing at a power 3.**/
	    xforce += 5000/Math.pow(getRange(getX(), getY(), getBattleFieldWidth(), getY()), 3)*(Math.sin(getTime()/10)+1);
	    xforce -= 5000/Math.pow(getRange(getX(), getY(), 0, getY()), 3)*(Math.sin(getTime()/10)+1);
	    yforce += 5000/Math.pow(getRange(getX(), getY(), getX(), getBattleFieldHeight()), 3)*(Math.sin(getTime()/10)+1);
	    yforce -= 5000/Math.pow(getRange(getX(), getY(), getX(), 0), 3)*(Math.sin(getTime()/10)+1);
	    
	    //Move in the direction of our resolved force.
		double x = getX()-xforce;
		double y = getY()-yforce;
		
//		p = new GravPoint(getX(),getY(), -5);
//		force = p.power/Math.pow(getRange(x,y,p.x,p.y),2);
//		//Find the bearing from the point to us
//		ang = normaliseBearing(Math.PI/2 - Math.atan2(y - p.y, x - p.x)); 
//		//Add the components of this force to the total force in their respective directions
//		x -= Math.sin(ang) * force;
//		y -= Math.cos(ang) * force;
		
		
		return BoundCheck(x,y,"agrav");
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//sweep the battlefield for other bots.
	Point2D.Double doSweep() {
		double x=Fwidth/2,y=Fheight/2;
		double distance = Math.min(Math.min(Fwidth/2,Fheight/2),Math.min(Fwidth/3,Fheight/3)*(Math.sin((double)getTime()/Math.min(Fwidth/100,Fheight/100))/2+1.1))-50;
		double angle = normaliseBearing(Math.PI/2 - Math.atan2(getY() - Fheight/2, getX() - Fwidth/2))+.2;//+(Math.random()*direction/2+(.2*direction));
		x += distance*Math.sin(angle);
		y += distance*Math.cos(angle);
		return BoundCheck(x,y,"sweep");
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//run allong the walls and round the corners. This helps stay out of the way.
	Point2D.Double doWalls() {
		double x=Fwidth/2,y=Fheight/2;
		double distance = getRange(100,100,Fwidth/2,Fheight/2);
		double angle = normaliseBearing(Math.PI/2 - Math.atan2(getY() - Fheight/2, getX() - Fwidth/2))+(Math.random()*direction/2+(.1*direction));
		x += distance*Math.sin(angle);
		y += distance*Math.cos(angle);
		return BoundCheck(x,y,"walls");
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	Point2D.Double doOscillate()	{
		double x=target.x,y=target.y;
		double distance = ((target.energy/energy*250) > target.distance) ? target.distance-1 : target.distance +1;
		//the angle we're moving is based off of the target's health
		//we should dodge bullets indirectly.
		if (randcount <= 0)	{
			oscOffset = Math.sin(randX*randY);
		}
		double angle = normaliseBearing(Math.PI/2 - Math.atan2(getY() - target.y, getX() - target.x))+oscOffset;
		x += distance*Math.sin(angle);
		y += distance*Math.cos(angle);
		return BoundCheck(x,y,"oscillate");
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	Point2D.Double doRandMove()	{
		if (randcount <= 0)	{
			randX = Math.random()*Fwidth;
			randY = Math.random()*Fheight;
			randcount = Math.random()*32+8;
		} else randcount -= Math.random()*1.5;
		return BoundCheck(randX,randY,"randmove");
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	Point2D.Double doCornerMove()	{
		double distance = Math.min(400,Math.max(75,((Fwidth+Fheight)/2)/8));
		double x=distance,y=distance;
		if (getRange(x,y,getX(),getY())>getRange(Fwidth-distance,y,getX(),getY()))	x = Fwidth-distance;
		if (getRange(x,y,getX(),getY())>getRange(x,Fheight-distance,getX(),getY()))	y = Fheight-distance;
		if (getRange(x,y,getX(),getY())>getRange(Fwidth-distance,y,getX(),getY()))	x = Fwidth-distance;
		drawCircle(new Point2D.Double(x,y),distance,Color.green);
		double angle = PI*2*Math.random();
		if ((getRange(getX(),getY(),cornerX,cornerY)<Math.random()*(distance/2))||(cornerX==0)||(angle <PI*.1)||(angle>PI*1.9)||(randcount<=0))	{
			distance -= Math.random()*(distance/3+30);
			x += distance*Math.sin(angle);
			y += distance*Math.cos(angle);
			cornerX = x;
			cornerY = y;
		}	else	{
			x = cornerX;
			y = cornerY;
		}
		return BoundCheck(x,y,"cornermove");
	}
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	Point2D.Double BoundCheck(double x, double y, String from)	{
	double dist = 40;
		//out.println("x: " + x + " y: " + y);

		//Just to catch irregular numbers that are way out of bounds.
		//if it is out of bounds, go to the center of the field.
		//This is mainly to keep us from ramming into the wall when an exception is thrown.
		if ((x == Double.NaN)||(y == Double.NaN)||(x == Double.POSITIVE_INFINITY)||(y == Double.POSITIVE_INFINITY)||(x == Double.NEGATIVE_INFINITY)||(y == Double.NEGATIVE_INFINITY)) {
			x = getBattleFieldWidth()/2;
			y = getBattleFieldHeight()/2;
			movpt p;
				Point2D.Double point;
				if ((MovePoints.containsKey(from))&&(from != "goTo"))	{
					p = (movpt)MovePoints.get(from);
					p.weight=.05;
				}	else	lossMovement();
				normMovement();
		}
		
		if ((x < dist)||(y < dist)||(x > Fwidth-dist)||(y > Fheight-dist)) {
			if (x < dist)
			x = dist;
			if (y < dist)
			y = dist;
			if (x > Fwidth-dist)
			x = Fwidth-dist;
			if (y > Fheight-dist)
			y = Fheight-dist;
		}
		return new Point2D.Double(x,y);	
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**Move towards an x and y coordinate**/
	void goTo(double x, double y) {
		double dist = 20;
		Point2D.Double pos = BoundCheck(x,y,"goTo");
		//if we haven't seen our target in a while
		if (getTime()-target.ctime > 16)	{
			if ((target.live)&&(getTime()-target.ctime < 30)) {	//if our target is still alive, move towards it.
				pos.x = target.x;
				pos.y = target.y;
			} else	{			//if not, engage search pattern.
				pos = doSweep();
			}
		}
		
		x = pos.x;
		y = pos.y;
		double angle = Math.toDegrees(absbearing(getX(),getY(),x,y));
		if (canMove)	{
			double r = turnTo(angle);
			setAhead(dist*r);
			drawCircle(new Point2D.Double(x,y),23,Color.WHITE);
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**Turns the shortest angle possible to come to a heading, then returns the direction the
	the bot needs to move in.**/
	int turnTo(double angle) {
	    double ang;
    	int dir = 1;
	    ang = normaliseBearing(getHeading() - angle);
	    if (ang > 90) {
	        ang -= 180;
	        dir = -1;
	    }	else if (ang < -90) {
	        ang += 180;
	        dir = -1;
	    }
		setMaxVelocity(Math.random()*2+6);
	    setTurnLeft(ang);
	    return dir;
	}











	//Just a bunch of utilities below this:
	
	//if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
	double normaliseBearing(double ang) {
		if (ang > PI)
			ang -= 2*PI;
		if (ang < -PI)
			ang += 2*PI;
		return ang;
	}
	
	//if a heading is not within the 0 to 2pi range, alters it to provide the shortest angle
	double normaliseHeading(double ang) {
		if (ang > 2*PI)
			ang -= 2*PI;
		if (ang < 0)
			ang += 2*PI;
		return ang;
	}
	
	//returns the distance between two x,y coordinates
	public double getRange( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = Math.sqrt( xo*xo + yo*yo );
		return h;	
	}
	
	//gets the absolute bearing between to x,y coordinates
	public double absbearing( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = getRange( x1,y1, x2,y2 );
		if( xo > 0 && yo > 0 )
		{
			return Math.asin( xo / h );
		}
		if( xo > 0 && yo < 0 )
		{
			return Math.PI - Math.asin( xo / h );
		}
		if( xo < 0 && yo < 0 )
		{
			return Math.PI + Math.asin( -xo / h );
		}
		if( xo < 0 && yo > 0 )
		{
			return 2.0*Math.PI - Math.asin( -xo / h );
		}
		return 0;
	}
	
	
	
	//Events below:
	public void onRobotDeath(RobotDeathEvent e) {
		bot bt;
		if (Bots.containsKey(e.getName())) {
			bt = (bot)Bots.get(e.getName());
			if (bt.live == true)	{
				bt.live = false;
				bt.killed+=getOthers();
				if (bt.killedMe > 1)bt.killedMe --;
			}
		}
	}	

	public void onBulletHit(BulletHitEvent e) {
		//bot bt;
		//if (Bots.containsKey(e.getName())) {
		//	bt = (bot)Bots.get(e.getName());
		//	bt.energy = e.getEnergy();
		//}
		if (e.getName() == target.name) {
			target.hitRate = ((target.hitRate*(target.shotAt-1))+1)/target.shotAt;
		}
		lasthitme = e.getName();
		gainMovement();
	}

 	public void onHitByBullet(HitByBulletEvent e) {
		randcount = 0;
     	bot bt;
		if (Bots.containsKey(e.getName())) {
			bt = (bot)Bots.get(e.getName());
			bt.hitMe = (bt.hitMe*(bt.shot-1)+1)/bt.shot;
			lasthitme = e.getName();
		}
		lossMovement();
   	}

	public void onHitWall(HitWallEvent event) {
		//out.println("Ouch, I hit a wall bearing " + event.getBearing() + " degrees.");
		//goTo(getBattleFieldWidth()/2,getBattleFieldHeight()/2);
		lossMovement();
		randcount = 0;
	}

	public void onHitRobot(HitRobotEvent e) {
		//out.println("Ouch, I hit a wall bearing " + event.getBearing() + " degrees.");
		//goTo(getBattleFieldWidth()/2,getBattleFieldHeight()/2);
		if (e.getEnergy() < 10) gainMovement();
		else lossMovement();
		
	//	movpt p;
	//			Point2D.Double point;
	//			if (MovePoints.containsKey("agrav"))	{
	//				p = (movpt)MovePoints.get("agrav");
	//				p.weight*=1.1;
	//			}
	//			normMovement();
	
	randcount = 0;
     	bot bt;
		if (Bots.containsKey(e.getName())) {
			bt = (bot)Bots.get(e.getName());
			bt.shot++;
			bt.hitMe = (bt.hitMe*(bt.shot-1)+1)/bt.shot;
		}
		lossMovement();
	}
	
	public void onWin(WinEvent e)	{
		hitStats();
	}
	
	public void onDeath(DeathEvent e)	{
		//when I die, log who killed me.
		bot bt = (bot)Bots.get(lasthitme);
		bt.killedMe ++;
		
		hitStats();
	}

	void hitStats()	{
		double rating;
		boolean write;
		bot bt;
		Enumeration f = Bots.elements();
	    //cycle through all the enemies.
		while (f.hasMoreElements()) {
 	  	    bt = (bot)f.nextElement();
		//	out.println(bt.name + " Hite Rate: " + ((int)(bt.hitRate*100)) + "% hitme: " + ((int)(bt.hitMe*100)) + "%");
			rating = 0;
			write = true;
			bt.rounds++;
		if (bt.rounds < 35)	{
		//if (true)	{
			rating = 0;
			for (int i = 1; i < 10; i++)	{
				rating+=bt.Hang[i];
			}
				rating = rating/9;
			if (rating > .7) write = false;
			rating = 0;
			for (int i = 1; i < 9; i++)	{
				rating+=bt.Pang[i];
			}
				rating = rating/9;
			if (rating > .7) write = false;
			rating = 0;
			for (int i = 1; i < 9; i++)	{
				rating+=bt.Gang[i];
			}
				rating = rating/9;
			if (rating > .7) write = false;
			rating = 0;
			for (int i = 1; i < 10; i++)	{
				rating+=bt.Cang[i];
			}
				rating = rating/9;
			if (rating > .7) write = false;
		}
			if (write) writeObject(bt, bt.name);
			//@here
			CheckFileQuota();
	    }
	}
	
	void CheckFileQuota()	{
		long quotaAvailable = getDataQuotaAvailable();
    while (quotaAvailable < 2500) {
        File[] robotFiles = getDataDirectory().listFiles();

        int randFileIndex =
            Math.min((int)(Math.random() * robotFiles.length),
            robotFiles.length - 1);
        quotaAvailable += robotFiles[randFileIndex].length();
        robotFiles[randFileIndex].delete();
    }
	}

//below are Kawigi's compressed read/write file objects/////////////////////////////////////////////////////////////////////////
public Object readObject(String filename) {
	try
	{
		ZipInputStream zipin = new ZipInputStream(new
		FileInputStream(getDataFile(filename + ".zip")));
		zipin.getNextEntry();
		ObjectInputStream in = new ObjectInputStream(zipin);
		Object obj = in.readObject();
		in.close();
		return obj;
	}
	catch (FileNotFoundException e)
	{
		System.out.println("File not found!");
	}
	catch (IOException e)
	{
		System.out.println("I/O Exception");
	}
	catch (ClassNotFoundException e)
	{
		System.out.println("Class not found! :-(");
		e.printStackTrace();
	}
	return null;    //could not get the object
}
 
public void writeObject(Serializable obj, String filename)
{
	try
	{
		ZipOutputStream zipout = new ZipOutputStream(new RobocodeFileOutputStream(getDataFile(filename + ".zip")));
		zipout.putNextEntry(new ZipEntry(filename));
		ObjectOutputStream fout = new ObjectOutputStream(zipout);
		fout.writeObject(obj);
		fout.flush();
		zipout.closeEntry();
		fout.close();
	}
	catch (IOException e)
	{
		System.out.println("Error writing Object:" + e);
	}
}////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}///end of robot class thingy.

class movpt	{
	//This stores the data on each movement point we specify.
	String name;			//the name of the movement style.
	double x,y;				//the cordinates where the point resides.
	double weight;			//how inclined we are to move toward this point.
}

class bot implements java.io.Serializable {
	//This bot object is stored in the hashtable for each bot, it just keeps track of certain variables
	//this way they're accessable at all times so the bot can make decisions based on the big picture.
	String name;			//Bot's name
	public double bearing,heading,speed,x,y,energy,distance,changehead,gunheat,maxescapeangle,latV,advV;
	public long ctime; 		//game time that the scan was produced
	public boolean live; 	//is the enemy alive?
	public double shotAt,hitRate,shot,hitMe,killedMe,killed;
	public int PBIndex;					//The current Pattern Buffer Index we're writing to.
	public int PBLength;				//The current max length of each PB block.
	public int rounds;					//the number of rounds we've fought this enemy.
	public String[] PatternBuffer;		/**This is where all the pattern info is stored.
										It is an array because we store the patterns in chunks
										based on the fact that our radar doesn't constantly lock
										in a melee situation.
										**/
	public Hashtable GuessFactor;		//the guess factors, factored by distance.
	public double[] Hang, Pang, Cang, Rang, Gang;	//the accuracy of each targeting method, factored by distance.
}

class bullet {
	//This bullet object is stored in the bullets hashtable, it just keeps track of all the bullets
	//whose direction we know of. We treat them as points in space that travel in a straight line.
	//We transmit the exact trajectories of our own bullets to our team mates and guess that the enemy
	//is most likely to fire in circular, linear, and head-on targeting.
	Point2D.Double origin;			//the point the bullet originated from
	double time, heading, speed, power;
	boolean live;
}

class wave {
	//This Wave class simply stores the wave information in the Waves Hashtable.
	//Waves are essentially all the possible locations of an enemy bullet.
	//Our movement may depend of being able to move toward certain places on the wave.
	Point2D.Double origin;			//the origin of the wave.
	double time, radius, speed, power;
	boolean live;
}

class Mwave {
	//This Wave class simply stores the wave information in the MyWaves Hashtable.
	Point2D.Double origin;			//the origin of the wave.
	String target;					//who we where shooting at, because I know we can change targets before a bullet hits them.
	double radius, speed, power, maxang, zero, Pang, Cang, Rang, Gang;
	long time;
	int seg, dir;
	boolean live;
}

/**Holds the x, y, and strength info of a gravity point**/
class GravPoint {
    public double x,y,power;
    public GravPoint(double pX,double pY,double pPower) {
        x = pX;
        y = pY;
        power = pPower;
    }
}