package sch;

/**
 * Store all information about a gravity point. 
 */
 
public class GravPoint implements Constants {
	
	private double x;
    private double y;
    private double power;
    private double type;
    
    /**
     * Create a new gravity point
     * @param pX		X position
     * @param py		Y position
     * @param pPower	Power
     */
    public GravPoint(double pX,double pY,double pPower, double pType) {
        x = pX;
        y = pY;
        power = pPower;
        type=pType;
    }
    
    /**
     * Return the X postion of the gravity point
     * @return		X position
     */
    public double getX() {return x;}

    /**
     * Return the Y postion of the gravity point
     * @return		Y position
     */
    public double getY() {return y;}
 
     /**
      * Return the power of the gravity point
      * @return		power
      */   
    public double getPower() {return power;}
    
     /**
      * Return the type of the gravity point
      * @return		type of gravity point
      */   
    public double getType() {return type;}

     /**
      * Return a string representing the gravity point
      * @return		descr string
      */     
    public String toString() {
    return ("pos: ("+x+", "+y+"), p: "+ power + ", type: "+type);
    }
    
}