package ejb;
import robocode.*;
import static robocode.util.Utils.normalRelativeAngle;
import java.awt.Color;
import java.awt.geom.*;
import java.awt.Graphics2D;

/** Melee MicroBot that uses antigravity movement and linear targetting
* By: ZeroKelvin
*/
public class Polaris extends AdvancedRobot
{

	static double forceX, forceY;
	static double sumX, sumY;
	static int count;
	static String targetName;
	static double targetDistance;

	public void run() {
		setColors(Color.white, new Color(255,255,240), Color.yellow);
		setAdjustGunForRobotTurn(true);
		forceX = forceY = sumX = sumY = 0;
		count = 0;
		targetDistance = 1E20;
		
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		
		while(true) {			
			execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {		
		double absBearing = e.getBearingRadians() + getHeadingRadians();
		forceX += Math.sin(absBearing) / e.getDistance();
		forceY += Math.cos(absBearing) / e.getDistance();
		sumX += e.getDistance()*Math.sin(absBearing) + getX();
		sumY += e.getDistance()*Math.cos(absBearing) + getX();
		count++;
		
		if (e.getDistance() < targetDistance || e.getName().equals(targetName)) {
			targetDistance = e.getDistance();
			targetName = e.getName();
			setTurnRightRadians( normalRelativeAngle(Math.PI/2+e.getBearingRadians()) );
			
			double bulletPower = getEnergy()*15/e.getDistance();
			if (getGunTurnRemaining() == 0)
				setFire(bulletPower);
				
			if (getGunHeat() < 1)
				setTurnRadarLeft(getRadarTurnRemaining());
			
			if (bulletPower > 3.0) bulletPower = 3.0;
			else if (bulletPower < 0.1) bulletPower = 0.1;
			double aim = Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians()-absBearing) / Rules.getBulletSpeed(bulletPower));
			setTurnGunRightRadians( normalRelativeAngle(absBearing-getGunHeadingRadians() + aim ) );
		}
	
		execute();
	}

	public void execute() {		
		//center avoidance
		/*forceX += 1.0 / getX()-getBattleFieldWidth()/2;
		forceY += 1.0 / getY()-getBattleFieldHeight()/2;*/
		
		//avoid average point of robots
		forceX += 10000/(sumX/count - getX());
		forceY += 10000/(sumY/count - getY());
		
		Graphics2D g = getGraphics();
		g.setColor(Color.red);
		g.fill(new Ellipse2D.Double(sumX/count-10, sumY/count-10, 20, 20));
		
		//wall avoidance
		//forceX -= 5.0 / (getBattleFieldWidth()-getX()) - 10.0/getX();
		//forceY -= 5.0 / (getBattleFieldHeight()-getY()) - 10.0/getY();
		if (getX() < 180)
			forceX = -10000/getX();
		if (getBattleFieldWidth()-getX() < 180)
			forceX = 10000/(getBattleFieldWidth()-getX());
		if (getY() < 180)
			forceY = -10000/getY();
		if (getBattleFieldHeight()-getY() < 180)
			forceY = 10000/(getBattleFieldHeight()-getY());
		
		//v1.6.1.4 compatibility
		//setDebugProperty("forceY", Double.toString(forceY));
		//setDebugProperty("forceX", Double.toString(forceX));
		
		if (getDistanceRemaining() == 0) {
			double theta = Math.atan2(forceX, forceY);
			if (Math.abs(normalRelativeAngle(theta-getHeadingRadians())) < Math.PI/2)
				setBack(Math.random()*180+50);
			else
				setAhead(Math.random()*180+50);
			forceX = forceY = 0;
	}
	
		super.execute();
	}

	public void onRobotDeath(RobotDeathEvent e) {
		if (e.getName().equals(targetName))
			targetDistance = 1E20;	
	}

	public void onHitByBullet(HitByBulletEvent e) {
		setAhead(0);	
	}

}
