package ags.muse.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;

public class StaticSaver {
    private static File dataDirectory;
    
    public static void init(AdvancedRobot bot) {
        dataDirectory = bot.getDataDirectory();
        System.out.println("Bot data directory:");
        System.out.print("\t");
        System.out.println(dataDirectory.getAbsolutePath());
    }
    
    public static RobocodeFileOutputStream getOutputFile(String filename, boolean append) throws IOException {
        if (dataDirectory == null)
            throw new java.lang.IllegalStateException();
        File file = new File(dataDirectory, filename);
        RobocodeFileOutputStream fileWriter = new RobocodeFileOutputStream(file.getPath(), append);
        return fileWriter;
    }
    
    public static FileInputStream getInputFile(String filename) throws IOException {
        if (dataDirectory == null)
            throw new java.lang.IllegalStateException();
        File file = new File(dataDirectory, filename);
        return new FileInputStream(file);
    }
}
