package jeremyreeder;
import robocode.*;
import java.awt.Color;
import java.util.*;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/RateControlRobot.html

/**
 * Bully - a ramming robot by Jeremy Reeder, with stationary targeting
 */
public class Bully extends RateControlRobot {
	/**
	 * run: default behavior
	 */
	public void run() {
		setColors(Color.blue, Color.white, Color.blue); // body,gun,radar
		setTurnRate(Rules.MAX_TURN_RATE);
		setRadarRotationRate(Rules.RADAR_TURN_RATE);
		while (true) {
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		setRadarRotationRate(-getRadarRotationRate());
		if (java.lang.Math.abs(e.getBearing()) > 45) {
			setVelocityRate(0);
		} else if (java.lang.Math.abs(e.getBearing()) < 10) {
			setVelocityRate(Rules.MAX_VELOCITY);
			setFire(Rules.MAX_BULLET_POWER);
		}
		setTurnRate(e.getBearing());
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
	}
}
	
