package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
/**
 * SillyOscillatingMovement - controls movement in a complex oscillating fashion proposed by Albert.  Pattern-match THIS, MogBot!
 */
public class SillyOscillatingMovement extends MovementStrategy implements java.io.Serializable
{
	private double goaldistance;
	private int directionticks;
	private transient long lastHitTime, changeDirectionTime;
	private transient int quickhits, currentDirection;
	private transient boolean back;
	private transient double lastbulletv;
	
	public SillyOscillatingMovement(AdvancedRobot robot, TargetSelector targetter)
	{
		super(robot, targetter);
		currentDirection = 1;
		goaldistance = 300;
		back = false;
		directionticks = 30;
		lastbulletv = 11;
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof HitByBulletEvent)
		{
			if (e.getTime() - lastHitTime < 35)
				directionticks += 5;
			else
				quickhits = 0;
			quickhits++;
			lastHitTime = e.getTime();
			lastbulletv = ((HitByBulletEvent)e).getVelocity();
		}
		if (e instanceof HitWallEvent)
		{
			directionticks -= 5;
			if (directionticks <= 10)
				directionticks = 10;
			currentDirection = -currentDirection;
			changeDirectionTime = robot.getTime() + directionticks;
		}
	}
	
	public void setAction()
	{
		EnemyState closest = getClosestEnemy();
		if (closest == null)
			return;
		if (robot.getTime() > changeDirectionTime)
		{
			currentDirection = -currentDirection;
			changeDirectionTime = (long)(robot.getTime() + closest.getDistance(robot.getX(), robot.getY())/lastbulletv-5);
		}
		if (getTarget() != null)
			closest = getTarget();
		double distance = closest.getDistance(robot.getX(), robot.getY());
		double absoluteangle = closest.getAbsoluteBearing(robot.getX(), robot.getY());
		boolean back2 = (100*(Math.sin(robot.getTime()/17)+Math.cos(robot.getTime()/29))) < 0;
		double tempdirection = back?-1:1;
		if (Math.abs(distance-goaldistance) < 50)	//move orthogonal to the target robot
			turn(currentDirection*Math.PI/2 - absoluteangle+robot.getHeadingRadians());
		else if (distance > goaldistance)		//spiral slightly inward
			turn(currentDirection*Math.PI/3 - absoluteangle+robot.getHeadingRadians());
		else		//spiral slightly away
			turn(currentDirection*2*Math.PI/3 - absoluteangle + robot.getHeadingRadians());
		if (back != back2)
			robot.setBack(40);
		else
			robot.setAhead(40);
		back = false;
	}
	
	public void turn(double angle)
	{
		while (angle < -Math.PI)
			angle += Math.PI*2;
		while (angle > Math.PI)
			angle -= Math.PI*2;
		if (angle < -Math.PI/2)
		{
			back = true;
			angle += Math.PI;
		}
		else if (angle > Math.PI/2)
		{
			back = true;
			angle -= Math.PI;
		}
		if (angle > 0)
			robot.setTurnLeftRadians(angle);
		else
			robot.setTurnRightRadians(-angle);
	}
}
