package kawigi.spare.util;
import robocode.*;
import java.util.Vector;
/**
 * EnemyManager - tracks positions and information on all enemies
 */
public class EnemyManager
{
	private AdvancedRobot me;
	EnemyState[] enemies;
	EnemyState meState;
	Vector dbullets;
	
	public EnemyManager(int numEnemies, AdvancedRobot robot)
	{
		me = robot;
		meState = new EnemyState("Spaces for an invalid robot name that's too long anyways");
		enemies = new EnemyState[numEnemies];
		dbullets = new Vector();
	}
	
	public DefensiveVirtualBullet[] getNewBullets()
	{
		DefensiveVirtualBullet[] ret = new DefensiveVirtualBullet[dbullets.size()];
		dbullets.toArray(ret);
		dbullets.removeAllElements();
		return ret;
	}
	
	public void updateMe()
	{
		meState.setState(me.getX(), me.getY(), me.getVelocity(), me.getHeadingRadians(), me.getEnergy(), me.getTime());
	}
	
	public EnemyState getMe()
	{
		return meState;
	}
	
	public void resetRobot(AdvancedRobot robot)
	{
		me = robot;
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		double enemyBearing = me.getHeadingRadians()+e.getBearingRadians();
		double opponentX = me.getX() + e.getDistance() * Math.sin(enemyBearing);
		double opponentY = me.getY() + e.getDistance() * Math.cos(enemyBearing);
		setState(e.getName(), opponentX, opponentY, e.getVelocity(), e.getHeadingRadians(), e.getEnergy(), e.getTime());
	}
	
	private void setState(String name, double x, double y, double v, double heading, double energy, long time)
	{
		for (int i=0; i<enemies.length; i++)
		{
			if (enemies[i] == null)
			{
				enemies[i] = new EnemyState(name);
				enemies[i].setState(x, y, v, heading, energy, time);
				break;
			}
			else if (enemies[i].getName().equals(name))
			{
				double denergy = enemies[i].getEnergy()-energy;
				if (denergy >= .1 && denergy <= 3)
				{
					DefensiveVirtualBullet[] newbullets = DefensiveVirtualBullet.createBullets(x, y, denergy, meState, time);
					for (int j=0; j<newbullets.length; j++)
						dbullets.addElement(newbullets[j]);
				}
				enemies[i].setState(x, y, v, heading, energy, time);
				break;
			}
		}
	}
	
	public void kill(String name)
	{
		for (int i=0; i<enemies.length; i++)
			if (enemies[i] != null && enemies[i].getName().equals(name))
			{
				enemies[i].kill();
				return;
			}
	}
	
	public EnemyState getClosestEnemy()
	{
		EnemyState closest = null;
		for (int i=0; i< enemies.length; i++)
		{
			if (enemies[i] == null || enemies[i].isDead() || enemies[i].getTimeElapsed(me.getTime()) > 20)
				continue;
			else if (closest == null)
				closest = enemies[i];
			else if (closest.isDead())
				closest = enemies[i];
			else if (closest.getTimeElapsed(me.getTime()) > 20)
				closest = enemies[i];
			else if (closest.getDistance(me.getX(), me.getY()) > enemies[i].getDistance(me.getX(), me.getY()))
				closest = enemies[i];
		}
		return closest;
	}
	
	public EnemyState getEnemy(String name)
	{
		for (int i=0; i< enemies.length; i++)
		{
			if (enemies[i] == null)
				continue;
			else if (enemies[i].getTimeElapsed(me.getTime()) > 20)
				continue;
			else if (enemies[i].isDead())
				continue;
			else if (enemies[i].getName().equals(name))
				return enemies[i];
		}
		return null;
	}
	
	public int indexOf(EnemyState enemy)
	{
		if (enemy == null)
			return -1;
		for (int i=0; i<enemies.length; i++)
			if (enemies[i] == null)
				return -1;
			else if (enemies[i].getName().equals(enemy.getName()))
				return i;
		return -1;
	}
	
	public int indexOf(String enemyname)
	{
		for (int i=0; i<enemies.length; i++)
			if (enemies[i] == null)
				return -1;
			else if (enemies[i].getName().equals(enemyname))
				return i;
		return -1;
	}
	
	public EnemyState getEnemyAt(int index)
	{
		if (index >= enemies.length)
			return null;
		else
			return enemies[index];
	}
	
	public int countEnemies()
	{
		return enemies.length;
	}
}
