 package shinh;

import robocode.*;

/// for one
public class MoveAntiGrav3 extends Move implements Const {
	private EnemyMgr emgr_;

	private int changeTurn_ = 0;

	private int aim_ = 0;
	private int aimTurn_ = 0;
	private int sameTurn_ = 0;

	public void use() {
		changeTurn_ = 0;
	}

	public String name() {
		return "antigrav3";
	}

	public MoveAntiGrav3() {
		init();
	}

	public void init() {
		ent = Entangled.me;
		emgr_ = ent.emgr;
	}

	public void update() {
		if (ent.nearEdge(50)) {
			changeTurn_ = 0;
		}

		changeTurn_--;
		if (changeTurn_ > 0) {
			return;
		}

		changeTurn_ = 3 + (int)(Math.random() * 4);

		double ex = ent.getX();
		double ey = ent.getY();

		double forceX = 0;
		double forceY = 0;

		double x, y, r, rn;

		if (emgr_.size() > 0) {
			Enemy enemy = emgr_.get(0);
			rn =
				3.0 / Math.pow(enemy.distance, GRAV_ENEMY_POW);

			x = ex - enemy.x;
			y = ey - enemy.y;
			forceX += x * rn;
			forceY += y * rn;

			if (aimTurn_ == 0) {
				double rr = Util.getRoboRadian(enemy.radian + Const.PI_2);
				double dr = distanceRateToWall(ent.getX(), ent.getY(), rr);
				double rl = Util.getRoboRadian(enemy.radian - Const.PI_2);
				double dl = distanceRateToWall(ent.getX(), ent.getY(), rl);
				int prevAim = aim_;
				aim_ = (dr > dl) ? 1 : -1;
				if (aim_ != prevAim) sameTurn_ = 0;
				aimTurn_ = 2;
			}
			else {
				aimTurn_--;
			}
			sameTurn_++;

			if (sameTurn_ > 10) {
				sameTurn_ = 0;
				aimTurn_ = 3;
				aim_ = -aim_;
			}

			r = enemy.radian + aim_ * Const.PI_2;
			forceX += 0.03 * Math.sin(r);
			forceY += 0.03 * Math.cos(r);
		}

		for (int i = 0; i < ent.bmgr.size(); i++) {
			EnemyBullet eb = ent.bmgr.getBullet(i);
			rn = 1 /
				Math.pow(Util.distance(ex, ey,
									   eb.x, eb.y), GRAV_BULLET_POW);
			x = ex - eb.x;
			y = ey - eb.y;
			forceX += x * rn;
			forceY += y * rn;
		}

		int afterHitTurn = (int)(ent.getTime() - ent.lastHitTurn);
		if (afterHitTurn < 20) {
			x = ex - ent.lastHitX;
			y = ey - ent.lastHitY;
			rn = GRAV_LASTHIT_PER_ENEMY / (x*x + y*y) *
				(20 - afterHitTurn) / 20;
			forceX += x * rn;
			forceY += y * rn;
		}

		forceX += 
			2 * GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ex-WALL_AVOID_INTERVAL), GRAV_WALL_POW);
		forceX -=
			2 * GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ex-ent.fieldW+WALL_AVOID_INTERVAL),
					 GRAV_WALL_POW);
		forceY +=
			2 * GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ey-WALL_AVOID_INTERVAL), GRAV_WALL_POW);
		forceY -=
			2 * GRAV_WALL_PER_ENEMY /
			Math.pow(Math.abs(ey-ent.fieldH+WALL_AVOID_INTERVAL),
					 GRAV_WALL_POW);

		double trans = Util.getNormalRadian(
			Math.atan2(forceX, forceY) -
			Util.getNormalRadian(ent.getHeadingRadians()));
		goRadian(trans);
	}

}

