package gh.ghmove;

import gh.ghutils.*;

/**
 * StatBuffer
 *
 * This class represents the statistics for Surfing.
 * Credit: Refactoring idea derived from the implementation of Dookious by Voidious
 *
 * This code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */

public class SurfStat {

	private static double[] unsegStat = new double[GHUtils.MBINS+1];		// the stats
	private static double[][] velStat = new double[GHUtils.MVELSEG][GHUtils.MBINS+1];
	private static double[][] wallStat = new double[GHUtils.MWALLSEG][GHUtils.MBINS+1];
	private static double[][] accStat  = new double[GHUtils.MACCSEG][GHUtils.MBINS+1];
	private static double[][] dl14Stat = new double[GHUtils.MDL14SEG][GHUtils.MBINS+1];


	// recordHit: routine to record that I was hit
	//     ouch, still using piramid 0.2 - 0.6 - 1.0 - 0.6 - 0.2 !!
	//     when do I really calculate minbin and maxbin ??
	public void recordHit( int minbin, int maxbin, int vseg, int wseg, int aseg, int dseg) {
		int bin;
//		double bindanger;

		unsegStat[GHUtils.MBINS]++;
		velStat[vseg][GHUtils.MBINS]++;	// count number of data in segment
		wallStat[wseg][GHUtils.MBINS]++;
		accStat[aseg][GHUtils.MBINS]++;
		dl14Stat[dseg][GHUtils.MBINS]++;

//		// decay
//		for (int i = 0; i < BINS; i++) {
//			unsegStat[i] *= 0.7;
//			velStat[vseg][i] *= 0.7;
//		}
		// mark every place where I would have been hit as dangerous
//		for (bin = 0; bin < (BINS-1); bin++) {
//			bindanger = 1.0 / ((bin - minbin) * (bin - minbin) + 1);
//			unsegStat[bin] += bindanger;
//			velStat[vseg][bin] += bindanger;
//			wallStat[wseg][bin] += bindanger;
//		}

		for (bin = minbin; bin <= maxbin; bin++) {
			unsegStat[bin] += 1.0;
			velStat[vseg][bin] += 1.0;
			wallStat[wseg][bin] += 1.0;
			accStat[aseg][bin] += 1.0;
			dl14Stat[dseg][bin] += 1.0;
		}

		if (minbin > 0) {
			unsegStat[minbin-1] += 0.6;
			velStat[vseg][minbin-1] += 0.6;
			wallStat[wseg][minbin-1] += 0.6;
			accStat[aseg][minbin-1] += 0.6;
			dl14Stat[dseg][minbin-1] += 0.6;
		}
		if (minbin > 1) {
			unsegStat[minbin-2] += 0.2;
			velStat[vseg][minbin-2] += 0.2;
			wallStat[wseg][minbin-2] += 0.2;
			accStat[aseg][minbin-2] += 0.2;
			dl14Stat[dseg][minbin-2] += 0.2;
		}
		if (maxbin < (GHUtils.MBINS-1)) {
			unsegStat[maxbin+1] += 0.6;
			velStat[vseg][maxbin+1] += 0.6;
			wallStat[wseg][maxbin+1] += 0.6;
			accStat[aseg][maxbin+1] += 0.6;
			dl14Stat[dseg][maxbin+1] += 0.6;
		}
		if (maxbin < (GHUtils.MBINS-2)) {
			unsegStat[maxbin+2] += 0.2;
			velStat[vseg][maxbin+2] += 0.2;
			wallStat[wseg][maxbin+2] += 0.2;
			accStat[aseg][maxbin+2] += 0.2;
			dl14Stat[dseg][maxbin+2] += 0.2;
		}
//		System.out.println( robot.getTime()+" Hit on bin:"+bin+" at vseg:"+vseg);
	}

	public double binDanger(EnemyWave ew, int index) {
		double danger = 0;
		double defdanger = (unsegStat[index] / unsegStat[GHUtils.MBINS]) / 10;
//System.out.println(TickState.currTime+"  Vel: "+ew.myVelocityBin+"  Wall: "+ew.myNearWallBin+"  Acc: "+ew.myAccelerationBin);
		if (velStat[ew.myVelocityBin][GHUtils.MBINS] > 2)
			danger += (velStat[ew.myVelocityBin][index] * 1) / velStat[ew.myVelocityBin][GHUtils.MBINS];
		else
			danger += defdanger;
		if (wallStat[ew.myNearWallBin][GHUtils.MBINS] > 3)
			danger += (wallStat[ew.myNearWallBin][index] * 0.6) / wallStat[ew.myNearWallBin][GHUtils.MBINS];
		else
			danger += defdanger * 0.6;
		if (accStat[ew.myAccelerationBin][GHUtils.MBINS] > 2)
			danger += (accStat[ew.myAccelerationBin][index] * 1) / accStat[ew.myAccelerationBin][GHUtils.MBINS];
		else
			danger += defdanger;
		if (dl14Stat[ew.myDistLast14Bin][GHUtils.MBINS] > 2)
			danger += (dl14Stat[ew.myDistLast14Bin][index] * 1) / dl14Stat[ew.myDistLast14Bin][GHUtils.MBINS];
		else
			danger += defdanger;

		return danger;
	}

	public double[] binDanger(EnemyWave ew) {
		double[] danger = new double[GHUtils.MBINS];
//System.out.println(TickState.currTime+"  Vel: "+ew.myVelocityBin+"  Wall: "+ew.myNearWallBin+"  Acc: "+ew.myAccelerationBin);
		for (int i = 0; i < GHUtils.MBINS; i++) {
			danger[i] = binDanger( ew, i);
		}
		return danger;
	}

	public void printSegStats() {
		System.out.println("Movement info datapoints: "+ unsegStat[GHUtils.MBINS]);
//		for (int i = 0; i < GHUtils.MVELSEG; i++) {
//			System.out.println("V Segment "+i+" count "+ velStat[i][GHUtils.MBINS]);
//		}
//		for (int i = 0; i < GHUtils.MWALLSEG; i++) {
//			System.out.println("W Segment "+i+" count "+ wallStat[i][GHUtils.MBINS]);
//		}
//		for (int i = 0; i < GHUtils.MACCSEG; i++) {
//			System.out.println("A Segment "+i+" count "+ accStat[i][GHUtils.MBINS]);
//		}
//		for (int i = 0; i < GHUtils.MDL14SEG; i++) {
//			System.out.println("D Segment "+i+" count "+ dl14Stat[i][GHUtils.MBINS]);
//		}
	}
}
