package cx.mini;
import cx.utils.MeleeWave;
import robocode.*;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Enumeration;
import java.awt.geom.Point2D;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Nimrod:use MeleeWave to do pattern analyzer and random to corner or battle side movement
 *--------------------version 0.2 2003.1.5--------------
 * 0.2:aiming is good,but movement is not very satisfying.
 *--------------------version 0.31 2003.3.1--------------
 * 0.31:become team robot.5 Nimrods become a team.
 *--------------------version 0.5 2003.3.3--------------
 * 0.40:improved aiming system.
 *--------------------version 0.45 2003.3.5--------------
 * 0.45:improved aiming system a little.
 *--------------------version 0.50 2003.3.10--------------
 * 0.50:fixed a aming bug changed a pattern input element and squeezed.
 *--------------------version 0.55 2003.6.4--------------
 * 0.55:improved aiming system a little and squeezed.(codesize 1493)
 *-------------------------------------------------------
 * future:improve movement and aiming to be a good nimrod.
 */
public class Nimrod extends TeamRobot
{
	private static Hashtable enemys=new Hashtable();
	private static Enemy target;
	private static long  scannedTime;

	public void run( ) {
		setColors(Color.blue,null,Color.red);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);

        //radar turn infinity,will turn all time
		Enemy.battleFieldWidth=getBattleFieldWidth();
        Enemy.battleFieldHeight=getBattleFieldHeight();
        setTurnRadarRightRadians( Double.POSITIVE_INFINITY );

		do{
			doMove();	
			doShoot();
			execute();
		}
		while(true);
	} 
    public void doMove(){
		double disAngle,moveDistance,moveAngle,minDisAngle,turnAngle;
		Point2D.Double myP,nextP,force;
		myP=new Point2D.Double(getX(),getY());
        force=new Point2D.Double(0d,0d);
		Enumeration e = enemys.elements();
		while(e.hasMoreElements()){
			Enemy enemy=(Enemy)e.nextElement();
			if(enemy.energy>=0){
				force=Enemy.nextPoint(force,enemy.absBearing,-1d/enemy.distance);
			}
		}

		if(Math.abs(getDistanceRemaining())<Math.random()*8 && getTime()>8){
            disAngle=Math.PI/4;
			
	    	minDisAngle=Math.max(Math.PI/6,Math.min(Math.PI/3d,Math.PI/6d*(80/(moveDistance=target.distance*0.4d))));
            do{
		    	nextP=Enemy.nextPoint(myP,moveAngle=Math.atan2(force.x,force.y)+Math.random()*2*disAngle-disAngle,60+moveDistance*Math.random());
		    	disAngle+=(5d/180d*Math.PI);
			}while((Math.abs(robocode.util.Utils.normalRelativeAngle(moveAngle-target.absBearing-Math.PI))<(minDisAngle-=(0.5/180*Math.PI)) || !Enemy.isInBattle(nextP)));

            //thanks to David Alves and Dummy for this small code to find which direction is shortest to our next destination
			//Thanx DrLoco of this usage
			setAhead(
			 (
				( 
				disAngle = robocode.util.Utils.normalRelativeAngle(
				                  MeleeWave.getAngle( nextP,myP) - getHeadingRadians() 
				                  ) 
				) == ( turnAngle = Math.atan( Math.tan( disAngle ) ) 
					) ? 1 : - 1 )	
			 * myP.distance(nextP) );	//move towards point
			setTurnRightRadians( turnAngle );
		}
		setMaxVelocity(45d/getTurnRemaining());
	}

	public void doShoot(){
		try{
			double firePower,energy,offsetAngle;
			firePower=Math.min(target.energy/5d,Math.min(3d,100d/target.distance*(energy=getEnergy())));
             //turn gun
			offsetAngle=target.absBearing;
			if(getGunHeat()<0.4d){
				offsetAngle=target.getShootTurnAngle(new Point2D.Double(getX(),getY()),firePower);
			}
            setTurnGunLeftRadians(robocode.util.Utils.normalRelativeAngle(getGunHeadingRadians()-offsetAngle)); 
			if((energy>3.1d || energy-firePower>target.energy) && Math.abs(getTime()-scannedTime-2.5d)<2.4d){
		    	setFire(firePower);
			}
		}catch(Exception exception){}
	}
    // -------------------- function for event handle ---------------

   	public void onScannedRobot( ScannedRobotEvent e ) {
		String name;
		Enemy enemy;
		if((enemy=(Enemy)enemys.get(name=e.getName()))==null){     //new enemy
			enemy=new Enemy();
			enemys.put(name,enemy);
		}
        double distance;
        enemy.update(new Point2D.Double(getX(),getY()),getTime(),
			 e.getBearingRadians(),getHeadingRadians(),e.getHeadingRadians(),
		     e.getVelocity(),distance=e.getDistance(),e.getEnergy());

		enemy.testWave(getTime());
		if(enemy==target){
			scannedTime=getTime();
		}
        //select target
		if((!isTeammate(name)) && (target==null || target.energy<0d || enemy.energy==0d || getGunHeat()>0.7 && distance<target.distance)){
			target=enemy;
		}
    }


	public void onRobotDeath(RobotDeathEvent e){
		
		try{
			//set this enemy dead
			((Enemy)enemys.get(e.getName())).energy=-1d;
		}catch(Exception exception){}
	}

}

