package nat.gfx;

import java.awt.Graphics2D;
import java.util.ArrayList;

public final class GraphicsLayer {
	public final String name;
	public final int key;
	public boolean paint = true;
	public final ArrayList<Renderable> renderables;
	
	public GraphicsLayer(String name, int key) {
		this.name = name;
		this.key = key;
		renderables = new ArrayList<Renderable>();
	}
	
	public void clear(){
		renderables.clear();
	}
	
	public void render(Graphics2D g) {
		for (Renderable r : renderables) {
			r.render(g);
		}
	}
	
	public void add(Renderable r) {
		renderables.add(r);
	}
}
