package mn.nano.perceptual;

import static java.lang.Double.NEGATIVE_INFINITY;
import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.PI;
import static java.lang.Math.asin;
import static java.lang.Math.cos;
import static java.lang.Math.sin;
import static java.util.Arrays.asList;
import static robocode.Rules.MAX_BULLET_POWER;
import static robocode.util.Utils.normalRelativeAngle;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

public class Impact extends TeamRobot {

    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);

	while (true) {
	    turnRadarRightRadians(POSITIVE_INFINITY);
	}
    }

    @Override
    public void onScannedRobot(final ScannedRobotEvent event) {
	try {
	    if (asList(getTeammates()).contains(event.getName()))
		return;
	} catch (NullPointerException e) {
	}

	final double headOnAngle = getHeadingRadians() + event.getBearingRadians();

	// radar
	final double turnRadar = normalRelativeAngle(headOnAngle - getRadarHeadingRadians());
	setTurnRadarRightRadians(turnRadar + (turnRadar >= 0 ? PI / 8 : -PI / 8));

	// energy management
	final double bulletPower = event.getDistance() < 74.01065284083685D ? MAX_BULLET_POWER : 1.8342171685458617D;
	setFire(bulletPower);

	// gun
	final double linearAngle = headOnAngle + asin(event.getVelocity() / Rules.getBulletSpeed(bulletPower) * sin(event.getHeadingRadians() - headOnAngle));
	setTurnGunRightRadians(normalRelativeAngle(linearAngle - getGunHeadingRadians()));

	// movement
	double turn = linearAngle - getHeadingRadians();
	setAhead(POSITIVE_INFINITY);
	if (cos(turn) < 0) {
	    turn -= PI;
	    setAhead(NEGATIVE_INFINITY);
	}
	setTurnRightRadians(normalRelativeAngle(turn));
    }

}