package paulk;
import robocode.*;
import java.util.*;
import java.awt.geom.*;

public class EnergieManager{
	Map energie;
	Map chaleur;
	Map temps;
	Map lastScan;
	MouvementManager mouvM;
	AdvancedRobot bot;

	EnergieManager(MouvementManager m,AdvancedRobot r){
		energie=new Hashtable();
		chaleur=new Hashtable();
		temps=new Hashtable();
		lastScan=new Hashtable();
		mouvM=m;
		bot=r;
	}

	public void nouvBot(AdvancedRobot r){
		bot=r;
	}

	public void onScannedRobot(ScannedRobotEvent e,long t){
		String nom=e.getName();
		if (energie.containsKey(nom)){
			double diff=(Double)energie.get(nom)-e.getEnergy();
			if (diff>=0.0999999 && diff<=3.0000001){
				boolean contient=chaleur.containsKey(nom) && temps.containsKey(nom);
				if (contient){
				       if((Double)chaleur.get(nom)<=0.001+(t-(Long)temps.get(nom))*0.1){
//						System.out.println(nom+" a tiré avec "+diff);
						ScannedRobotEvent eLast=e;
						if (lastScan.containsKey(nom)){
							eLast=(ScannedRobotEvent)lastScan.get(nom);
						}
						double angle=eLast.getBearingRadians()+bot.getHeadingRadians();
						double x=bot.getX()+eLast.getDistance()*Math.sin(angle);
						double y=bot.getY()+eLast.getDistance()*Math.cos(angle);
						x-=bot.getVelocity()*Math.sin(bot.getHeadingRadians());
						y-=bot.getVelocity()*Math.cos(bot.getHeadingRadians());
						Point2D.Double p=new Point2D.Double(x,y);
						Point2D.Double pos=new Point2D.Double(bot.getX(),bot.getY());
						int segment=MouvementManager.getSegment(e,bot);
						SonOnde s=new SonOnde(p,diff,bot,e.getName(),pos,segment);
						mouvM.nouvOnde(s);
						temps.put(nom,t-1);
				       }
				       else {
						System.out.println(nom+" a des problèmes de température : dE="+diff);
						System.out.println("t="+t+" ancT="+(Long)temps.get(nom)+" chaleur="+(Double)chaleur.get(nom));
				       }
				}
				else {
//					System.out.println(nom+" a tiré avec "+diff);
					double angle=e.getBearingRadians()+bot.getHeadingRadians();
					double x=bot.getX()+e.getDistance()*Math.sin(angle);
					double y=bot.getY()+e.getDistance()*Math.cos(angle);
					Point2D.Double p=new Point2D.Double(x,y);
					Point2D.Double pos=new Point2D.Double(bot.getX(),bot.getY());
					int segment=MouvementManager.getSegment(e,bot);
					SonOnde s=new SonOnde(p,diff,bot,e.getName(),pos,segment);
					mouvM.nouvOnde(s);
					temps.put(nom,t-1);
				}
				chaleur.put(nom,Rules.getGunHeat(diff));
			}
			else {
				if (diff>0.01 || diff<0)
					System.out.println("diff="+diff);
			}
		}
		energie.put(nom,e.getEnergy());
		lastScan.put(nom,e);
	}
	public void onBulletHit(BulletHitEvent e){
		energie.put(e.getName(),e.getEnergy());
	}
	public void onHitByBullet(HitByBulletEvent e){
		if (energie.containsKey(e.getName())){
			energie.put(e.getName(),(Double)energie.get(e.getName())+Rules.getBulletHitBonus(e.getPower()));
		}
	}
	public void onHitRobot(HitRobotEvent e){
		energie.put(e.getName(),e.getEnergy());
	}
	public void onRobotDeath(RobotDeathEvent e){
		if (energie.containsKey(e.getName())){
			energie.remove(e.getName());
		}
	}
}
