package gh.mini;
import java.awt.geom.*;
import java.awt.Color;
//import java.util.*;

import robocode.*;
import robocode.util.Utils;
import robocode.Rules;

/**
 * Grimmig - a robot by Gert Heijenk
 *
 * Mini-bot with GuessFactorTargeting and WaveSurfing
 * Credits to PEZ for the 'MicroWave extends Condition' way of working as in Aristocles
 *
 * Revision information:
 * v0.0   20180220 take Grinnik 0.7, strip movement and put in the simplest WaveSurfing you can imagine.
 * v0.0.1 20180705 fixing left/right forward/backward 1/-1  confusions all over the place (my tank is running into bullets on purpose)
 * v0.0.2 20181019 400 bytes to much, stupid wall-behaviour, and more problems. So first some shrinking . . .
 * v0.1   20190607 take Grinnik 0.8, fire 'smart' bullets iso fixed 1.9, do some energymanagement etc.
 * v0.2   20190611 fix some bulletpower/bulletspeed issues in Wave, get rid of BINFACTOR.
 * v0.3   20190618 separate bins for acceleration/deceleration in Vchange segmentn (+21 bytes)
 * v0.3.1 20190626 fix occasional radarlock loss, just by using setAdjustRadarForGunTurn( true) (+5 bytes)
 * v0.3.2 20190628 simplify velocity attribute [0-2][2-4][4-6][6-8][8] (5 segments) into 3 segments [0-1.8][1.8-6.2][6.2-8]  (+15 bytes)
 * v0.3.3 20190703 expand velocity attribute to 4 segments [0.0-1.1][1.1-4.0][4.0-6.9][6.9-8.0] (+0 bytes)
 * v0.3.4 20190704 remove distance attribute from gun (as I think it has no real use) (-11 bytes)
 * v0.3.5 20190709 add wallproximity attribute (+85 bytes)
 * v0.3.6 20190711 add back distance attribute. Next step: replace Stop-n-Go + oscilator with simple wavesurfing
*/
public class Grimmig extends AdvancedRobot
{

	static final int	BINS			= 37;	// distance 550, bulletpower 1.9, halfbotwidth
	static final int	MIDBIN			= BINS / 2;
//	Rectangle2D.Double fireField = new Rectangle2D.Double( 18, 18, 764, 564); = +2 bytes

	static final double DEFDISTANCE		= 495;	

//	static int[] unsegBuf = new int[BINS];
//	static int[][][][] unsegBuf = new int[7][4][5][BINS];	// on acceleration, velocity, distance
//	static int[][]  [] unsegBuf = new int[7][4]   [BINS];	// on acceleration, velocity
//	static int[][][][] unsegBuf = new int[7][4][3][BINS];	// on acceleration, velocity, wallproximity
	static int[][][][][] unsegBuf = new int[7][4][5][3][BINS];	// on acceleration, velocity, distance, wallproximity

	static boolean randomMove;			// starts with false, meaning StopNGo
	static Point2D.Double enemyPos;
//	static Point2D.Double myPos;		// = +4 bytes
	static double enemyLastEnergy;		// for enemy-fire detection
	static int enemyLastVelocity;		// for gunsegmentation
	static int timeSinceVChange;		// for gunsegmentation
	static double dist = 48;			// default distance to move with StopAndGo

	/**
	 * run: Grimmig's default behavior
	 */
	public void run() {

		// Give the robot an appealing look
		setColors( Color.red, Color.green, Color.red);	// 13 bytes !!

		// Let gun and radar move independently
		setAdjustGunForRobotTurn( true);
		setAdjustRadarForGunTurn( true);		// 5 bytes 

		// Start the mainloop
//		while(true) {
//			turnRadarRight( Double.POSITIVE_INFINITY);
//		}
	}

	/**
	 * onStatus: Just to save 3 bytes for radarhandling
	 */
    public void onStatus( StatusEvent e) {
        setTurnRadarRightRadians(1);
    }
	/**
	 * onScannedRobot: Event from scanning another robot
	 */
    public void onScannedRobot( ScannedRobotEvent e) {

		// some common stuff
		Rectangle2D.Double fireField = new Rectangle2D.Double( 18, 18, 764, 564);
		MicroWave gunWave = new MicroWave();

		Point2D.Double myPos = gunWave.fireLocation = new Point2D.Double( getX(), getY());
		double enemyAbsBearing = gunWave.HOTAngle = getHeadingRadians() + e.getBearingRadians();
		enemyPos = doProjectPos( myPos, enemyAbsBearing, e.getDistance());

		// radar
		setTurnRadarRightRadians( 2.2 * Utils.normalRelativeAngle( enemyAbsBearing - getRadarHeadingRadians()));

		// movement stuff
		if (randomMove == false) {
			if ( enemyLastEnergy - (enemyLastEnergy = e.getEnergy()) > 0.0) {
//				out.println(getTime()+" Enemy bullet fired !!");
//				setMaxVelocity( (getVelocity() < 1.0 ? 8.0 : 0.3));	// 20 bytes extra !!
				setAhead( dist);
			}
		}
		else {
			if ( (dist = getDistanceRemaining()) == 0.0) {
				setAhead( dist = (( Math.sin( getTime()/11) * Math.cos( getTime()/29))*(260) + (Math.random()*100 - 50)));
			}
		}

//		double myDirection = (dist < 0 ? -1 : 1);
		double myDirection = (dist / Math.abs(dist));	// 4 bytes smaller
		double adjustAngle = ((e.getDistance() / DEFDISTANCE) - 1.0) * Math.PI/2 * (myDirection);	// distancing
		double prefAngle = adjustAngle = enemyAbsBearing + Math.PI/2 - adjustAngle;
		while( !fireField.contains( doProjectPos( myPos, adjustAngle -= (0.05*myDirection) , dist)));

		// Because it is relative to prefAngle, it is automatically distance dependent
		if (Math.abs( (adjustAngle - prefAngle)) > Math.PI/2.2) {
			setAhead( dist = -dist);
		}

		setTurnRightRadians( Utils.normalRelativeAngle( adjustAngle - getHeadingRadians()));

		// gunstuff

		// accelerationsegment
//		int enemyAccBin = 2 + Math.min(3, (timeSinceVChange++ / 10));
//		if (Math.abs( prefAngle = enemyLastVelocity - (enemyLastVelocity = Math.abs(e.getVelocity()))) > 0.0) {
//			enemyAccBin = timeSinceVChange = ( prefAngle > 0 ? 0 : 1);
//		}
		int accBin = enemyLastVelocity - (enemyLastVelocity = (int)Math.abs(e.getVelocity()));
		if (accBin != 0) {
			accBin = timeSinceVChange = ( accBin > 0 ? 0 : 1);
		}
		else {
			accBin = 2 + Math.min(4, (timeSinceVChange++ / 8));
		}
		int velBin = (int)((Math.abs(e.getVelocity()) + 1.8) / 2.9);
		int wallBin = 0;
		if (!fireField.contains( doProjectPos( enemyPos, e.getHeadingRadians(), sign(e.getVelocity()) * 100))) {
				wallBin = 1;
		} else if (!fireField.contains( doProjectPos( enemyPos, e.getHeadingRadians(), -sign(e.getVelocity()) * 100))) {
				wallBin = 2;
		} 

//		out.println("V: "+e.getVelocity()+" H: "+e.getHeadingRadians()+" wallBin: "+wallBin); 
//		out.println("Velocity: "+ e.getVelocity()+" segment: " + (int)((Math.abs(e.getVelocity())+2.6)/4.4) + " c " + velBin);
//		gunWave.gfBuf = unsegBuf[accBin][velBin][(int)(e.getDistance()/190)]; 
//		gunWave.gfBuf = unsegBuf[accBin][velBin]; 
//		gunWave.gfBuf = unsegBuf[accBin][velBin][wallBin]; 
		gunWave.gfBuf = unsegBuf[accBin][velBin][(int)(e.getDistance()/190)][wallBin]; 
		// search best bin to aim
		int bindex = MIDBIN;
		int index = BINS - 1;
		do {
			if(gunWave.gfBuf[index] > gunWave.gfBuf[bindex]) {
				bindex = index;
			}
		} while (index-- > 0);

// first option  6 bytes more than second option
		double firePower = (0.5 + (int)Math.min(Math.min(e.getEnergy()*2.5, getEnergy()), 19))/10.0;
//		double firePower = Math.min(Math.min(e.getEnergy()/4, getEnergy()/10), 1.95);
//		out.println(getTime()+" Firepower "+firePower+" eE "+e.getEnergy()+" myE "+getEnergy());
		gunWave.bulletSpeed = Rules.getBulletSpeed(firePower);
		gunWave.binFactor = Math.asin(8 / gunWave.bulletSpeed) / MIDBIN;
		if (e.getVelocity() * Math.sin( e.getHeadingRadians() - enemyAbsBearing) < 0) gunWave.binFactor = -gunWave.binFactor;
	
		// Fire in the hose!
		prefAngle = 0.6 / e.getDistance();		// imperfection to lure bulletcatchers
		setTurnGunRightRadians( Utils.normalRelativeAngle( enemyAbsBearing - getGunHeadingRadians() + prefAngle + ((bindex - MIDBIN) * gunWave.binFactor)));

		if (getEnergy() > 0.1) {
			setFire( e.getDistance() < 100 ? 3.0 : firePower);
			addCustomEvent( gunWave);
//			out.println("Fire !"+enemyAccBin);
//			out.println(currTime+" "+gunWave.fireLocation+" "+gunWave.HOTAngle);
		}
	}

	/**
	 * onDeath: I died, so try something else
	 */
	public void onDeath( DeathEvent e) {
		if (getRoundNum() < 5) randomMove = true;
	}

	/**
	 * onBulletHit: I hit the other
	 */
    public void onBulletHit( BulletHitEvent e) {
		enemyLastEnergy -= Rules.getBulletDamage(e.getBullet().getPower()); // = +7 bytes
    }

	/**
	 * onHitByBullet:  I am hit
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		enemyLastEnergy += Rules.getBulletHitBonus(e.getPower()); // = -1 bytes
	}

	/**
	 * doProjectPos: Calculate position out of heading and distance
	 */
	static Point2D.Double doProjectPos( Point2D.Double startpos, double head, double dist){	
		return new Point2D.Double( startpos.x + (dist * Math.sin( head)), startpos.y + (dist * Math.cos( head)));			
	}

	static int sign(double v) {
		return v < 0 ? -1 : 1;
	}

	/**
	 * MicroWave: a condition based Wave
	 * Credits to PEZ as this is based upon the MicroWave of Aristocles
	 */
	public class MicroWave extends Condition {

		double HOTAngle;
		Point2D.Double fireLocation;
		double waveFront;
		double bulletSpeed;
		double binFactor;	
		int[]  gfBuf;

		public boolean test() {
			if ( enemyPos.distance( fireLocation) <= (waveFront += bulletSpeed)) {
//				double angleDiff = Utils.normalRelativeAngle( Math.atan2( enemyPos.x - fireLocation.x, 
//																		  enemyPos.y - fireLocation.y) - HOTAngle);
//				gfBuf[ MIDBIN + (int)(angleDiff / binFactor)]++;
//				out.println("Virtual hit:"+ (MIDBIN + (int)(angleDiff / binFactor)));
				gfBuf[ MIDBIN + (int)(Utils.normalRelativeAngle( 
						Math.atan2( enemyPos.x - fireLocation.x, enemyPos.y - fireLocation.y)
						- HOTAngle)	/ binFactor)]++;
				removeCustomEvent(this);
			}
			return false;
		}
	}
}

