/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.radar;

import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.radar.RadarCommand;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;

public class RadarNarrowLock
implements RadarCommand {
    private EnemyRobot enemy;
    private CommandBasedRobot myRobot;
    private boolean lockedOn = false;
    private double previousSeenTime;
    private double scanDirection;

    public RadarNarrowLock(EnemyRobot enemy, CommandBasedRobot myRobot) {
        this.enemy = enemy;
        this.myRobot = myRobot;
        this.calculateInitialScanDirection();
    }

    private void calculateInitialScanDirection() {
        this.scanDirection = Geometry.getRelativeBearing(this.myRobot.getRadarHeading(), this.getEnemyBearing()) >= 0.0 ? 1.0 : -1.0;
    }

    private double getEnemyBearing() {
        return Geometry.getBearingBetweenLocations(this.myRobot.getLocation(), this.enemy.getLatestRadarObservation().getLocation());
    }

    @Override
    public boolean isDone() {
        return !this.enemy.isAlive();
    }

    @Override
    public double getRightTurn() {
        if (this.lockedOn) {
            double targetRadarBearing = this.getEnemyBearing() + 22.5 * this.scanDirection;
            return Geometry.getRelativeBearing(this.myRobot.getRadarHeading(), targetRadarBearing);
        }
        return this.scanDirection * 45.0;
    }

    @Override
    public void executed() {
        boolean wasLockedOn = this.lockedOn;
        this.areWeStillLockedOn();
        if (this.lockedOn) {
            this.scanDirection *= -1.0;
        } else if (wasLockedOn) {
            this.calculateInitialScanDirection();
        }
    }

    private void areWeStillLockedOn() {
        long timeLastSeen;
        this.lockedOn = this.enemy.getLatestRadarObservation() != null ? this.previousSeenTime < (double)(timeLastSeen = this.enemy.getLatestRadarObservation().getTimeSeen()) && this.myRobot.getTime() - timeLastSeen <= 2L : false;
    }

    @Override
    public void paint(Graphics2D g) {
        this.enemy.drawCircle(g, Color.RED, 30);
    }
}

