/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.robots;

import ags.rougedc.robots.VirtualRobot;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import robocode.Rules;

public abstract class VirtualRobotPredictor
implements VirtualRobot {
    private AbsolutePoint fieldcorner;
    private AbsolutePoint location;
    private RelativePoint velocity;
    private double energy;
    private long deltatime;
    private boolean hitWall;
    private static final int ROBOT_SIZE = 18;

    public VirtualRobotPredictor(VirtualRobot sourcerobot, AbsolutePoint fieldcorner) {
        this.fieldcorner = fieldcorner;
        if (sourcerobot != null) {
            this.reset(sourcerobot);
        }
    }

    public void reset(VirtualRobot sourcerobot) {
        this.location = (AbsolutePoint)sourcerobot.getLocation().clone();
        this.velocity = (RelativePoint)sourcerobot.getVelocity().clone();
        this.energy = sourcerobot.getEnergy();
        this.deltatime = 0L;
        this.hitWall = false;
    }

    public boolean hitsWall() {
        return this.hitWall;
    }

    public AbsolutePoint move() {
        ++this.deltatime;
        double acceleration = this.getAcceleration();
        acceleration = Math.abs(acceleration) > Math.abs(this.velocity.getMagnitude()) && Math.signum(acceleration) == Math.signum(this.velocity.getMagnitude()) ? Math.max(Math.min(acceleration, 1.0), -1.0) : Math.max(Math.min(acceleration, 2.0), -2.0);
        double maxav = Math.toRadians(Rules.getTurnRate((double)Math.abs(this.velocity.getMagnitude())));
        double angularvelocity = Math.max(Math.min(this.getAngularVelocity(), maxav), -maxav);
        this.velocity = (RelativePoint)this.velocity.clone();
        this.velocity.setDirectionMagnitude(this.velocity.getDirection() + angularvelocity, Math.max(Math.min(this.velocity.getMagnitude() + acceleration, 8.0), -8.0));
        AbsolutePoint nlocation = this.location.addRelativePoint(this.velocity);
        if (Double.isNaN(nlocation.x) || Double.isNaN(nlocation.y)) {
            System.out.println("Warning: VirtualRobotPredictor encountered NaN!");
        } else {
            this.location = nlocation;
        }
        this.hitWall = this.processWallCollision();
        return this.location;
    }

    public boolean processWallCollision() {
        boolean hitWall = false;
        double fixx = 0.0;
        double fixy = 0.0;
        if ((double)Math.round(this.location.getX()) > this.fieldcorner.x - 18.0) {
            hitWall = true;
            fixx = this.fieldcorner.x - 18.0 - this.location.getX();
        }
        if (Math.round(this.location.getX()) < 18L) {
            hitWall = true;
            fixx = 18.0 - this.location.getX();
        }
        if ((double)Math.round(this.location.getY()) > this.fieldcorner.y - 18.0) {
            hitWall = true;
            fixy = this.fieldcorner.y - 18.0 - this.location.getY();
        }
        if (Math.round(this.location.getY()) < 18L) {
            hitWall = true;
            fixy = 18.0 - this.location.getY();
        }
        double tanHeading = Math.tan(this.velocity.direction);
        double fixxtanHeading = fixx / tanHeading;
        double fixytanHeading = fixy * tanHeading;
        if (fixx == 0.0) {
            fixx = fixytanHeading;
        } else if (fixy == 0.0) {
            fixy = fixxtanHeading;
        } else if (Math.abs(fixxtanHeading) > Math.abs(fixy)) {
            fixy = fixxtanHeading;
        } else if (Math.abs(fixytanHeading) > Math.abs(fixx)) {
            fixx = fixytanHeading;
        }
        this.location.setLocation(this.location.x + fixx, this.location.y + fixy);
        if (hitWall) {
            this.velocity.setDirectionMagnitude(this.velocity.direction, 0.0);
        }
        return hitWall;
    }

    @Override
    public AbsolutePoint getLocation() {
        return this.location;
    }

    @Override
    public RelativePoint getVelocity() {
        return this.velocity;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    public long getDeltaTime() {
        return this.deltatime;
    }

    public abstract double getAcceleration();

    public abstract double getAngularVelocity();
}

