/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.BotRecord;
import alk.lap.strategy.Move;
import alk.lap.strategy.ScanRecord;
import alk.lap.strategy.analysis.AnalystsDatabase;
import java.util.Iterator;

public class ScanDatabase {
    public static final int HISTORY_SIZE = 800;
    public static final int SCANS = 0;
    public static final int MOVES = 1;
    public static final int PROUDSDATA = 2;
    private ScanRecord[] enemyScanHistory = new ScanRecord[800];
    private Move[] moveHistory = new Move[800];
    private ScanRecord[] proudHistory = new ScanRecord[800];
    private int enemyScanHistoryCount = 0;
    private int proudHistoryCount = 0;
    private int moveHistoryCount = 0;
    private AnalystsDatabase analystsDB;

    public void addEnemyScan(ScanRecord currentScan) {
        this.enemyScanHistory[this.enemyScanHistoryCount++ % 800] = currentScan;
        this.analystsDB.addAtomicMove(currentScan.atomicMove);
    }

    public void addEnemyMove(Move move) {
        this.moveHistory[this.moveHistoryCount++ % 800] = move;
    }

    public void addProudState(ScanRecord currentState) {
        this.proudHistory[this.proudHistoryCount++ % 800] = currentState;
    }

    public Move getCurrentEnemyMove() {
        return this.moveHistory[(this.moveHistoryCount - 1) % 800];
    }

    public int enemyScanCount() {
        return this.enemyScanHistoryCount;
    }

    public int moveHistoryCount() {
        return this.moveHistoryCount;
    }

    public int proudHistoryCount() {
        return this.proudHistoryCount;
    }

    public HistoryIterator getLastNScans(int lookBack) {
        return new HistoryIterator(lookBack, 0);
    }

    public String[] toCSV(int type, boolean printHead) {
        int size = 0;
        if (type == 1) {
            size = this.moveHistoryCount;
        }
        if (type == 0) {
            size = this.enemyScanHistoryCount;
        }
        if (type == 2) {
            size = this.proudHistoryCount;
        }
        if (printHead) {
            ++size;
        }
        String[] result = new String[size];
        int i = 0;
        HistoryIterator iter = new HistoryIterator(size, type);
        while (iter.hasNext()) {
            BotRecord s = (BotRecord)iter.next();
            if (i == 0 && printHead) {
                result[i++] = s.toCSVHead();
            }
            result[i++] = s.toCSV();
        }
        return result;
    }

    public double getAverageEnemyVelocity(int lookBack) {
        double sumV = 0.0;
        if (this.enemyScanCount() < 20 && this.analystsDB.velocityAvg != -1.0) {
            return this.analystsDB.velocityAvg;
        }
        HistoryIterator iter = this.getLastNScans(lookBack);
        while (iter.hasNext()) {
            sumV += ((ScanRecord)iter.next()).atomicMove.velocity;
        }
        double numberOfScans = iter.getIterations();
        this.analystsDB.velocityAvg = sumV / numberOfScans;
        return this.analystsDB.velocityAvg;
    }

    public double getAverageEnemyMoveLength(int lookBack) {
        double sumMoveLength = 0.0;
        if (this.moveHistoryCount() < 5 && this.analystsDB.moveLengthAvg != -1.0) {
            return this.analystsDB.moveLengthAvg;
        }
        int countedMoves = 0;
        for (BotRecord rec : new HistoryIterator(lookBack, 1)) {
            Move move = (Move)rec;
            if (move.duration <= 1L) continue;
            sumMoveLength += move.length;
            ++countedMoves;
        }
        if (countedMoves > 0) {
            this.analystsDB.moveLengthAvg = sumMoveLength / (double)countedMoves;
            return this.analystsDB.moveLengthAvg;
        }
        return sumMoveLength / (double)countedMoves;
    }

    public long getAverageEnemyMoveDuration(int lookBack) {
        int sumMoveDur = 0;
        if (this.moveHistoryCount() < 5 && this.analystsDB.movedurationAvg != -1.0) {
            System.out.println("historycount to low");
            return (long)this.analystsDB.movedurationAvg;
        }
        int countedMoves = 0;
        for (BotRecord rec : new HistoryIterator(lookBack, 1)) {
            Move move = (Move)rec;
            if (move.duration <= 1L) continue;
            sumMoveDur = (int)((long)sumMoveDur + move.duration);
            ++countedMoves;
        }
        if (countedMoves > 0) {
            this.analystsDB.movedurationAvg = (double)sumMoveDur / (double)countedMoves;
            return (long)this.analystsDB.movedurationAvg;
        }
        return 0L;
    }

    public double getEnemyVelocityStdDeviation(int lookBack) {
        double sumV = 0.0;
        double sumSqrV = 0.0;
        if (this.enemyScanCount() == 0) {
            return 0.0;
        }
        HistoryIterator iter = this.getLastNScans(lookBack);
        while (iter.hasNext()) {
            double v = ((ScanRecord)iter.next()).atomicMove.velocity;
            sumV += v;
            sumSqrV += Math.pow(v, 2.0);
        }
        double numberOfScans = iter.getIterations();
        return Math.sqrt((numberOfScans * sumSqrV - Math.pow(sumV, 2.0)) / (numberOfScans * (numberOfScans - 1.0)));
    }

    public double getAverageProudVelocity(int lookBack) {
        double sumV = 0.0;
        if (this.proudHistoryCount == 0) {
            return 0.0;
        }
        HistoryIterator iter = new HistoryIterator(lookBack, 2);
        while (iter.hasNext()) {
            sumV += ((ScanRecord)iter.next()).atomicMove.velocity;
        }
        double numberOfScans = iter.getIterations();
        return sumV / numberOfScans;
    }

    public ScanRecord getLastProudState() {
        if (this.proudHistoryCount == 0) {
            return null;
        }
        return this.proudHistory[(this.proudHistoryCount - 1) % 800];
    }

    public double getDirectionChangeRate(int lookBack) {
        int countPosMoves = 0;
        int countNegMoves = 0;
        if (this.moveHistoryCount() < 5) {
            System.out.println("historycount to low");
            return 0.0;
        }
        for (BotRecord rec : new HistoryIterator(lookBack, 1)) {
            Move move = (Move)rec;
            if (move.duration <= 1L || move.signV == 0.0) continue;
            if (move.signV > 0.0) {
                ++countPosMoves;
                continue;
            }
            ++countNegMoves;
        }
        if (countNegMoves == 0 || countPosMoves == 0) {
            return 0.0;
        }
        if (countPosMoves > countNegMoves) {
            return 1.0;
        }
        return -1.0;
    }

    public void newRound(LoudAndProud proud) {
        this.analystsDB = proud.getStrategicLead().getAnalystsDB();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HistoryIterator
    implements Iterable<BotRecord>,
    Iterator<BotRecord> {
        int from;
        int to;
        int i;
        int type;

        public HistoryIterator(int lookBack, int type) {
            this.type = type;
            if (type == 1) {
                this.from = Math.max(0, ScanDatabase.this.moveHistoryCount - lookBack);
                this.to = ScanDatabase.this.moveHistoryCount;
            }
            if (type == 0) {
                this.from = Math.max(0, ScanDatabase.this.enemyScanHistoryCount - lookBack);
                this.to = ScanDatabase.this.enemyScanHistoryCount;
            }
            if (type == 2) {
                this.from = Math.max(0, ScanDatabase.this.proudHistoryCount - lookBack);
                this.to = ScanDatabase.this.proudHistoryCount;
            }
            this.i = this.from;
        }

        public int getIterations() {
            return this.to - this.from;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.to;
        }

        @Override
        public BotRecord next() {
            if (this.type == 1) {
                return ScanDatabase.this.moveHistory[this.i++ % 800];
            }
            if (this.type == 0) {
                return ScanDatabase.this.enemyScanHistory[this.i++ % 800];
            }
            if (this.type == 2) {
                return ScanDatabase.this.proudHistory[this.i++ % 800];
            }
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<BotRecord> iterator() {
            return this;
        }
    }
}

