/*
 * Decompiled with CFR 0.152.
 */
package ds.movement;

import ds.movement.Vector2D;
import java.awt.geom.Point2D;

public class AntiGravityObject {
    private Point2D m_position;
    private double m_weight;
    protected double m_gravityType;

    public AntiGravityObject(double x, double y, double weight, double gravityType) {
        this.m_position = new Point2D.Double(x, y);
        this.m_weight = weight * 1000.0;
        this.m_gravityType = gravityType;
    }

    public Vector2D getForceVector(Point2D.Double referent) {
        double distance = referent.distance(this.m_position);
        Vector2D vect = new Vector2D(referent.getX() - this.m_position.getX(), referent.getY() - this.m_position.getY());
        if (Math.abs(vect.getX()) > Math.abs(vect.getY())) {
            vect.divide(Math.abs(vect.getX()));
        } else {
            vect.divide(Math.abs(vect.getY()));
        }
        double pow = Math.pow(distance, this.m_gravityType);
        vect.multiply(this.m_weight / pow);
        return vect;
    }

    public Point2D getPosition() {
        return this.m_position;
    }

    protected double getWeight() {
        return this.m_weight;
    }
}

