/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Movement.DangerPrediction;

import java.awt.Graphics2D;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionMovement;
import rdt.AgentSmith.Movement.EnemyWaveManager;
import rdt.SubsystemMode;
import rdt.Targeting.Targeting;
import rdt.Waves.WaveManager;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;

public class DangerPredictionMovementMode
extends SubsystemMode {
    private EnemyWaveManager _waveManager = new EnemyWaveManager();
    private DangerPredictionMovement _movement = null;

    public DangerPredictionMovementMode() {
        this.Initialise("Danger Prediction");
        this._movement = new DangerPredictionMovement(this._waveManager);
    }

    @Override
    public void UpdateHighestPriority() {
        this._movement.Update();
    }

    @Override
    public float GetPriority() {
        if (Targeting.GetCurrentTarget() == null) {
            return 0.0f;
        }
        if (!Targeting.GetCurrentTarget().Valid) {
            return 0.0f;
        }
        if (Targeting.GetCurrentTarget().NumSnapshots < 2) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void Update() {
        this._waveManager.Update();
    }

    @Override
    public void DebugDraw(Graphics2D gfx) {
        this._waveManager.DebugDraw(gfx);
        this._movement.DebugDraw(gfx);
    }

    @Override
    public void OnHitByBulletEvent(HitByBulletEvent event) {
        this._movement.OnHitByBulletEvent(event);
    }

    @Override
    public void OnBulletHitBulletEvent(BulletHitBulletEvent event) {
        this._movement.OnBulletHitBulletEvent(event);
    }

    @Override
    public void Shutdown() {
    }

    @Override
    public void OnRoundStart() {
        this._waveManager.ClearWaves();
        this._movement.OnRoundStart();
    }

    public WaveManager GetWaveManager() {
        return this._waveManager;
    }
}

