/*
 * Decompiled with CFR 0.152.
 */
package wiki.mc2k7;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RaikoGun {
    private static double bearingDirection = 1.0;
    private static double lastLatVel;
    private static double lastVelocity;
    private static double enemyEnergy;
    private static double enemyDistance;
    private static double lastVChangeTime;
    private static double enemyLatVel;
    private static double enemyVelocity;
    private static Point2D.Double enemyLocation;
    private static final int GF_ZERO = 15;
    private static final int GF_ONE = 30;
    private static String enemyName;
    private static int[][][][][][] guessFactors;
    private AdvancedRobot bot;

    public RaikoGun(AdvancedRobot bot) {
        this.bot = bot;
    }

    public void run() {
        this.bot.setAdjustGunForRobotTurn(true);
        this.bot.setAdjustRadarForGunTurn(true);
        while (true) {
            this.bot.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (enemyName == null) {
            enemyName = e.getName();
        }
        Point2D.Double robotLocation = new Point2D.Double(this.bot.getX(), this.bot.getY());
        double enemyAbsoluteBearing = this.bot.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = RaikoGun.projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);
        enemyEnergy = e.getEnergy();
        Rectangle2D.Double BF = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        MicroWave w = new MicroWave();
        lastLatVel = enemyLatVel;
        lastVelocity = enemyVelocity;
        enemyVelocity = e.getVelocity();
        enemyLatVel = enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        int distanceIndex = (int)enemyDistance / 140;
        double bulletPower = distanceIndex == 0 ? 3.0 : 2.0;
        double theta = Math.min(this.bot.getEnergy() / 4.0, Math.min(enemyEnergy / 4.0, bulletPower));
        if (theta == bulletPower) {
            this.bot.addCustomEvent((Condition)w);
        }
        bulletPower = theta;
        w.bulletVelocity = 20.0 - 3.0 * bulletPower;
        int accelIndex = (int)Math.round(Math.abs(enemyLatVel) - Math.abs(lastLatVel));
        if (enemyLatVel != 0.0) {
            bearingDirection = enemyLatVel > 0.0 ? 1.0 : -1.0;
        }
        w.bearingDirection = bearingDirection * Math.asin(8.0 / w.bulletVelocity) / 15.0;
        double d = lastVChangeTime;
        lastVChangeTime = d + 1.0;
        double moveTime = w.bulletVelocity * d / enemyDistance;
        int bestGF = moveTime < 0.1 ? 1 : (moveTime < 0.3 ? 2 : (moveTime < 1.0 ? 3 : 4));
        int vIndex = (int)Math.abs(enemyLatVel / 3.0);
        if (Math.abs(Math.abs(enemyVelocity) - Math.abs(lastVelocity)) > 0.6) {
            lastVChangeTime = 0.0;
            bestGF = 0;
            accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastVelocity));
            vIndex = (int)Math.abs(enemyVelocity / 3.0);
        }
        if (accelIndex != 0) {
            accelIndex = accelIndex > 0 ? 1 : 2;
        }
        w.firePosition = robotLocation;
        w.enemyAbsBearing = enemyAbsoluteBearing;
        w.waveGuessFactors = guessFactors[accelIndex][bestGF][vIndex][BF.contains(RaikoGun.projectMotion(robotLocation, enemyAbsoluteBearing + w.bearingDirection * 15.0, enemyDistance)) ? 0 : (BF.contains(RaikoGun.projectMotion(robotLocation, enemyAbsoluteBearing + 0.5 * w.bearingDirection * 15.0, enemyDistance)) ? 1 : 2)][distanceIndex];
        bestGF = 15;
        for (int gf = 30; gf >= 0 && enemyEnergy > 0.0; --gf) {
            if (w.waveGuessFactors[gf] <= w.waveGuessFactors[bestGF]) continue;
            bestGF = gf;
        }
        this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.bot.getGunHeadingRadians() + w.bearingDirection * (double)(bestGF - 15))));
        if (this.bot.getEnergy() > 1.0 || distanceIndex == 0) {
            this.bot.setFire(bulletPower);
        }
    }

    private static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance) {
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    private static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    static {
        guessFactors = new int[3][5][3][3][8][31];
    }

    class MicroWave
    extends Condition {
        Point2D.Double firePosition;
        int[] waveGuessFactors;
        double enemyAbsBearing;
        double distance;
        double bearingDirection;
        double bulletVelocity;

        MicroWave() {
        }

        public boolean test() {
            double d;
            this.distance += this.bulletVelocity;
            if (enemyLocation.distance(this.firePosition) <= d + this.bulletVelocity) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(RaikoGun.absoluteBearing(this.firePosition, enemyLocation) - this.enemyAbsBearing)) / this.bearingDirection + 15.0);
                    this.waveGuessFactors[n] = this.waveGuessFactors[n] + 1;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                RaikoGun.this.bot.removeCustomEvent((Condition)this);
            }
            return false;
        }
    }
}

