/*
 * Decompiled with CFR 0.152.
 */
package demetrix.info;

import demetrix.info.SelfInfo;
import demetrix.misc.Physics;
import java.awt.geom.Point2D;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EnemyInfo {
    private static final double PI = Math.PI;
    private long ScanTime;
    private double PrevDistance;
    private double Distance;
    private double NextDistance;
    private double PrevHeading;
    private double Heading;
    private double HeadingChange;
    private double RelBearing;
    private double PrevAbsBearing;
    private double AbsBearing;
    private double NextAbsBearing;
    private double PrevVelocity;
    private double Velocity;
    private int RotationDir;
    private Point2D PrevPos;
    private Point2D Pos;
    private Point2D NextPos;
    private double PrevEnergy;
    private double Energy;
    private double EnergyChange;
    private boolean EnemyShoots;
    private double ShootBulletPower;
    private long LastShootTime;

    public void setInfo(SelfInfo self, ScannedRobotEvent enemyScan) {
        this.ScanTime = self.getTime();
        this.PrevDistance = this.Distance;
        this.Distance = enemyScan.getDistance();
        this.PrevEnergy = this.Energy;
        this.Energy = enemyScan.getEnergy();
        this.PrevHeading = this.Heading;
        this.Heading = enemyScan.getHeadingRadians();
        this.HeadingChange = this.Heading - this.PrevHeading;
        this.RelBearing = enemyScan.getBearingRadians();
        this.PrevAbsBearing = this.AbsBearing;
        this.AbsBearing = Utils.normalAbsoluteAngle((double)(self.getHeading() + this.RelBearing));
        this.PrevVelocity = this.Velocity;
        this.Velocity = enemyScan.getVelocity();
        this.RotationDir = this.Velocity == 0.0 ? 0 : (Math.sin((this.Velocity > 0.0 ? this.Heading : this.Heading + Math.PI) - this.AbsBearing) > 0.0 ? 1 : -1);
        this.EnergyChange += -Physics.getDamageOnWallHit(this.PrevVelocity - this.Velocity);
        double dNRG = this.PrevEnergy - this.Energy + this.EnergyChange;
        this.EnergyChange = 0.0;
        boolean bl = false;
        if (dNRG > 0.09 && dNRG < 3.01) {
            bl = this.EnemyShoots = true;
        }
        if (this.EnemyShoots) {
            this.ShootBulletPower = dNRG;
            this.LastShootTime = this.ScanTime - 1L;
        }
        this.PrevPos.setLocation(this.Pos);
        double X = self.getPosition().getX() + this.Distance * Math.sin(this.AbsBearing);
        double Y = self.getPosition().getY() + this.Distance * Math.cos(this.AbsBearing);
        this.Pos.setLocation(X, Y);
        this.NextPos.setLocation(X + this.Velocity * Math.sin(this.Heading), Y + this.Velocity * Math.cos(this.Heading));
        this.NextDistance = self.getNextPosition().distance(this.NextPos);
        double dX = this.NextPos.getX() - self.getNextPosition().getX();
        double dY = this.NextPos.getY() - self.getNextPosition().getY();
        this.NextAbsBearing = Utils.normalAbsoluteAngle((double)Math.atan2(dX, dY));
    }

    public void resetScanTime() {
        this.ScanTime = -1;
    }

    public void changeEnergy(double energy) {
        this.EnergyChange += energy;
    }

    public long getScanTime() {
        return this.ScanTime;
    }

    public double getDistance() {
        return this.Distance;
    }

    public double getNextDistance() {
        return this.NextDistance;
    }

    public double getHeading() {
        return this.Heading;
    }

    public double getHeadingChange() {
        return this.HeadingChange;
    }

    public double getRelativeBearing() {
        return this.RelBearing;
    }

    public double getPreviousAbsoluteBearing() {
        return this.PrevAbsBearing;
    }

    public double getAbsoluteBearing() {
        return this.AbsBearing;
    }

    public double getNextAbsoluteBearing() {
        return this.NextAbsBearing;
    }

    public double getPreviousVelocity() {
        return this.PrevVelocity;
    }

    public double getVelocity() {
        return this.Velocity;
    }

    public int getRotationDirection() {
        return this.RotationDir;
    }

    public Point2D getPreviousPosition() {
        return this.PrevPos;
    }

    public Point2D getPosition() {
        return this.Pos;
    }

    public Point2D getNextPosition() {
        return this.NextPos;
    }

    public double getEnergy() {
        return this.Energy;
    }

    public double getShootBulletPower() {
        return this.ShootBulletPower;
    }

    public long getLastShootTime() {
        return this.LastShootTime;
    }

    public boolean isEnemyShoots() {
        return this.EnemyShoots;
    }

    private final /* synthetic */ void this() {
        this.PrevPos = new Point2D.Double();
        this.Pos = new Point2D.Double();
        this.NextPos = new Point2D.Double();
    }

    public EnemyInfo() {
        this.this();
    }
}

