/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Heading;

public class Bearing {
    public static final Bearing ZERO = new Bearing(0.0);
    public static final Bearing PLUS_90 = new Bearing(90.0);
    public static final Bearing PLUS_180 = new Bearing(180.0);
    public static final Bearing MINUS_180 = new Bearing(-90.0);
    private final double mBearing;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    public static final Bearing valueOf(double brngVal) {
        Bearing answer = new Bearing(brngVal);
        return answer;
    }

    public static final Bearing valueOfFlip(Bearing brngVal) {
        Bearing answer = new Bearing(brngVal.Get() + 180.0);
        return answer;
    }

    private Bearing(double brngVal) {
        this.mBearing = this.Normalise(brngVal);
    }

    private double Normalise(double startVal) {
        boolean done = false;
        double brngVal = startVal;
        while (!done) {
            if (brngVal >= 180.0) {
                brngVal -= 360.0;
                continue;
            }
            if (brngVal < -180.0) {
                brngVal += 360.0;
                continue;
            }
            done = true;
        }
        return brngVal;
    }

    public final double Get() {
        return this.mBearing;
    }

    public final double GetAbs() {
        return Math.abs(this.mBearing);
    }

    public final boolean IsAligned() {
        boolean answer = false;
        if (this.mBearing >= -0.5 && this.mBearing <= 0.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsOpposed() {
        boolean answer = false;
        if (this.mBearing >= 179.5 || this.mBearing <= -179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsLeft90() {
        boolean answer = false;
        if (this.mBearing >= -90.5 && this.mBearing <= -89.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsRight90() {
        boolean answer = false;
        if (this.mBearing >= 89.5 && this.mBearing <= 90.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsLeftward() {
        boolean answer = false;
        if (this.mBearing < -0.5 && this.mBearing > -179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsRightward() {
        boolean answer = false;
        if (this.mBearing > 0.5 && this.mBearing < 179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsForward() {
        boolean answer = false;
        if (this.mBearing >= -90.0 && this.mBearing <= 90.0) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsBackward() {
        boolean answer = false;
        if (this.mBearing < -90.0 || this.mBearing > 90.0) {
            answer = true;
        }
        return answer;
    }

    public static final Bearing valueOfFromTo(Heading fromHdng, Heading toHdng) {
        Bearing answer = new Bearing(toHdng.Get() - fromHdng.Get());
        return answer;
    }

    public static final Bearing valueOfFromTo(Bearing fromBrng, Bearing toBrng) {
        Bearing answer = new Bearing(toBrng.Get() - fromBrng.Get());
        return answer;
    }

    public String toString() {
        String answer = dp2.format(this.mBearing);
        return answer;
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

