/*
 * Decompiled with CFR 0.152.
 */
package synnalagma;

public class RobotMath {
    public static final int Q_1 = 0;
    public static final int Q_2 = 1;
    public static final int Q_3 = 2;
    public static final int Q_4 = 3;
    public static final double QUART_CERCLE = 1.5707963267948966;
    public static final double DEMI_CERCLE = Math.PI;
    public static final double CERCLE = Math.PI * 2;

    public static double NormaliseBearing(double d) {
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double NormaliseHeading(double d) {
        if (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double absbearing(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        return RobotMath.NormaliseHeading(Math.atan2(d5, d6));
    }

    public static double absoluteAngleRadians(double d, double d2) {
        double d3 = d2 + d;
        if (d3 >= Math.PI * 2) {
            d3 -= Math.PI * 2;
        } else if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public static int quadrant(double d) {
        int n = -1;
        while (d > 0.0) {
            d -= 1.5707963267948966;
            ++n;
        }
        return n;
    }

    public static int quadrantHuit(double d) {
        int n = -1;
        double d2 = 0.7853981633974483;
        while (d > 0.0) {
            d -= d2;
            ++n;
        }
        return n;
    }
}

