/*
 * Decompiled with CFR 0.152.
 */
package areb;

import areb.ActiveEnemyWaves;
import areb.EnemyWave;
import areb.Union;
import areb.Util;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Vector;

public class EnemyWaveStats {
    public static final int M_VELS = 3;
    public static final int M_DISTS = 3;
    public static final int M_ACCELS = 3;
    public static final int B_POWERS = 3;
    public static final double[] distance = new double[]{250.0, 500.0, 10000.0};
    public static final double[] velocity = new double[]{3.0, 6.0, 8.0};
    public static final int[] accel = new int[]{1, 0, -1};
    public static final double[] bulletPower = new double[]{1.0, 2.0, 3.0};
    private static double battleFieldX;
    private static double battleFieldY;
    private static int BIN_COUNT;
    private static double BIN_START;
    private static double BIN_END;
    private static double binInc;
    private static int LAST_N;
    private static int[] binCount;
    private static int[][][][] filterCount;
    private static int[][][][][] binFilterCount;
    private static Vector[] binAngle;
    private static Vector[][][][] filterAngle;
    private static Vector[][][][][] binFilterAngle;
    private static Vector binAll;
    private static int[] defaultBinEval;
    private static int totalCount;
    private boolean LOGGING;
    public static PrintStream out;

    public EnemyWaveStats(double d, double d2, boolean bl) {
        int n;
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        EnemyWaveStats.filterAngle[n][i][j][k] = new Vector();
                        for (int i2 = 0; i2 < BIN_COUNT; ++i2) {
                            EnemyWaveStats.binFilterAngle[n][i][j][k][i2] = new Vector();
                        }
                    }
                }
            }
        }
        for (n = 0; n < BIN_COUNT; ++n) {
            EnemyWaveStats.binAngle[n] = new Vector();
        }
        binAll = new Vector();
        battleFieldX = d;
        battleFieldY = d2;
        this.LOGGING = bl;
        binInc = (BIN_END - BIN_START) / ((double)BIN_COUNT - 2.0);
    }

    public void addHit(int n, int n2, int n3, int n4, double d) {
        Wave wave = new Wave(d);
        int n5 = this.findBin(d);
        ++totalCount;
        binAll.add(wave);
        int n6 = n5;
        binCount[n6] = binCount[n6] + 1;
        binAngle[n5].add(wave);
        filterAngle[n][n2][n3][n4].add(wave);
        int[] nArray = filterCount[n][n2][n3];
        int n7 = n4;
        nArray[n7] = nArray[n7] + 1;
        int[] nArray2 = binFilterCount[n][n2][n3][n4];
        int n8 = n5;
        nArray2[n8] = nArray2[n8] + 1;
        binFilterAngle[n][n2][n3][n4][n5].add(wave);
    }

    private void countReport() {
        for (int i = 0; i < BIN_COUNT; ++i) {
            System.out.print(binCount[i] + ",");
        }
        System.out.print("\n");
    }

    public int findBin(double d) {
        int n = -1;
        if (d < BIN_START) {
            n = 0;
        } else if (d > BIN_END) {
            n = BIN_COUNT - 1;
        } else {
            for (int i = 1; i < BIN_COUNT - 1; ++i) {
                double d2 = BIN_START + binInc * (double)i;
                if (!(d <= d2)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public double[] getMoveGuess(int n, int n2, int n3, int n4) {
        double[] dArray;
        if (totalCount == 0) {
            dArray = this.getAngleArr(defaultBinEval);
        } else if (filterCount[n][n2][n3][n4] < 3) {
            int[] nArray = this.getBinOrder(binCount);
            dArray = this.getAngleArr(nArray);
        } else {
            int[] nArray = this.getBinOrder(binFilterCount[n][n2][n3][n4]);
            dArray = this.getAngleArr(nArray);
        }
        return dArray;
    }

    public double evaluate(double d, ActiveEnemyWaves activeEnemyWaves, double[] dArray, double[] dArray2, double d2, double d3, double d4, double d5) {
        int n;
        EnemyWave enemyWave = activeEnemyWaves.getFurthestWave(d2, d3);
        double[] dArray3 = new double[activeEnemyWaves.getWaveCount()];
        double[] dArray4 = new double[activeEnemyWaves.getWaveCount()];
        double[] dArray5 = new double[activeEnemyWaves.getWaveCount()];
        double d6 = enemyWave.getDistanceFrom(d2, d3);
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < activeEnemyWaves.getWaveCount(); ++i) {
            EnemyWave enemyWave2 = activeEnemyWaves.get(i);
            dArray3[i] = d6 - Math.abs(d6 * 0.5 - enemyWave2.getDistanceFrom(d2, d3));
            int n2 = i;
            dArray3[n2] = dArray3[n2] * dArray3[i];
            d7 += dArray3[i];
            dArray4[i] = enemyWave2.getWavePower() / 3.0;
            d8 += dArray4[i];
        }
        double d9 = (d > 0.0 ? dArray[1] : dArray2[1]) * Math.abs(d);
        double[] dArray6 = this.getBinIntersections(d, d9, d2, d3, d4, d5, activeEnemyWaves);
        block1: for (int i = 0; i < activeEnemyWaves.getWaveCount(); ++i) {
            int n3;
            int[] nArray;
            int n4;
            int n5;
            int n6;
            EnemyWave enemyWave3 = activeEnemyWaves.get(i);
            n = this.findBin(dArray6[i]);
            int n7 = enemyWave3.getMDist();
            if (filterCount[n7][n6 = enemyWave3.getMVel()][n5 = enemyWave3.getMAccel()][n4 = enemyWave3.getBPower()] > 0) {
                if (binFilterCount[n7][n6][n5][n4][n] == 0) {
                    dArray5[i] = 1.0;
                    continue;
                }
                nArray = this.getBinOrder(binFilterCount[n7][n6][n5][n4]);
                for (n3 = 0; n3 < BIN_COUNT; ++n3) {
                    if (nArray[n3] != n) continue;
                    dArray5[i] = ((double)BIN_COUNT - (double)n3) / (double)BIN_COUNT + 0.01 * (double)Math.abs(nArray[0] - n3) + 0.01 * (double)Math.abs(nArray[1] - n3) + 0.01 * (double)Math.abs(nArray[2] - n3);
                    continue block1;
                }
                continue;
            }
            if (binCount[n] == 0) {
                dArray5[i] = 1.0;
                continue;
            }
            nArray = this.getBinOrder(binCount);
            for (n3 = 0; n3 < BIN_COUNT; ++n3) {
                if (nArray[n3] != n) continue;
                dArray5[i] = ((double)BIN_COUNT - (double)n3) / (double)BIN_COUNT + 0.01 * (double)Math.abs(nArray[0] - n3) + 0.01 * (double)Math.abs(nArray[1] - n3) + 0.01 * (double)Math.abs(nArray[2] - n3);
                continue block1;
            }
        }
        double d10 = 0.0;
        for (n = 0; n < activeEnemyWaves.getWaveCount(); ++n) {
            EnemyWave enemyWave4 = activeEnemyWaves.get(n);
            double d11 = dArray3[n] / d7 * 0.75;
            d10 += dArray5[n] * (d11 += dArray4[n] / d8 * 0.25);
        }
        return d10;
    }

    public double[] getBinIntersections(double d, double d2, double d3, double d4, double d5, double d6, ActiveEnemyWaves activeEnemyWaves) {
        int n;
        double d7;
        double d8 = d3;
        double d9 = d4;
        double d10 = d5;
        EnemyWave enemyWave = activeEnemyWaves.getFurthestWave(d3, d4);
        double d11 = d7 = enemyWave.getInitHeading();
        if (enemyWave.getMyDir() == -1) {
            d11 = Util.correctLargeAngle(d11 + 180.0);
        }
        double d12 = d6;
        if (d5 < 0.0) {
            d12 = Util.correctLargeAngle(d12 + 180.0);
            d10 *= -1.0;
        }
        double d13 = d12;
        if (d > 0.0 && Math.abs(Util.getRelativeAngle(d12, d11)) > 90.0 || d < 0.0 && Math.abs(Util.getRelativeAngle(d12, d11)) < 90.0) {
            d13 = d12 = Util.correctLargeAngle(d12 + 180.0);
            d10 *= -1.0;
        }
        double[] dArray = new double[activeEnemyWaves.getWaveCount()];
        boolean[] blArray = new boolean[activeEnemyWaves.getWaveCount()];
        double[] dArray2 = new double[activeEnemyWaves.getWaveCount()];
        double[] dArray3 = new double[activeEnemyWaves.getWaveCount()];
        double[] dArray4 = new double[activeEnemyWaves.getWaveCount()];
        for (int i = 0; i < activeEnemyWaves.getWaveCount(); ++i) {
            dArray[i] = activeEnemyWaves.get(i).getWaveDist();
            blArray[i] = false;
            dArray3[i] = activeEnemyWaves.get(i).getFireX();
            dArray4[i] = activeEnemyWaves.get(i).getFireY();
        }
        double d14 = Math.sin(Math.toRadians(d13));
        double d15 = Math.cos(Math.toRadians(d13));
        double d16 = d10 * d14;
        double d17 = d10 * Math.cos(Math.toRadians(d13));
        int n2 = 0;
        while (d2 > 2.0) {
            if (d2 <= 16.0 && d10 == 8.0) {
                d16 = (d10 -= 2.0) * d14;
                d17 = d10 * d15;
            } else if (d2 <= 9.0 && d10 >= 6.0) {
                d16 = (d10 -= 2.0) * d14;
                d17 = d10 * d15;
            } else if (d2 <= 4.0 && d10 >= 4.0) {
                d16 = (d10 -= 2.0) * d14;
                d17 = d10 * d15;
            } else if (d2 <= 1.0 && d10 >= 2.0) {
                d16 = (d10 -= 2.0) * d14;
                d17 = d10 * d15;
            } else if (d10 < 0.0) {
                d16 = (d10 += 2.0) * d14;
                d17 = d10 * d15;
            } else if (d10 < 8.0) {
                d16 = (d10 += 1.0) * d14;
                d17 = d10 * d15;
            }
            d8 += d16;
            d9 += d17;
            d2 -= d10;
            for (n = 0; n < activeEnemyWaves.getWaveCount(); ++n) {
                if (blArray[n]) continue;
                int n3 = n;
                dArray[n3] = dArray[n3] + activeEnemyWaves.get(n).getWaveVel();
                boolean bl = blArray[n] = Util.distance(dArray3[n], dArray4[n], d8, d9) - 18.0 < dArray[n] && d8 < Union.battleFieldWidth && d8 > 0.0 && d9 < Union.battleFieldHeight && d9 > 0.0;
                if (!blArray[n]) continue;
                dArray2[n] = activeEnemyWaves.get(n).getAngle(d8, d9);
            }
            if (++n2 <= 100) continue;
            System.out.println("RED ALERT (evaluation)!!! " + d16 + "," + d17 + ", " + activeEnemyWaves.getWaveCount() + ", " + d2);
            break;
        }
        for (n = 0; n < activeEnemyWaves.getWaveCount(); ++n) {
            if (blArray[n]) continue;
            dArray2[n] = activeEnemyWaves.get(n).getAngle(d8, d9);
        }
        return dArray2;
    }

    private boolean allIntersected(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            return false;
        }
        return true;
    }

    private int[] getBinOrder(int[] nArray) {
        int[] nArray2 = (int[])nArray.clone();
        int[] nArray3 = (int[])nArray.clone();
        int[] nArray4 = new int[nArray.length];
        Arrays.sort(nArray3);
        block0: for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray3[i] != nArray2[j]) continue;
                nArray4[i] = j;
                nArray2[j] = -1;
                continue block0;
            }
        }
        return nArray4;
    }

    private double[] getAngleArr(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = BIN_START + binInc * (double)nArray[i];
        }
        return dArray;
    }

    public int getMDist(double d) {
        for (int i = 0; i < 3; ++i) {
            if (!(d <= distance[i])) continue;
            return i;
        }
        return -1;
    }

    public int getMVel(double d) {
        for (int i = 0; i < 3; ++i) {
            if (!(d <= velocity[i])) continue;
            return i;
        }
        return -1;
    }

    public int getMAccel(double d, double d2) {
        int n = d > d2 ? 0 : (d == d2 ? 1 : 2);
        return n;
    }

    public int getBPower(double d) {
        if (d <= 1.0) {
            return 0;
        }
        if (d <= 2.0) {
            return 1;
        }
        return 2;
    }

    static {
        BIN_COUNT = 12;
        BIN_START = -1.0;
        BIN_END = 1.0;
        LAST_N = 10;
        binCount = new int[BIN_COUNT];
        filterCount = new int[3][3][3][3];
        binFilterCount = new int[3][3][3][3][BIN_COUNT];
        binAngle = new Vector[BIN_COUNT];
        filterAngle = new Vector[3][3][3][3];
        binFilterAngle = new Vector[3][3][3][3][BIN_COUNT];
        binAll = new Vector();
        defaultBinEval = new int[]{9, 2, 7, 4, 5, 3, 6, 8, 10, 1, 11, 0};
    }

    class Wave {
        private double angle;

        Wave(double d) {
            this.angle = d;
        }

        public double getAngle() {
            return this.angle;
        }
    }
}

