/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import pedersen.util.BaseConstraints;
import pedersen.util.Conversions;
import robocode.Rules;

public class BaseConversions
extends BaseConstraints {
    private static final double vehicularTurnRateScalar = 0.01308996938995747;

    public static double getAbsMaxTurnRateFromVelocity(double velocity) {
        return maxAbsVehicularTurnRate - 0.01308996938995747 * Math.abs(velocity);
    }

    public static double getAbsMaxVelocityFromTurnRate(double theta) {
        return (maxAbsVehicularTurnRate - theta) / 0.01308996938995747;
    }

    public static double getMinTurnRadiusFromVelocity(double velocity) {
        double theta = Conversions.getAbsMaxTurnRateFromVelocity(velocity);
        return BaseConversions.getTurnRadiusByVelocityAndTurnRate(velocity, theta);
    }

    public static double getMinTurnRadiusFromTurnRate(double theta) {
        double velocity = BaseConversions.getAbsMaxVelocityFromTurnRate(theta);
        return BaseConversions.getTurnRadiusByVelocityAndTurnRate(velocity, theta);
    }

    private static double getTurnRadiusByVelocityAndTurnRate(double velocity, double theta) {
        return velocity == 0.0 ? 0.0 : Math.abs(0.5 * velocity / Math.sin(0.5 * theta));
    }

    public static double getVelocityFromTurnRadiusAndTurnRate(double radius, double theta) {
        return 2.0 * radius * Math.sin(0.5 * theta);
    }

    public static double getTurnRateFromTurnRadiusAndVelocity(double radius, double velocity) {
        return 2.0 * Math.asin(0.5 * velocity / radius);
    }

    public static double getBulletDamageFromFirepower(double firepower) {
        return Rules.getBulletDamage((double)firepower);
    }

    public static double getFirepowerFromBulletDamage(double damage) {
        return Math.min(damage * 0.25, (damage + 2.0) / 6.0);
    }

    public static double getBulletVelocityFromFirepower(double firepower) {
        return Rules.getBulletSpeed((double)firepower);
    }

    public static double getFirepowerFromBulletVelocity(double velocity) {
        return (20.0 - velocity) / 3.0;
    }

    public static double getEnergyRewardFromFirepower(double firepower) {
        return Rules.getBulletHitBonus((double)firepower);
    }

    public static double getFirepowerFromEnergyReward(double energy) {
        return energy / 3.0;
    }

    public static double degreesToRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double radiansToDegrees(double radians) {
        return 180.0 * radians / Math.PI;
    }

    public static double getHypoteneuse(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }
}

